/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.cgram.types;

import com.jogamp.gluegen.cgram.types.MemoryLayoutType;
import com.jogamp.gluegen.cgram.types.SizeThunk;
import com.jogamp.gluegen.cgram.types.Type;
import com.jogamp.gluegen.cgram.types.TypeVisitor;

public class ArrayType
extends MemoryLayoutType
implements Cloneable {
    private Type elementType;
    private int length;
    private String computedName;

    public ArrayType(Type type, SizeThunk sizeThunk, int n, int n2) {
        super(type.getName() + " *", sizeThunk, n2);
        this.elementType = type;
        this.length = n;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof ArrayType)) {
            return false;
        }
        ArrayType arrayType = (ArrayType)object;
        return super.equals(object) && this.elementType.equals(arrayType.elementType) && this.length == arrayType.length;
    }

    @Override
    public String getName(boolean bl) {
        if (this.computedName == null) {
            this.computedName = this.elementType.getName() + " *";
            this.computedName = this.computedName.intern();
        }
        return this.computedName;
    }

    @Override
    public ArrayType asArray() {
        return this;
    }

    public Type getElementType() {
        return this.elementType;
    }

    public int getLength() {
        return this.length;
    }

    public boolean hasLength() {
        return this.length >= 0;
    }

    public Type getBaseElementType() {
        ArrayType arrayType = this;
        while (arrayType.getElementType().isArray()) {
            arrayType = arrayType.getElementType().asArray();
        }
        return arrayType.getElementType();
    }

    void recomputeSize() {
        ArrayType arrayType = this.getElementType().asArray();
        if (arrayType != null) {
            arrayType.recomputeSize();
        }
        super.setSize(SizeThunk.mul(SizeThunk.constant(this.getLength()), this.elementType.getSize()));
    }

    @Override
    public String toString() {
        return this.toString(null);
    }

    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.elementType.getName());
        if (string != null) {
            stringBuilder.append(" ");
            stringBuilder.append(string);
        }
        stringBuilder.append("[");
        stringBuilder.append(this.length);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public void visit(TypeVisitor typeVisitor) {
        super.visit(typeVisitor);
        this.elementType.visit(typeVisitor);
    }

    @Override
    Type newCVVariant(int n) {
        return new ArrayType(this.elementType, this.getSize(), this.length, n);
    }
}

