/*
 * Decompiled with CFR 0.152.
 */
package javaxt.sql;

import java.sql.ResultSet;
import javaxt.sql.Key;
import javaxt.sql.Table;

public class Column {
    private String Name;
    private String Description;
    private String Type;
    private String Length;
    private String IsRequired;
    private boolean isPrimaryKey = false;
    private boolean isForeignKey = false;
    private Table Table;
    private Key ForeignKey;

    protected Column(ResultSet rs, Table table) throws Exception {
        this.Name = rs.getString("COLUMN_NAME");
        this.Type = rs.getString("TYPE_NAME");
        this.Length = rs.getString("COLUMN_SIZE");
        this.Description = rs.getString("REMARKS");
        this.IsRequired = rs.getString("IS_NULLABLE");
        this.Table = table;
    }

    public String getName() {
        return this.Name;
    }

    public String getType() {
        return this.Type;
    }

    public Table getTable() {
        return this.Table;
    }

    public String getDescription() {
        if (this.Description == null) {
            return "";
        }
        return this.Description;
    }

    public int getLength() {
        if (this.Length == null) {
            return 0;
        }
        return Integer.valueOf(this.Length);
    }

    public boolean isRequired() {
        if (this.IsRequired == null) {
            return true;
        }
        this.IsRequired = this.IsRequired.trim();
        return this.IsRequired.equalsIgnoreCase("NO");
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    protected void setIsPrimaryKey(boolean isPrimaryKey) {
        this.isPrimaryKey = isPrimaryKey;
    }

    public boolean isForeignKey() {
        return this.isForeignKey;
    }

    protected void setForeignKey(Key key) {
        this.ForeignKey = key;
        this.isForeignKey = true;
    }

    public Key getForeignKey() {
        return this.ForeignKey;
    }

    public String toString() {
        return this.Table.getName() + "." + this.Name;
    }
}

