/*
 * Decompiled with CFR 0.152.
 */
package javaxt.sql;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import javaxt.sql.Column;
import javaxt.sql.Connection;
import javaxt.sql.Database;
import javaxt.sql.Driver;
import javaxt.sql.Field;
import javaxt.sql.Key;
import javaxt.sql.Parser;
import javaxt.sql.Table;
import javaxt.sql.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Recordset {
    private ResultSet rs = null;
    private java.sql.Connection Conn = null;
    private Statement stmt = null;
    private int x;
    private boolean isReadOnly = true;
    private String sqlString = null;
    private Connection Connection = null;
    private Driver driver = null;
    private Value GeneratedKey;
    public int State = 0;
    public boolean EOF = false;
    private Field[] Fields = null;
    public int MaxRecords = 1000000000;
    public int RecordCount;
    public long QueryResponseTime;
    public long EllapsedTime;
    public long MetadataQueryTime;
    private long startTime;
    private long endTime;
    private Integer fetchSize = null;
    private boolean InsertOnUpdate = false;

    public boolean isOpen() {
        if (this.State != 0) {
            String[] arr = System.getProperty("java.version").split("\\.");
            if (Integer.valueOf(arr[0]) == 1 && Integer.valueOf(arr[1]) < 6) {
                return false;
            }
            try {
                return (Boolean)this.rs.getClass().getMethod("isClosed", new Class[0]).invoke((Object)this.rs, null) == false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public ResultSet open(String sql, Connection conn) throws SQLException {
        return this.open(sql, conn, true);
    }

    public ResultSet open(String sqlString, Connection Connection2, boolean ReadOnly) throws SQLException {
        block39: {
            this.rs = null;
            this.stmt = null;
            this.State = 0;
            this.EOF = true;
            this.sqlString = sqlString;
            this.Connection = Connection2;
            this.isReadOnly = ReadOnly;
            this.driver = Connection2.getDatabase().getDriver();
            if (Connection2 == null) {
                throw new SQLException("Connection is null.");
            }
            if (Connection2.isClosed()) {
                throw new SQLException("Connection is closed.");
            }
            this.startTime = Calendar.getInstance().getTimeInMillis();
            this.Conn = Connection2.getConnection();
            if (ReadOnly) {
                try {
                    if (this.fetchSize != null) {
                        this.Conn.setAutoCommit(false);
                    }
                    this.stmt = this.driver.equals("DB2") || this.driver.equals("SQLite") ? this.Conn.createStatement(1003, 1007) : this.Conn.createStatement(1004, 1007);
                    if (this.fetchSize != null) {
                        this.stmt.setFetchSize(this.fetchSize);
                    }
                    this.rs = this.stmt.executeQuery(sqlString);
                    this.State = 1;
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (this.State != 1) {
                    if (this.fetchSize != null) {
                        this.Conn.setAutoCommit(false);
                    }
                    this.stmt = this.Conn.createStatement();
                    if (this.fetchSize != null) {
                        this.stmt.setFetchSize(this.fetchSize);
                    }
                    this.rs = this.stmt.executeQuery(sqlString);
                    this.State = 1;
                }
            } else {
                if (this.driver.equals("SYBASE")) {
                    if (this.fetchSize != null) {
                        this.Conn.setAutoCommit(false);
                    }
                    this.stmt = this.Conn.createStatement(1003, 1008);
                    if (this.fetchSize != null) {
                        this.stmt.setFetchSize(this.fetchSize);
                    }
                    this.rs = this.stmt.executeQuery(sqlString);
                    this.State = 1;
                    break block39;
                }
                if (this.driver.equals("SQLite")) {
                    if (this.fetchSize != null) {
                        this.Conn.setAutoCommit(false);
                    }
                    this.stmt = this.Conn.createStatement(1003, 1007);
                    if (this.fetchSize != null) {
                        this.stmt.setFetchSize(this.fetchSize);
                    }
                    this.rs = this.stmt.executeQuery(sqlString);
                    this.State = 1;
                    break block39;
                }
                if (this.driver.equals("DB2")) {
                    try {
                        if (this.fetchSize != null) {
                            this.Conn.setAutoCommit(false);
                        }
                        this.stmt = this.Conn.createStatement(1005, 1008);
                        if (this.fetchSize != null) {
                            this.stmt.setFetchSize(this.fetchSize);
                        }
                        this.rs = this.stmt.executeQuery(sqlString);
                        this.State = 1;
                    }
                    catch (Exception e) {
                        this.rs = null;
                    }
                    if (this.rs == null) {
                        try {
                            if (this.fetchSize != null) {
                                this.Conn.setAutoCommit(false);
                            }
                            this.stmt = this.Conn.createStatement(1003, 1008);
                            if (this.fetchSize != null) {
                                this.stmt.setFetchSize(this.fetchSize);
                            }
                            this.rs = this.stmt.executeQuery(sqlString);
                            this.State = 1;
                        }
                        catch (Exception e) {}
                    }
                    break block39;
                }
                if (this.fetchSize != null) {
                    this.Conn.setAutoCommit(false);
                }
                this.stmt = this.Conn.createStatement(1005, 1008);
                if (this.fetchSize != null) {
                    this.stmt.setFetchSize(this.fetchSize);
                }
                this.rs = this.stmt.executeQuery(sqlString);
                this.State = 1;
            }
        }
        this.endTime = Calendar.getInstance().getTimeInMillis();
        this.QueryResponseTime = this.endTime - this.startTime;
        try {
            int i;
            ResultSetMetaData rsmd = this.rs.getMetaData();
            int cols = rsmd.getColumnCount();
            this.Fields = new Field[cols];
            for (i = 1; i <= cols; ++i) {
                this.Fields[i - 1] = new Field(i, rsmd);
            }
            rsmd = null;
            this.x = -1;
            if (this.rs != null) {
                if (this.rs.next()) {
                    this.EOF = false;
                    for (i = 1; i <= cols; ++i) {
                        this.Fields[i - 1].Value = new Value(this.rs.getObject(i));
                    }
                    ++this.x;
                }
                this.MetadataQueryTime = 0L;
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        return this.rs;
    }

    public void close() {
        if (this.State == 1) {
            try {
                this.rs.close();
                this.stmt.close();
                this.State = 0;
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        this.rs = null;
        this.stmt = null;
        this.driver = null;
        this.sqlString = null;
        if (this.Fields != null) {
            for (Field f : this.Fields) {
                f.clear();
                f = null;
            }
            this.Fields = null;
        }
        this.endTime = Calendar.getInstance().getTimeInMillis();
        this.EllapsedTime = this.endTime - this.startTime;
    }

    public Database getDatabase() {
        return this.Connection.getDatabase();
    }

    public void setFetchSize(int fetchSize) {
        if (fetchSize > 0) {
            this.fetchSize = fetchSize;
        }
    }

    public Connection getConnection() {
        return this.Connection;
    }

    public void commit() {
        try {
            this.Conn.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addNew() {
        if (this.State == 1) {
            try {
                if (!this.driver.equals("DB2") && !this.driver.equals("SQLite")) {
                    this.rs.moveToInsertRow();
                }
                this.InsertOnUpdate = true;
                for (int i = 1; i <= this.Fields.length; ++i) {
                    Field Field2 = this.Fields[i - 1];
                    Field2.Value = null;
                    Field2.RequiresUpdate = false;
                }
            }
            catch (Exception e) {
                System.err.println("AddNew ERROR: " + e.toString());
            }
        }
    }

    public void update() throws SQLException {
        block87: {
            if (this.isReadOnly) {
                throw new SQLException("Read only!");
            }
            if (this.State == 1) {
                int i;
                if (!this.isDirty()) {
                    return;
                }
                boolean usePreparedStatement = false;
                if (this.driver.equals("DB2") || this.driver.equals("SQLite")) {
                    usePreparedStatement = true;
                } else if (this.driver.equals("PostgreSQL")) {
                    usePreparedStatement = true;
                    for (i = 0; i < this.Fields.length; ++i) {
                        Object value = null;
                        value = this.Fields[i].getValue().toObject();
                        if (value == null || !value.getClass().getPackage().getName().startsWith("javaxt.geospatial.geometry")) continue;
                        this.Fields[i].Value = new Value(this.getGeometry(value));
                        break;
                    }
                }
                if (this.InsertOnUpdate) {
                    usePreparedStatement = true;
                }
                if (!usePreparedStatement) {
                    for (i = 0; i < this.Fields.length; ++i) {
                        String FieldName = this.Fields[i].getName();
                        String FieldType = this.Fields[i].Class;
                        Value FieldValue = this.Fields[i].getValue();
                        if (FieldName == null || !this.Fields[i].RequiresUpdate) continue;
                        if ((FieldType = FieldType.toLowerCase()).contains(".")) {
                            FieldType = FieldType.substring(FieldType.lastIndexOf(".") + 1);
                        }
                        if (FieldType.indexOf("string") >= 0) {
                            this.rs.updateString(FieldName, FieldValue.toString());
                        } else if (FieldType.indexOf("int") >= 0) {
                            this.rs.updateInt(FieldName, (int)FieldValue.toInteger());
                        } else if (FieldType.indexOf("short") >= 0) {
                            this.rs.updateShort(FieldName, (short)FieldValue.toShort());
                        } else if (FieldType.indexOf("long") >= 0) {
                            this.rs.updateLong(FieldName, (long)FieldValue.toLong());
                        } else if (FieldType.indexOf("double") >= 0) {
                            this.rs.updateDouble(FieldName, (double)FieldValue.toDouble());
                        } else if (FieldType.indexOf("float") >= 0) {
                            this.rs.updateDouble(FieldName, (double)FieldValue.toFloat().floatValue());
                        } else if (FieldType.indexOf("decimal") >= 0) {
                            this.rs.updateBigDecimal(FieldName, FieldValue.toBigDecimal());
                        } else if (FieldType.indexOf("timestamp") >= 0) {
                            this.rs.updateTimestamp(FieldName, FieldValue.toTimeStamp());
                        } else if (FieldType.indexOf("date") >= 0) {
                            this.rs.updateDate(FieldName, new Date(FieldValue.toDate().getTime()));
                        } else if (FieldType.indexOf("bool") >= 0) {
                            this.rs.updateBoolean(FieldName, (boolean)FieldValue.toBoolean());
                        } else if (FieldType.indexOf("object") >= 0) {
                            this.rs.updateObject(FieldName, FieldValue.toObject());
                        }
                        if (FieldValue == null || FieldValue.isNull() || !FieldValue.toObject().getClass().getPackage().getName().startsWith("javaxt.geospatial.geometry")) continue;
                        this.rs.updateObject(FieldName, (Object)this.getGeometry(FieldValue));
                    }
                    this.rs.updateRow();
                    break block87;
                }
                ArrayList<Field> fields = new ArrayList<Field>();
                for (Field field : this.Fields) {
                    if (field.getName() == null || !field.RequiresUpdate) continue;
                    fields.add(field);
                }
                int numUpdates = fields.size();
                String tableName = this.Fields[0].getTable();
                if (tableName.contains(" ")) {
                    tableName = "[" + tableName + "]";
                }
                StringBuffer sql = new StringBuffer();
                if (this.InsertOnUpdate) {
                    int i2;
                    sql.append("INSERT INTO " + tableName + " (");
                    for (i2 = 0; i2 < numUpdates; ++i2) {
                        String colName = ((Field)fields.get(i2)).getName();
                        if (colName.contains(" ")) {
                            colName = "[" + colName + "]";
                        }
                        sql.append(colName);
                        if (numUpdates <= 1 || i2 >= numUpdates - 1) continue;
                        sql.append(",");
                    }
                    sql.append(") VALUES (");
                    for (i2 = 0; i2 < numUpdates; ++i2) {
                        sql.append("?");
                        if (numUpdates <= 1 || i2 >= numUpdates - 1) continue;
                        sql.append(",");
                    }
                    sql.append(")");
                } else {
                    ResultSet r2;
                    sql.append("UPDATE " + tableName + " SET ");
                    for (int i3 = 0; i3 < numUpdates; ++i3) {
                        String colName = ((Field)fields.get(i3)).getName();
                        if (colName.contains(" ")) {
                            colName = "[" + colName + "]";
                        }
                        sql.append(colName);
                        sql.append("=?");
                        if (numUpdates <= 1 || i3 >= numUpdates - 1) continue;
                        sql.append(", ");
                    }
                    ArrayList<Field> keys = new ArrayList<Field>();
                    try {
                        Key[] arr;
                        DatabaseMetaData dbmd = this.Conn.getMetaData();
                        r2 = dbmd.getTables(null, null, this.Fields[0].getTable(), new String[]{"TABLE"});
                        if (r2.next() && (arr = new Table(r2, dbmd).getPrimaryKeys()) != null) {
                            for (int i4 = 0; i4 < arr.length; ++i4) {
                                Key key = arr[i4];
                                Field field = this.getField(key.getName());
                                if (field == null) continue;
                                keys.add(field);
                            }
                        }
                        r2.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (!keys.isEmpty()) {
                        sql.append(" WHERE ");
                        for (int i5 = 0; i5 < keys.size(); ++i5) {
                            String colName;
                            Field field = (Field)keys.get(i5);
                            fields.add(field);
                            if (i5 > 0) {
                                sql.append(" AND ");
                            }
                            if ((colName = field.getName()).contains(" ")) {
                                colName = "[" + colName + "]";
                            }
                            sql.append(colName);
                            sql.append("=?");
                        }
                    } else {
                        String where = new Parser(this.sqlString).getWhereString();
                        if (where != null) {
                            sql.append(" WHERE ");
                            sql.append(where);
                        }
                        r2 = this.stmt.executeQuery("SELECT COUNT(*) FROM " + tableName + " WHERE " + (where == null ? "" : where));
                        int numRecords = r2.getInt(1);
                        r2.close();
                        if (numRecords > 1) {
                            StringBuffer msg = new StringBuffer();
                            msg.append("WARNING: Updating " + tableName + " table without a unique key.\r\n");
                            msg.append("Multiple rows may be affected with this update.\r\n");
                            try {
                                int x = 1 / 0;
                            }
                            catch (Exception e) {
                                ByteArrayOutputStream bas = new ByteArrayOutputStream();
                                PrintStream s = new PrintStream(bas, true);
                                e.printStackTrace(s);
                                s.close();
                                boolean append = false;
                                for (String line : bas.toString().split("\n")) {
                                    if (append) {
                                        msg.append("\t");
                                        msg.append(line.trim());
                                        msg.append("\r\n");
                                    }
                                    if (append || !line.contains(this.getClass().getCanonicalName())) continue;
                                    append = true;
                                }
                                System.err.println(msg);
                            }
                        }
                    }
                }
                PreparedStatement stmt = this.Conn.prepareStatement(sql.toString(), 1);
                int id = 1;
                for (int i6 = 0; i6 < fields.size(); ++i6) {
                    Field field = (Field)fields.get(i6);
                    String FieldType = field.Class.toLowerCase();
                    if (FieldType.contains(".")) {
                        FieldType = FieldType.substring(FieldType.lastIndexOf(".") + 1);
                    }
                    Value FieldValue = field.getValue();
                    if (FieldType.indexOf("string") >= 0) {
                        stmt.setString(id, FieldValue.toString());
                    } else if (FieldType.indexOf("int") >= 0) {
                        stmt.setInt(id, FieldValue.toInteger());
                    } else if (FieldType.indexOf("short") >= 0) {
                        stmt.setShort(id, FieldValue.toShort());
                    } else if (FieldType.indexOf("long") >= 0) {
                        stmt.setLong(id, FieldValue.toLong());
                    } else if (FieldType.indexOf("double") >= 0) {
                        stmt.setDouble(id, FieldValue.toDouble());
                    } else if (FieldType.indexOf("float") >= 0) {
                        stmt.setFloat(id, FieldValue.toFloat().floatValue());
                    } else if (FieldType.indexOf("decimal") >= 0) {
                        stmt.setBigDecimal(id, FieldValue.toBigDecimal());
                    } else if (FieldType.indexOf("timestamp") >= 0) {
                        stmt.setTimestamp(id, FieldValue.toTimeStamp());
                    } else if (FieldType.indexOf("date") >= 0) {
                        stmt.setDate(id, new Date(FieldValue.toDate().getTime()));
                    } else if (FieldType.indexOf("bool") >= 0) {
                        stmt.setBoolean(id, FieldValue.toBoolean());
                    } else if (FieldType.indexOf("object") >= 0) {
                        stmt.setObject(id, FieldValue.toObject());
                    }
                    if (FieldValue != null) {
                        try {
                            if (FieldValue.toObject().getClass().getPackage().getName().startsWith("javaxt.geospatial.geometry")) {
                                stmt.setObject(id, this.getGeometry(FieldValue));
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    ++id;
                }
                stmt.executeUpdate();
                if (this.InsertOnUpdate) {
                    ResultSet generatedKeys = stmt.getGeneratedKeys();
                    if (generatedKeys.next()) {
                        this.GeneratedKey = new Value(generatedKeys.getString(1));
                    }
                    this.InsertOnUpdate = false;
                }
            }
        }
    }

    public Value getGeneratedKey() {
        return this.GeneratedKey;
    }

    public Field[] getFields() {
        return this.Fields;
    }

    public Field getField(String FieldName) {
        if (this.Fields == null || this.Fields.length == 0) {
            return null;
        }
        if (FieldName == null) {
            return null;
        }
        if ((FieldName = FieldName.trim()).length() == 0) {
            return null;
        }
        String[] arr = FieldName.split("\\.");
        for (Field field : this.Fields) {
            String schemaName;
            String fieldName = field.getName();
            if (fieldName == null) continue;
            String tableName = field.getTable() == null ? "" : field.getTable();
            String string2 = schemaName = field.getSchema() == null ? "" : field.getSchema();
            if (!(arr.length == 3 ? fieldName.equalsIgnoreCase(arr[2]) && tableName.equalsIgnoreCase(arr[1]) && schemaName.equalsIgnoreCase(arr[0]) : (arr.length == 2 ? fieldName.equalsIgnoreCase(arr[1]) && tableName.equalsIgnoreCase(arr[0]) : arr.length == 1 && fieldName.equalsIgnoreCase(arr[0])))) continue;
            return field;
        }
        return null;
    }

    public Field getField(int i) {
        if (this.Fields != null && i < this.Fields.length) {
            return this.Fields[i];
        }
        return null;
    }

    public Value getValue(String FieldName) {
        Field field = this.getField(FieldName);
        if (field != null) {
            return field.getValue();
        }
        return new Value(null);
    }

    public Value getValue(int i) {
        if (this.Fields != null && i < this.Fields.length) {
            return this.Fields[i].getValue();
        }
        return new Value(null);
    }

    public boolean isDirty() {
        for (Field field : this.Fields) {
            if (!field.isDirty()) continue;
            return true;
        }
        return false;
    }

    public void setValue(String FieldName, Value FieldValue) {
        if (this.State == 1) {
            for (int i = 0; i < this.Fields.length; ++i) {
                String name = this.Fields[i].getName();
                if (name == null || !name.equalsIgnoreCase(FieldName)) continue;
                if (FieldValue == null) {
                    FieldValue = new Value(null);
                }
                if (this.Fields[i].getValue().equals(FieldValue)) break;
                this.Fields[i].Value = FieldValue;
                this.Fields[i].RequiresUpdate = true;
                break;
            }
        }
    }

    public void setValue(String FieldName, Object FieldValue) {
        this.setValue(FieldName, new Value(FieldValue));
    }

    public void setValue(String FieldName, boolean FieldValue) {
        this.setValue(FieldName, new Value(FieldValue));
    }

    public void setValue(String FieldName, long FieldValue) {
        this.setValue(FieldName, new Value(FieldValue));
    }

    public void setValue(String FieldName, int FieldValue) {
        this.setValue(FieldName, new Value(FieldValue));
    }

    public void setValue(String FieldName, double FieldValue) {
        this.setValue(FieldName, new Value(FieldValue));
    }

    public void setValue(String FieldName, short FieldValue) {
        this.setValue(FieldName, new Value(FieldValue));
    }

    public boolean hasNext() {
        return !this.EOF;
    }

    public boolean moveNext() {
        if (this.EOF) {
            return false;
        }
        if (this.x >= this.MaxRecords - 1) {
            this.EOF = true;
            return false;
        }
        try {
            if (this.rs.next()) {
                for (int i = 1; i <= this.Fields.length; ++i) {
                    Field Field2 = this.Fields[i - 1];
                    Field2.Value = new Value(this.rs.getObject(i));
                    Field2.RequiresUpdate = false;
                }
                ++this.x;
                return true;
            }
            this.EOF = true;
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void move(int numRecords) {
        block9: {
            boolean tryAgain = false;
            try {
                this.rs.absolute(numRecords);
                this.x += numRecords;
            }
            catch (Exception e) {
                tryAgain = true;
            }
            try {
                if (!tryAgain) break block9;
                int rowPosition = this.rs.getRow();
                while (this.rs.getRow() < numRecords + rowPosition) {
                    if (this.rs.next()) {
                        ++this.x;
                        continue;
                    }
                    this.EOF = true;
                    break;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            for (int i = 1; i <= this.Fields.length; ++i) {
                Field Field2 = this.Fields[i - 1];
                Field2.Value = new Value(this.rs.getObject(i));
                Field2.RequiresUpdate = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateFields() {
        if (this.Fields == null) {
            return;
        }
        boolean updateFields = false;
        for (Field field : this.Fields) {
            String fieldName = field.getName();
            if (fieldName == null) continue;
            if (field.getTable() == null) {
                updateFields = true;
                break;
            }
            if (field.getSchema() != null) continue;
            updateFields = true;
            break;
        }
        if (!updateFields) {
            return;
        }
        String[] selectedTables = new Parser(this.sqlString).getTables();
        ArrayList<Table> tables = new ArrayList<Table>();
        for (Table table : Database.getTables(this.Connection)) {
            for (String selectedTable : selectedTables) {
                if (selectedTable.contains(".")) {
                    selectedTable = selectedTable.substring(selectedTable.indexOf("."));
                }
                if (!selectedTable.equalsIgnoreCase(table.getName())) continue;
                tables.add(table);
            }
        }
        block3: for (Field field : this.Fields) {
            Column[] columns;
            if (field.getTable() == null && (columns = this.getColumns(field, tables)) != null) {
                Column column = columns[0];
                field.setTableName(column.getTable().getName());
                field.setSchemaName(column.getTable().getSchema());
            }
            if (field.getSchema() != null) continue;
            for (Table table : tables) {
                if (!table.getName().equalsIgnoreCase(field.getTable())) continue;
                field.setSchemaName(table.getSchema());
                continue block3;
            }
        }
        tables.clear();
        tables = null;
    }

    private Column[] getColumns(Field field, ArrayList<Table> tables) {
        ArrayList<Column> matches = new ArrayList<Column>();
        for (Table table : tables) {
            for (Column column : table.getColumns()) {
                if (!column.getName().equalsIgnoreCase(field.getName())) continue;
                matches.add(column);
            }
        }
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() == 1) {
            return new Column[]{(Column)matches.get(0)};
        }
        if (matches.size() > 1) {
            ArrayList<Column> columns = new ArrayList<Column>();
            for (Column column : matches) {
                if (!column.getType().equalsIgnoreCase(field.Type)) continue;
                columns.add(column);
            }
            if (columns.isEmpty()) {
                return null;
            }
            return columns.toArray(new Column[columns.size()]);
        }
        return null;
    }

    public int getRecordCount() {
        try {
            int currRow = this.rs.getRow();
            this.rs.last();
            int size = this.rs.getRow();
            this.rs.absolute(currRow);
            return size;
        }
        catch (Exception e) {
            Integer numRecords = null;
            String sql = new Parser(this.sqlString).setSelect("count(*)");
            Recordset rs = new Recordset();
            try {
                rs.open(sql, this.Connection);
                numRecords = rs.getValue(0).toInteger();
                rs.close();
            }
            catch (SQLException ex) {
                rs.close();
            }
            if (numRecords != null) {
                return numRecords;
            }
            return -1;
        }
    }

    private String getGeometry(Object FieldValue) {
        String geometryType = FieldValue.getClass().getCanonicalName().toString();
        geometryType = geometryType.substring(geometryType.lastIndexOf(".") + 1).trim().toUpperCase();
        if (this.driver.equals("PostgreSQL")) {
            return "ST_GeomFromText('" + FieldValue.toString() + "', 4326)";
        }
        if (this.driver.equals("SQLServer")) {
            return "STGeomFromText('" + FieldValue.toString() + "', 4326)";
        }
        if (this.driver.equals("DB2")) {
            if (geometryType.equals("LINE")) {
                String line = FieldValue.toString().toUpperCase().replace("LINESTRING", "LINE");
                return "db2GSE.ST_LINE('" + line + "', 2000000000)";
            }
            return "db2GSE.ST_" + geometryType + "('" + FieldValue.toString() + "', 2000000000)";
        }
        return null;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

