/*
 * Decompiled with CFR 0.152.
 */
package javaxt.webservices;

import java.util.ArrayList;
import javaxt.webservices.Method;
import javaxt.xml.DOM;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Service {
    private String Name = "";
    private String Description = "";
    private String URL = "";
    private String NameSpace;
    private Method[] Methods = null;

    protected Service(Node ServiceNode) {
        NamedNodeMap attr = ServiceNode.getAttributes();
        this.Name = DOM.getAttributeValue(attr, "name");
        this.NameSpace = DOM.getAttributeValue(attr, "namespace");
        this.URL = DOM.getAttributeValue(attr, "url");
        NodeList ChildNodes = ServiceNode.getChildNodes();
        for (int j = 0; j < ChildNodes.getLength(); ++j) {
            if (ChildNodes.item(j).getNodeType() != 1) continue;
            String NodeName = ChildNodes.item(j).getNodeName();
            String NodeValue = ChildNodes.item(j).getTextContent();
            if (NodeName.toLowerCase().equals("description")) {
                this.Description = NodeValue;
            }
            if (!NodeName.toLowerCase().equals("methods")) continue;
            NodeList methodNodes = ChildNodes.item(j).getChildNodes();
            ArrayList<Method> methods = new ArrayList<Method>();
            for (Node methodNode : DOM.getNodes(methodNodes)) {
                methods.add(new Method(methodNode));
            }
            if (methods.isEmpty()) continue;
            this.Methods = methods.toArray(new Method[methods.size()]);
        }
    }

    public String getName() {
        return this.Name;
    }

    public String getDescription() {
        return this.Description;
    }

    public String getURL() {
        return this.URL;
    }

    public String getNameSpace() {
        return this.NameSpace;
    }

    public Method[] getMethods() {
        return this.Methods;
    }

    public boolean equals(String ServiceName) {
        return this.Name.equalsIgnoreCase(ServiceName);
    }

    public Method getMethod(String MethodName) {
        if ((MethodName = MethodName == null ? "" : MethodName.trim()).equals("")) {
            return this.getMethod(0);
        }
        for (int i = 0; i < this.Methods.length; ++i) {
            if (!this.Methods[i].equals(MethodName)) continue;
            return this.Methods[i];
        }
        return null;
    }

    public Method getMethod(int i) {
        if (this.Methods == null) {
            return this.getMethod(0);
        }
        if (i < this.Methods.length) {
            return this.Methods[i];
        }
        return null;
    }

    public void setURL(String URL2) {
        this.URL = URL2;
    }
}

