/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.sonoview;

import edu.geophys.commons.detection.AbstractDetection;
import edu.geophys.commons.model.DefaultTrace;
import edu.geophys.commons.model.DefaultTraceMetadata;
import edu.geophys.commons.model.SNS;
import edu.geophys.commons.model.Site;
import edu.geophys.commons.model.TraceMetadata;
import edu.geophys.commons.resamplingmodes.DefaultResamplingModes;
import edu.geophys.commons.resamplingmodes.ResamplingMode;
import edu.geophys.commons.suite.EventFileManager;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.suite.TraceProvider;
import edu.geophys.commons.ui.BoundedLongRangeModel;
import edu.geophys.commons.ui.sonogram.ArraySonogramModel;
import edu.geophys.commons.ui.sonogram.DefaultArraySonogramModel;
import edu.geophys.commons.ui.sonogram.DefaultSonogramModel;
import edu.geophys.commons.ui.sonogram.SonogramModel;
import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.commons.util.MathUtil;
import edu.geophys.sonoview.PickedLongRangeModel;
import edu.geophys.sonoview.SonoViewManager;
import edu.geophys.sonoview.SonogramRenderer;
import edu.geophys.sonoview.swing.largesonogram.SonogramProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class DataManager {
    private static final DataManager instance = new DataManager();
    private boolean noiseCancelling = false;

    public static final DataManager getInstance() {
        return instance;
    }

    public static final SonogramProvider createSonogramProvider() {
        return new SonogramProviderImp();
    }

    public static final boolean isValidStationID(String string) {
        TraceProvider traceProvider = SuiteManager.INSTANCE.getTraceProvider();
        return traceProvider.hasStation(new String[]{string})[0];
    }

    private static DefaultTrace[] generatePartTraces(DefaultTrace[] defaultTraceArray, SNS sNS, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10) {
        int n;
        int n2;
        int n3;
        DefaultTrace[] defaultTraceArray2 = new DefaultTrace[2];
        for (n3 = 0; n3 < defaultTraceArray2.length; ++n3) {
            defaultTraceArray2[n3] = new DefaultTrace();
        }
        n3 = 0;
        if (bl) {
            ++n3;
        }
        if (bl2) {
            ++n3;
        }
        if (bl3) {
            ++n3;
        }
        if (bl4) {
            ++n3;
        }
        DefaultTrace[] defaultTraceArray3 = new DefaultTrace[4];
        for (n2 = 0; n2 < defaultTraceArray3.length; ++n2) {
            defaultTraceArray3[n2] = new DefaultTrace();
        }
        n2 = 0;
        if (bl7) {
            ++n2;
        }
        if (bl8) {
            ++n2;
        }
        if (bl9) {
            ++n2;
        }
        if (bl10) {
            ++n2;
        }
        DefaultTrace[] defaultTraceArray4 = new DefaultTrace[n2];
        for (n = 0; n < defaultTraceArray4.length; ++n) {
            defaultTraceArray4[n] = new DefaultTrace();
        }
        n = 1;
        int n4 = 0;
        int n5 = 3;
        int n6 = 2;
        int n7 = 0;
        int n8 = 1;
        int n9 = 0;
        int n10 = 1;
        int n11 = 2;
        int n12 = 3;
        ArrayList<DefaultTrace> arrayList = new ArrayList<DefaultTrace>();
        try {
            int n13;
            for (n13 = 0; n13 < defaultTraceArray.length; ++n13) {
                if (bl && defaultTraceArray[n13].getStationID().equals(sNS.getWest().getTraceZ())) {
                    defaultTraceArray3[n] = defaultTraceArray[n13].clone();
                    arrayList.add(defaultTraceArray3[n]);
                    continue;
                }
                if (bl2 && defaultTraceArray[n13].getStationID().equals(sNS.getNorth().getTraceZ())) {
                    defaultTraceArray3[n4] = defaultTraceArray[n13].clone();
                    arrayList.add(defaultTraceArray3[n4]);
                    continue;
                }
                if (bl3 && defaultTraceArray[n13].getStationID().equals(sNS.getCenter().getTraceZ())) {
                    defaultTraceArray3[n5] = defaultTraceArray[n13].clone();
                    arrayList.add(defaultTraceArray3[n5]);
                    continue;
                }
                if (bl4 && defaultTraceArray[n13].getStationID().equals(sNS.getEast().getTraceZ())) {
                    defaultTraceArray3[n6] = defaultTraceArray[n13].clone();
                    arrayList.add(defaultTraceArray3[n6]);
                    continue;
                }
                if (bl5 && defaultTraceArray[n13].getStationID().equals(sNS.getCenter().getTraceEW())) {
                    defaultTraceArray2[n7] = defaultTraceArray[n13].clone();
                    continue;
                }
                if (bl6 && defaultTraceArray[n13].getStationID().equals(sNS.getCenter().getTraceNS())) {
                    defaultTraceArray2[n8] = defaultTraceArray[n13].clone();
                    continue;
                }
                if (bl7 && defaultTraceArray[n13].getStationID().equals(sNS.getAux1().getTraceZ())) {
                    defaultTraceArray4[n9] = defaultTraceArray[n13].clone();
                    continue;
                }
                if (bl8 && defaultTraceArray[n13].getStationID().equals(sNS.getAux2().getTraceZ())) {
                    defaultTraceArray4[n10] = defaultTraceArray[n13].clone();
                    continue;
                }
                if (bl9 && defaultTraceArray[n13].getStationID().equals(sNS.getAux3().getTraceZ())) {
                    defaultTraceArray4[n11] = defaultTraceArray[n13].clone();
                    continue;
                }
                if (!bl10 || !defaultTraceArray[n13].getStationID().equals(sNS.getAux4().getTraceZ())) continue;
                defaultTraceArray4[n12] = defaultTraceArray[n13].clone();
            }
            if (n3 < 4 && n2 == 0) {
                n13 = 0;
                boolean bl11 = false;
                boolean bl12 = false;
                boolean bl13 = false;
                DefaultTrace defaultTrace = new DefaultTrace();
                if (bl3) {
                    defaultTrace = defaultTraceArray3[n5].clone();
                } else if (bl) {
                    defaultTrace = defaultTraceArray3[n].clone();
                } else if (bl4) {
                    defaultTrace = defaultTraceArray3[n6].clone();
                } else if (bl2) {
                    defaultTrace = defaultTraceArray3[n4].clone();
                }
                defaultTrace.setStationName("EMPTY");
                defaultTrace.setSamples(new float[defaultTrace.getSamples().length]);
                if (!bl) {
                    if (sNS.getWest() == null) {
                        n13 = 1;
                    } else if (sNS.getWest().getTraceActive().equals((Object)Site.TraceActive.EMPTY)) {
                        defaultTraceArray3[n] = defaultTrace;
                    } else if (sNS.getWest().getTraceActive().equals((Object)Site.TraceActive.NORTH)) {
                        defaultTraceArray3[n] = defaultTraceArray3[n4].clone();
                    } else if (sNS.getWest().getTraceActive().equals((Object)Site.TraceActive.CENTER)) {
                        defaultTraceArray3[n] = defaultTraceArray3[n5].clone();
                    } else if (sNS.getWest().getTraceActive().equals((Object)Site.TraceActive.EAST)) {
                        defaultTraceArray3[n] = defaultTraceArray3[n6].clone();
                    } else if (sNS.getWest().getTraceActive().equals((Object)Site.TraceActive.MEAN)) {
                        defaultTraceArray3[n] = DataManager.getMeanSonogram(arrayList);
                    }
                }
                if (!bl2) {
                    if (sNS.getNorth() == null) {
                        bl11 = true;
                    } else if (sNS.getNorth().getTraceActive().equals((Object)Site.TraceActive.EMPTY)) {
                        defaultTraceArray3[n4] = defaultTrace;
                    } else if (sNS.getNorth().getTraceActive().equals((Object)Site.TraceActive.WEST)) {
                        defaultTraceArray3[n4] = defaultTraceArray3[n].clone();
                    } else if (sNS.getNorth().getTraceActive().equals((Object)Site.TraceActive.CENTER)) {
                        defaultTraceArray3[n4] = defaultTraceArray3[n5].clone();
                    } else if (sNS.getNorth().getTraceActive().equals((Object)Site.TraceActive.EAST)) {
                        defaultTraceArray3[n4] = defaultTraceArray3[n6].clone();
                    } else if (sNS.getNorth().getTraceActive().equals((Object)Site.TraceActive.MEAN)) {
                        defaultTraceArray3[n4] = DataManager.getMeanSonogram(arrayList);
                    }
                }
                if (!bl3) {
                    if (sNS.getCenter() == null) {
                        bl12 = true;
                    } else if (sNS.getCenter().getTraceActive().equals((Object)Site.TraceActive.EMPTY)) {
                        defaultTraceArray3[n5] = defaultTrace;
                    } else if (sNS.getCenter().getTraceActive().equals((Object)Site.TraceActive.NORTH)) {
                        defaultTraceArray3[n5] = defaultTraceArray3[n4].clone();
                    } else if (sNS.getCenter().getTraceActive().equals((Object)Site.TraceActive.WEST)) {
                        defaultTraceArray3[n5] = defaultTraceArray3[n].clone();
                    } else if (sNS.getCenter().getTraceActive().equals((Object)Site.TraceActive.EAST)) {
                        defaultTraceArray3[n5] = defaultTraceArray3[n6].clone();
                    } else if (sNS.getCenter().getTraceActive().equals((Object)Site.TraceActive.MEAN)) {
                        defaultTraceArray3[n5] = DataManager.getMeanSonogram(arrayList);
                    }
                }
                if (!bl4) {
                    if (sNS.getEast() == null) {
                        bl13 = true;
                    } else if (sNS.getEast().getTraceActive().equals((Object)Site.TraceActive.EMPTY)) {
                        defaultTraceArray3[n6] = defaultTrace;
                    } else if (sNS.getEast().getTraceActive().equals((Object)Site.TraceActive.NORTH)) {
                        defaultTraceArray3[n6] = defaultTraceArray3[n4].clone();
                    } else if (sNS.getEast().getTraceActive().equals((Object)Site.TraceActive.CENTER)) {
                        defaultTraceArray3[n6] = defaultTraceArray3[n5].clone();
                    } else if (sNS.getEast().getTraceActive().equals((Object)Site.TraceActive.WEST)) {
                        defaultTraceArray3[n6] = defaultTraceArray3[n].clone();
                    } else if (sNS.getEast().getTraceActive().equals((Object)Site.TraceActive.MEAN)) {
                        defaultTraceArray3[n6] = DataManager.getMeanSonogram(arrayList);
                    }
                }
                int n14 = 0;
                if (n13 == 0) {
                    ++n14;
                }
                if (!bl11) {
                    ++n14;
                }
                if (!bl12) {
                    ++n14;
                }
                if (!bl13) {
                    ++n14;
                }
                if (n14 == 3) {
                    if (n13 != 0) {
                        defaultTraceArray3[n] = defaultTraceArray3[n4].clone();
                    } else if (bl13) {
                        defaultTraceArray3[n6] = defaultTraceArray3[n5].clone();
                    } else if (bl11) {
                        defaultTraceArray3[n4] = defaultTraceArray3[n].clone();
                    } else if (bl12) {
                        defaultTraceArray3[n5] = defaultTraceArray3[n6].clone();
                    }
                } else if (n14 == 2) {
                    if (n13 != 0 && bl11) {
                        defaultTraceArray3[n] = defaultTraceArray3[n5].clone();
                        defaultTraceArray3[n4] = defaultTraceArray3[n6].clone();
                    } else if (n13 != 0 && bl12) {
                        defaultTraceArray3[n] = defaultTraceArray3[n4].clone();
                        defaultTraceArray3[n5] = defaultTraceArray3[n6].clone();
                    } else if (n13 != 0 && bl13) {
                        defaultTraceArray3[n] = defaultTraceArray3[n5].clone();
                        defaultTraceArray3[n6] = defaultTraceArray3[n4].clone();
                    } else if (bl11 && bl12) {
                        defaultTraceArray3[n4] = defaultTraceArray3[n6].clone();
                        defaultTraceArray3[n5] = defaultTraceArray3[n].clone();
                    } else if (bl11 && bl13) {
                        defaultTraceArray3[n4] = defaultTraceArray3[n].clone();
                        defaultTraceArray3[n6] = defaultTraceArray3[n5].clone();
                    } else if (bl12 && bl13) {
                        defaultTraceArray3[n5] = defaultTraceArray3[n].clone();
                        defaultTraceArray3[n6] = defaultTraceArray3[n4].clone();
                    }
                } else if (n14 == 1) {
                    if (bl11 && bl12 && bl13) {
                        defaultTraceArray3[n4] = defaultTraceArray3[n].clone();
                        defaultTraceArray3[n5] = defaultTraceArray3[n].clone();
                        defaultTraceArray3[n6] = defaultTraceArray3[n].clone();
                    } else if (bl11 && bl12 && n13 != 0) {
                        defaultTraceArray3[n] = defaultTraceArray3[n6].clone();
                        defaultTraceArray3[n4] = defaultTraceArray3[n6].clone();
                        defaultTraceArray3[n5] = defaultTraceArray3[n6].clone();
                    } else if (n13 != 0 && bl12 && bl13) {
                        defaultTraceArray3[n] = defaultTraceArray3[n4].clone();
                        defaultTraceArray3[n5] = defaultTraceArray3[n4].clone();
                        defaultTraceArray3[n6] = defaultTraceArray3[n4].clone();
                    } else if (bl11 && n13 != 0 && bl13) {
                        if (sNS.getCenter().getTraceEW() != null && sNS.getCenter().getTraceNS() != null) {
                            LogUtil.debug(DataManager.class, (String)"Detected single 3 component station, super sonogram will consist of the vertical and horizontal traces.");
                            defaultTraceArray3[n] = defaultTraceArray3[n5].clone();
                            defaultTraceArray3[n4] = defaultTraceArray3[n5].clone();
                            defaultTraceArray3[n5] = defaultTraceArray2[n7].clone();
                            defaultTraceArray3[n6] = defaultTraceArray2[n8].clone();
                        } else {
                            defaultTraceArray3[n] = defaultTraceArray3[n5].clone();
                            defaultTraceArray3[n4] = defaultTraceArray3[n5].clone();
                            defaultTraceArray3[n6] = defaultTraceArray3[n5].clone();
                        }
                    }
                }
            } else {
                if (bl7) {
                    defaultTraceArray3[n] = DataManager.getMeanSonogram(defaultTraceArray3[n], defaultTraceArray4[n9]);
                }
                if (bl8) {
                    defaultTraceArray3[n4] = DataManager.getMeanSonogram(defaultTraceArray3[n4], defaultTraceArray4[n10]);
                }
                if (bl9) {
                    defaultTraceArray3[n6] = DataManager.getMeanSonogram(defaultTraceArray3[n6], defaultTraceArray4[n11]);
                }
                if (bl10) {
                    defaultTraceArray3[n5] = DataManager.getMeanSonogram(defaultTraceArray3[n5], defaultTraceArray4[n12]);
                }
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return defaultTraceArray3;
    }

    private static DefaultTrace getMeanSonogram(List<DefaultTrace> list) {
        DefaultTrace defaultTrace = new DefaultTrace();
        try {
            defaultTrace = list.get(0).clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        defaultTrace.setStationName("MEAN");
        float[] fArray = new float[list.get(0).getSamples().length];
        int n = list.size();
        for (DefaultTrace defaultTrace2 : list) {
            for (int i = 0; i < fArray.length; ++i) {
                int n2 = i;
                fArray[n2] = fArray[n2] + defaultTrace2.getSample(i) / (float)n;
            }
        }
        defaultTrace.setSamples(fArray);
        return defaultTrace;
    }

    private static DefaultTrace getMeanSonogram(DefaultTrace defaultTrace, DefaultTrace defaultTrace2) {
        DefaultTrace defaultTrace3 = new DefaultTrace();
        try {
            defaultTrace3 = defaultTrace.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        defaultTrace3.setStationName(defaultTrace.getStationName());
        float[] fArray = new float[defaultTrace.getSamples().length];
        float[] fArray2 = defaultTrace.getSamples();
        float[] fArray3 = defaultTrace2.getSamples();
        for (int i = 0; i < fArray2.length; ++i) {
            fArray[i] = (fArray2[i] + fArray3[i]) / 2.0f;
        }
        defaultTrace3.setSamples(fArray);
        return defaultTrace3;
    }

    public static final DefaultTrace[] getSuSoTraces(double d, double d2, SNS sNS, int n) {
        Object object;
        String[] stringArray;
        Object object2;
        Object object3;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        if (sNS.getNorth() != null && (sNS.getNorth().getTraceActive().equals((Object)Site.TraceActive.YES) || sNS.getNorth().getTraceActive().equals((Object)Site.TraceActive.NORTH)) && DataManager.isValidStationID((String)(object3 = sNS.getNorth().getTraceZ()))) {
            arrayList.add((Object[])object3);
            bl2 = true;
        }
        if (sNS.getWest() != null && (sNS.getWest().getTraceActive().equals((Object)Site.TraceActive.YES) || sNS.getWest().getTraceActive().equals((Object)Site.TraceActive.WEST)) && DataManager.isValidStationID((String)(object3 = sNS.getWest().getTraceZ()))) {
            arrayList.add((Object[])object3);
            bl = true;
        }
        if (sNS.getEast() != null && (sNS.getEast().getTraceActive().equals((Object)Site.TraceActive.YES) || sNS.getEast().getTraceActive().equals((Object)Site.TraceActive.EAST)) && DataManager.isValidStationID((String)(object3 = sNS.getEast().getTraceZ()))) {
            arrayList.add((Object[])object3);
            bl4 = true;
        }
        if (sNS.getCenter() != null && (sNS.getCenter().getTraceActive().equals((Object)Site.TraceActive.YES) || sNS.getCenter().getTraceActive().equals((Object)Site.TraceActive.CENTER))) {
            object3 = sNS.getCenter().getTraceZ();
            if (DataManager.isValidStationID((String)object3)) {
                arrayList.add((Object[])object3);
                bl3 = true;
            }
            if (DataManager.isValidStationID((String)(object2 = sNS.getCenter().getTraceEW()))) {
                arrayList.add((Object[])object2);
                bl9 = true;
            }
            if (DataManager.isValidStationID((String)(stringArray = sNS.getCenter().getTraceNS()))) {
                arrayList.add(stringArray);
                bl10 = true;
            }
        }
        if (sNS.getAux1() != null && (sNS.getAux1().getTraceActive().equals((Object)Site.TraceActive.YES) || sNS.getAux1().getTraceActive().equals((Object)Site.TraceActive.AUX1)) && DataManager.isValidStationID((String)(object3 = sNS.getAux1().getTraceZ()))) {
            arrayList.add((Object[])object3);
            bl5 = true;
        }
        if (sNS.getAux2() != null && (sNS.getAux2().getTraceActive().equals((Object)Site.TraceActive.YES) || sNS.getAux2().getTraceActive().equals((Object)Site.TraceActive.AUX2)) && DataManager.isValidStationID((String)(object3 = sNS.getAux2().getTraceZ()))) {
            arrayList.add((Object[])object3);
            bl6 = true;
        }
        if (sNS.getAux3() != null && (sNS.getAux3().getTraceActive().equals((Object)Site.TraceActive.YES) || sNS.getAux3().getTraceActive().equals((Object)Site.TraceActive.AUX3)) && DataManager.isValidStationID((String)(object3 = sNS.getAux3().getTraceZ()))) {
            arrayList.add((Object[])object3);
            bl7 = true;
        }
        if (sNS.getAux4() != null && (sNS.getAux4().getTraceActive().equals((Object)Site.TraceActive.YES) || sNS.getAux4().getTraceActive().equals((Object)Site.TraceActive.AUX4)) && DataManager.isValidStationID((String)(object3 = sNS.getAux4().getTraceZ()))) {
            arrayList.add((Object[])object3);
            bl8 = true;
        }
        if (arrayList.size() > 0) {
            object3 = DataManager.getSuSoTraces(d, d2, n, arrayList.toArray(new String[arrayList.size()]));
            object2 = DataManager.generatePartTraces(object3, sNS, bl, bl2, bl3, bl4, bl9, bl10, bl5, bl6, bl7, bl8);
            return object2;
        }
        object3 = new DefaultTraceMetadata();
        object2 = sNS.getCenter().getTraceZ();
        stringArray = object2.split("-");
        if (stringArray.length >= 2) {
            object = stringArray[stringArray.length - 1];
            object3.setStationName(object2.substring(0, object2.length() - ((String)object).length()));
            object3.setStationChannel((String)object);
            object3.setCalibration(1.0f);
            object3.setSamplerate(SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge().getGlobalSamplerate());
            object3.setOriginalSamplerate(object3.getSamplerate());
            object3.setStartEpochTime(d);
            object3.setLength((int)((d2 - d) * (double)object3.getSamplerate()) + 1);
            object3.setOriginalLength(object3.getLength());
        }
        object = new DefaultTrace((TraceMetadata)object3);
        object.setSamples(new float[object3.getLength()]);
        return new DefaultTrace[]{object, object, object, object};
    }

    public static final DefaultTrace[] getSuSoTraces(double d, double d2, int n, String ... stringArray) {
        TraceProvider traceProvider = SuiteManager.INSTANCE.getTraceProvider();
        DefaultTrace[] defaultTraceArray = new DefaultTrace[stringArray.length];
        long l = System.nanoTime();
        if (stringArray != null) {
            defaultTraceArray = traceProvider.requestTrace(d, d2, SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge().getGlobalSamplerate() / (float)n, stringArray);
            LogUtil.debug(DataManager.class, (String)String.format("got %d traces (start=%s, end=%s) in %d ms (Stations=%s)", defaultTraceArray.length, DateTimeUtil.formatTimeHighPrecision((double)d), DateTimeUtil.formatTimeHighPrecision((double)d2), (System.nanoTime() - l) / 1000000L, Arrays.toString(stringArray)));
        }
        return defaultTraceArray;
    }

    public final void setEventWindowLength(boolean bl) {
        long l;
        int n;
        BoundedLongRangeModel boundedLongRangeModel = SonoViewManager.getInstance().getMainFrame().getSelectionModel();
        ResamplingMode resamplingMode = DefaultResamplingModes.getModeByIndex((int)SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge().getResamplingMode());
        int n2 = n = resamplingMode.getSelectionIndexByMs((double)boundedLongRangeModel.getExtent());
        if (bl && n < resamplingMode.getMaxSelectionModeIndex()) {
            ++n2;
        } else if (!bl && n > resamplingMode.getMinSelectionModeIndex()) {
            --n2;
        } else {
            return;
        }
        long l2 = resamplingMode.getSelectionLengthMs(n2);
        if (boundedLongRangeModel instanceof PickedLongRangeModel && ((PickedLongRangeModel)boundedLongRangeModel).getPick() != null) {
            long l3 = ((PickedLongRangeModel)boundedLongRangeModel).getPick().getTimeMs();
            double d = (double)(l3 - boundedLongRangeModel.getValue()) / (double)boundedLongRangeModel.getExtent();
            l = l3 - (long)(d * (double)l2);
        } else {
            l = boundedLongRangeModel.getValue();
        }
        boundedLongRangeModel.setExtent(l2);
        boundedLongRangeModel.setValue(l);
        if (SonoViewManager.getInstance() != null) {
            SonoViewManager.getInstance().getSettingsManager().getUserConfiguration().setSelectionLengthIndex(n2);
            SonoViewManager.getInstance().pushSelectionLengthToSuite();
            SonoViewManager.getInstance().pushSelectionBeginToSuite();
        }
    }

    public boolean isNoiseCancelling() {
        return this.noiseCancelling;
    }

    public void setNoiseCancelling(boolean bl) {
        this.noiseCancelling = bl;
    }

    private static final class SonogramProviderImp
    implements SonogramProvider {
        private final SonogramRenderer sonoprovider;
        private EventFileManager efm = SuiteManager.INSTANCE.getEventFileManager();

        public SonogramProviderImp() {
            this.sonoprovider = new SonogramRenderer();
        }

        private final SonogramModel getGeneratedSonogram(DefaultTrace defaultTrace) {
            int[][] nArray = this.sonoprovider.getSonogram(defaultTrace);
            DefaultSonogramModel defaultSonogramModel = new DefaultSonogramModel(defaultTrace.getStationID(), defaultTrace.getStartEpochTime(), defaultTrace.getEndEpochTime(), nArray, this.sonoprovider.getNpsdf(), this.sonoprovider.getNsigf(), this.sonoprovider.getNdminf(), this.sonoprovider.getNdmaxf());
            return defaultSonogramModel;
        }

        private final SonogramModel getSonogramFromCache(double d, double d2, String string) {
            DefaultSonogramModel defaultSonogramModel = null;
            int[][] nArray = this.sonoprovider.updateSonogram(string, d, d2);
            if (nArray != null) {
                defaultSonogramModel = new DefaultSonogramModel(string, d, d2, nArray, this.sonoprovider.getNpsdf(), this.sonoprovider.getNsigf(), this.sonoprovider.getNdminf(), this.sonoprovider.getNdmaxf());
            }
            return defaultSonogramModel;
        }

        @Override
        public SonogramModel getSonogram(double d, double d2, String string) {
            LogUtil.debug(this.getClass(), (String)String.format("getSonogramm() start=%f, length=%f, station=%s", d, d2, string));
            SonogramModel sonogramModel = this.getSonogramFromCache(d, d + d2, string);
            if (sonogramModel == null) {
                DefaultTrace defaultTrace = DataManager.getSuSoTraces(d, d + d2, 1, string)[0];
                sonogramModel = this.getGeneratedSonogram(defaultTrace);
            }
            return sonogramModel;
        }

        @Override
        public SonogramModel getSonogram(long l, long l2, String string) {
            return this.getSonogram(DateTimeUtil.convertLongMsToDoubleS((long)l), DateTimeUtil.convertLongMsToDoubleS((long)l2), string);
        }

        @Override
        public ArraySonogramModel getStationSonogram(double d, double d2, SNS sNS) {
            Object object;
            Object object2;
            LogUtil.debug(this.getClass(), (String)String.format("getStationSonogram() start=%f, length=%f, name=%s", d, d2, sNS.getID()));
            DefaultArraySonogramModel defaultArraySonogramModel = new DefaultArraySonogramModel();
            ArrayList<SonogramModel[]> arrayList = new ArrayList<SonogramModel[]>();
            if (sNS.getNorth() != null && (sNS.getNorth().getTraceActive().equals((Object)Site.TraceActive.YES) || sNS.getNorth().getTraceActive().equals((Object)Site.TraceActive.NORTH)) && DataManager.isValidStationID((String)(object2 = sNS.getNorth().getTraceZ()))) {
                arrayList.add((SonogramModel[])object2);
            }
            if (sNS.getWest() != null && (sNS.getWest().getTraceActive().equals((Object)Site.TraceActive.YES) || sNS.getWest().getTraceActive().equals((Object)Site.TraceActive.WEST)) && DataManager.isValidStationID((String)(object2 = sNS.getWest().getTraceZ()))) {
                arrayList.add((SonogramModel[])object2);
            }
            if (sNS.getEast() != null && (sNS.getEast().getTraceActive().equals((Object)Site.TraceActive.YES) || sNS.getEast().getTraceActive().equals((Object)Site.TraceActive.EAST)) && DataManager.isValidStationID((String)(object2 = sNS.getEast().getTraceZ()))) {
                arrayList.add((SonogramModel[])object2);
            }
            if (sNS.getCenter() != null && (sNS.getCenter().getTraceActive().equals((Object)Site.TraceActive.YES) || sNS.getCenter().getTraceActive().equals((Object)Site.TraceActive.CENTER)) && DataManager.isValidStationID((String)(object2 = sNS.getCenter().getTraceZ()))) {
                arrayList.add((SonogramModel[])object2);
            }
            if (sNS.getAux1() != null && (sNS.getAux1().getTraceActive().equals((Object)Site.TraceActive.YES) || sNS.getAux1().getTraceActive().equals((Object)Site.TraceActive.AUX1)) && DataManager.isValidStationID((String)(object2 = sNS.getAux1().getTraceZ()))) {
                arrayList.add((SonogramModel[])object2);
            }
            if (sNS.getAux2() != null && (sNS.getAux2().getTraceActive().equals((Object)Site.TraceActive.YES) || sNS.getAux2().getTraceActive().equals((Object)Site.TraceActive.AUX2)) && DataManager.isValidStationID((String)(object2 = sNS.getAux2().getTraceZ()))) {
                arrayList.add((SonogramModel[])object2);
            }
            if (sNS.getAux3() != null && (sNS.getAux3().getTraceActive().equals((Object)Site.TraceActive.YES) || sNS.getAux3().getTraceActive().equals((Object)Site.TraceActive.AUX3)) && DataManager.isValidStationID((String)(object2 = sNS.getAux3().getTraceZ()))) {
                arrayList.add((SonogramModel[])object2);
            }
            if (sNS.getAux4() != null && (sNS.getAux4().getTraceActive().equals((Object)Site.TraceActive.YES) || sNS.getAux4().getTraceActive().equals((Object)Site.TraceActive.AUX4)) && DataManager.isValidStationID((String)(object2 = sNS.getAux4().getTraceZ()))) {
                arrayList.add((SonogramModel[])object2);
            }
            object2 = new SonogramModel[4];
            int n = 0;
            for (int i = 0; i < arrayList.size(); ++i) {
                object = this.getSonogramFromCache(d, d + d2, (String)arrayList.get(i));
                if (object == null) continue;
                object2[i] = object;
                ++n;
                LogUtil.debug(this.getClass(), (String)"cache hit");
            }
            if (n != 4) {
                DefaultTrace[] defaultTraceArray = DataManager.getSuSoTraces(d, d + d2, sNS, 1);
                object = this.efm.getPatternDates(this.efm.getSonoViewDetections(), sNS.getID(), d, d + d2);
                Random random = new Random();
                int n2 = 0;
                for (DefaultTrace defaultTrace : defaultTraceArray) {
                    object2[n2] = this.getGeneratedSonogram(defaultTrace);
                    if (SonoViewManager.getInstance() != null && SonoViewManager.getInstance().getDataManager().isNoiseCancelling()) {
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            AbstractDetection abstractDetection = (AbstractDetection)iterator.next();
                            int n3 = (int)Math.round(MathUtil.convertFromTo((double)((double)abstractDetection.getStartTimeMs() / 1000.0), (double)object2[n2].getStartEpochTime(), (double)object2[n2].getEndEpochTime(), (double)0.0, (double)object2[n2].getTimeWidth()));
                            int n4 = (int)Math.round(MathUtil.convertFromTo((double)((double)abstractDetection.getEndTimeMs() / 1000.0), (double)object2[n2].getStartEpochTime(), (double)object2[n2].getEndEpochTime(), (double)0.0, (double)object2[n2].getTimeWidth()));
                            int[][] nArray = object2[n2].getRawSonogram();
                            for (int i = 0; i < object2[n2].getFrequencyWidth(); ++i) {
                                double d3 = MathUtil.calcMean((int[])nArray[i]);
                                double d4 = Math.sqrt(MathUtil.calcVariance((int[])nArray[i], (double)d3));
                                for (int j = n3; j < n4; ++j) {
                                    if (j <= 0 || j >= object2[n2].getTimeWidth()) continue;
                                    int n5 = (int)(random.nextGaussian() * d4 + d3);
                                    nArray[i][j] = n5 = Math.max(0, n5);
                                }
                            }
                        }
                    }
                    ++n2;
                }
            }
            defaultArraySonogramModel.setComponents(object2[1], object2[0], object2[3], object2[2]);
            return defaultArraySonogramModel.isHealthy() ? defaultArraySonogramModel : null;
        }

        @Override
        public ArraySonogramModel getStationSonogram(long l, long l2, SNS sNS) {
            return this.getStationSonogram(DateTimeUtil.convertLongMsToDoubleS((long)l), DateTimeUtil.convertLongMsToDoubleS((long)l2), sNS);
        }

        @Override
        public SonogramRenderer getSonoprovider() {
            return this.sonoprovider;
        }
    }
}

