/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.sonoview;

import edu.geophys.commons.model.DefaultTrace;
import edu.geophys.commons.resamplingmodes.DefaultResamplingModes;
import edu.geophys.commons.resamplingmodes.ResamplingMode;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.util.Sonolib;
import edu.geophys.sonoview.SonoViewManager;
import edu.geophys.sonoview.sonogramMemory.MemoryObj;
import edu.geophys.sonoview.sonogramMemory.SonogramMemory;

public class SonogramRenderer {
    private int _timeDimension = 750;
    private int _freqDimension = 13;
    private float _ExternalNoiseMixinRate = 0.8f;
    public int isoff = 120;
    public static int ifft = 256;
    private int llog = 2;
    private boolean ldispl = true;
    private int jbases = 0;
    private boolean fixJBases = true;
    private int lblank = 1;
    private int scaling = 0;
    private float fu = 40.0f;
    private float fl = 0.0f;
    private SonogramMemory sonoMemory = new SonogramMemory();
    private int[] npicf;
    private int[] npsdf;
    private int[] nsigf;
    private int[] ndmaxf;
    private int[] ndminf;

    public SonogramRenderer() {
        if (SonoViewManager.getInstance() != null) {
            this.jbases = SonoViewManager.getInstance().getSettingsManager().getUserConfiguration().getJbases();
            ResamplingMode resamplingMode = DefaultResamplingModes.getModeByIndex((int)SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge().getResamplingMode());
            this.isoff = resamplingMode.getSonogramIncrement();
            this._freqDimension = resamplingMode.getSonogramFrequencyBins();
        }
    }

    public SonogramRenderer(int n, boolean bl, int n2, int n3, int n4, float f, float f2) {
        this.llog = n;
        this.ldispl = bl;
        this.lblank = n3;
        this.scaling = n4;
        this.fl = f;
        this.fu = f2;
        if (n2 == -1) {
            this.fixJBases = false;
            this.jbases = 0;
        } else {
            this.fixJBases = true;
            this.jbases = n2;
        }
    }

    public int[][] getSonogram(DefaultTrace defaultTrace) {
        MemoryObj memoryObj = new MemoryObj();
        MemoryObj memoryObj2 = new MemoryObj();
        this._timeDimension = (int)Math.round((double)defaultTrace.getSamplerate() * (defaultTrace.getEndEpochTime() - defaultTrace.getStartEpochTime()) / (double)this.isoff);
        int[][] nArray = this._calculateSonogram(defaultTrace, memoryObj, memoryObj2);
        if (SonoViewManager.getInstance() != null) {
            this.sonoMemory.updateData(defaultTrace.getStationID(), memoryObj2);
        }
        return nArray;
    }

    public int[][] updateSonogram(String string, double d, double d2) {
        MemoryObj memoryObj = new MemoryObj();
        MemoryObj memoryObj2 = new MemoryObj();
        int[][] nArray = null;
        memoryObj2 = this.sonoMemory.getMemoryObj(string, d, d2, true);
        if (memoryObj2.isValid()) {
            nArray = this.updateSono(memoryObj, memoryObj2);
        }
        return nArray;
    }

    public int[][] _calculateSonogram(DefaultTrace defaultTrace, MemoryObj memoryObj, MemoryObj memoryObj2) {
        float[] fArray = new float[defaultTrace.getLength()];
        int[][] nArray = new int[this._freqDimension][this._timeDimension];
        fArray = this.adjustOffset(defaultTrace.getSamples());
        if (fArray != null) {
            this._calculateSonogram(defaultTrace.getSamples(), defaultTrace.getSamplerate(), defaultTrace.getCalibration(), memoryObj, memoryObj2, defaultTrace.getStartEpochTime(), defaultTrace.getEndEpochTime(), nArray);
            return nArray;
        }
        memoryObj2.setEpochTimes(defaultTrace.getStartEpochTime(), defaultTrace.getEndEpochTime());
        memoryObj2.setFftData(null);
        memoryObj2.setInternalNoise(null, null);
        this.npsdf = null;
        this.nsigf = null;
        this.ndmaxf = null;
        this.ndminf = null;
        return nArray;
    }

    public void _calculateSonogram(float[] fArray, float f, float f2, MemoryObj memoryObj, MemoryObj memoryObj2, double d, double d2, int[][] nArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = fArray.length;
        int n5 = this._timeDimension;
        int n6 = this._freqDimension;
        float[] fArray2 = new float[n5 * n6];
        float[] fArray3 = new float[n5];
        float[] fArray4 = new float[n6];
        float[] fArray5 = new float[n6];
        this.npsdf = new int[n5 * n6];
        this.nsigf = new int[n6];
        this.ndmaxf = new int[n6];
        this.ndminf = new int[n6];
        this.npicf = new int[n5 * n6];
        int[] nArray2 = new int[n6];
        float f3 = f / (float)ifft;
        Sonolib.psdfft((float[])fArray, (int)n4, (float[])fArray2, (int)n5, (int)n6, (float[])fArray3, (int)this.isoff, (int)ifft, (int)this.llog, (float)f2, (float)this.fu, (float)this.fl, (float)f3);
        Sonolib.nstat3((float[])fArray2, (int)n5, (int)n6, (float[])fArray3, (float[])fArray4, (float[])fArray5, (int)20);
        if (memoryObj2 != null) {
            memoryObj2.setEpochTimes(d, d2);
            memoryObj2.setFftData(fArray2);
            memoryObj2.setInternalNoise(fArray4, fArray5);
            memoryObj2.setExternalNoise(fArray4, fArray5);
        }
        Sonolib.pscal((float[])fArray2, (float[])fArray4, (float[])fArray5, (int)n5, (int)n6, (int[])this.npsdf, (int[])this.nsigf, (int)this.lblank, (boolean)this.ldispl);
        if (!this.fixJBases) {
            Sonolib.dyna((int[])this.npsdf, (int)n5, (int)n6, (int)n2, (int)n5, (int[])this.ndmaxf, (int[])this.ndminf);
            for (n = 0; n < n6; ++n) {
                if (n3 >= this.ndmaxf[n] - this.nsigf[n] + 1) continue;
                n3 = this.ndmaxf[n] - this.nsigf[n] + 1;
            }
            this.jbases = 0;
            if (n3 > 14) {
                this.jbases = 1;
            } else if (n3 > 28) {
                this.jbases = 2;
            }
        }
        Sonolib.scal((int[])this.npsdf, (int)n5, (int)n6, (int[])this.nsigf, (int)this.jbases, (int)this.scaling, (int[])this.npicf, (int)n2, (int)n5, (int[])nArray2);
        for (n = 0; n < n6; ++n) {
            for (int i = 0; i < this._timeDimension; ++i) {
                nArray[n6 - 1 - n][i] = this.npicf[n * n5 + i];
            }
        }
    }

    public int[][] calculateSonogram(float[] fArray, float f, float f2) {
        return this.calculateSonogram(fArray, f, f2, this._timeDimension, this._freqDimension);
    }

    public int[][] calculateSonogram(float[] fArray, float f, float f2, int n, int n2) {
        this._timeDimension = n;
        this._freqDimension = n2;
        int n3 = fArray.length;
        float[] fArray2 = new float[n3];
        int[][] nArray = new int[this._freqDimension][this._timeDimension];
        fArray2 = this.adjustOffset(fArray);
        if (fArray2 != null) {
            int n4;
            int n5 = 0;
            int n6 = 0;
            int n7 = n3;
            int n8 = this._timeDimension;
            int n9 = this._freqDimension;
            float f3 = f;
            float[] fArray3 = new float[n8 * n9];
            float[] fArray4 = new float[n8];
            float[] fArray5 = new float[n9];
            float[] fArray6 = new float[n9];
            this.npsdf = new int[n8 * n9];
            this.nsigf = new int[n9];
            this.ndmaxf = new int[n9];
            this.ndminf = new int[n9];
            int[] nArray2 = new int[n8 * n9];
            int[] nArray3 = new int[n9];
            float f4 = f2;
            float f5 = f3 / (float)ifft;
            Sonolib.psdfft((float[])fArray2, (int)n7, (float[])fArray3, (int)n8, (int)n9, (float[])fArray4, (int)this.isoff, (int)ifft, (int)this.llog, (float)f4, (float)this.fu, (float)this.fl, (float)f5);
            Sonolib.nstat3((float[])fArray3, (int)n8, (int)n9, (float[])fArray4, (float[])fArray5, (float[])fArray6, (int)20);
            Sonolib.pscal((float[])fArray3, (float[])fArray5, (float[])fArray6, (int)n8, (int)n9, (int[])this.npsdf, (int[])this.nsigf, (int)this.lblank, (boolean)this.ldispl);
            if (!this.fixJBases) {
                Sonolib.dyna((int[])this.npsdf, (int)n8, (int)n9, (int)n5, (int)n8, (int[])this.ndmaxf, (int[])this.ndminf);
                for (n4 = 0; n4 < n9; ++n4) {
                    if (n6 >= this.ndmaxf[n4] - this.nsigf[n4] + 1) continue;
                    n6 = this.ndmaxf[n4] - this.nsigf[n4] + 1;
                }
                this.jbases = 0;
                if (n6 > 14) {
                    this.jbases = 1;
                } else if (n6 > 28) {
                    this.jbases = 2;
                }
            }
            Sonolib.scal((int[])this.npsdf, (int)n8, (int)n9, (int[])this.nsigf, (int)this.jbases, (int)this.scaling, (int[])nArray2, (int)n5, (int)n8, (int[])nArray3);
            for (n4 = 0; n4 < n9; ++n4) {
                for (int i = 0; i < this._timeDimension; ++i) {
                    nArray[n9 - 1 - n4][i] = nArray2[n4 * n8 + i];
                }
            }
            return nArray;
        }
        return nArray;
    }

    private int[][] updateSono(MemoryObj memoryObj, MemoryObj memoryObj2) {
        int[][] nArray = new int[this._freqDimension][this._timeDimension];
        int n = this._timeDimension;
        int n2 = this._freqDimension;
        int n3 = 0;
        int n4 = 0;
        this.npsdf = new int[n * n2];
        this.nsigf = new int[n2];
        this.ndmaxf = new int[n2];
        this.ndminf = new int[n2];
        int[] nArray2 = new int[n * n2];
        int[] nArray3 = new int[n2];
        float[] fArray = memoryObj2.xpsdf;
        float[] fArray2 = memoryObj2.internalNoiseXmedian;
        float[] fArray3 = memoryObj2.internalNoiseXsigma;
        if (fArray != null) {
            int n5;
            memoryObj2.setExternalNoise(fArray2, fArray3);
            Sonolib.pscal((float[])fArray, (float[])fArray2, (float[])fArray3, (int)n, (int)n2, (int[])this.npsdf, (int[])this.nsigf, (int)this.lblank, (boolean)this.ldispl);
            if (!this.fixJBases) {
                Sonolib.dyna((int[])this.npsdf, (int)n, (int)n2, (int)n3, (int)n, (int[])this.ndmaxf, (int[])this.ndminf);
                for (n5 = 0; n5 < n2; ++n5) {
                    if (n4 >= this.ndmaxf[n5] - this.nsigf[n5] + 1) continue;
                    n4 = this.ndmaxf[n5] - this.nsigf[n5] + 1;
                }
                this.jbases = 0;
                if (n4 > 14) {
                    this.jbases = 1;
                } else if (n4 > 28) {
                    this.jbases = 2;
                }
            }
            Sonolib.scal((int[])this.npsdf, (int)n, (int)n2, (int[])this.nsigf, (int)this.jbases, (int)this.scaling, (int[])nArray2, (int)n3, (int)n, (int[])nArray3);
            for (n5 = 0; n5 < n2; ++n5) {
                for (int i = 0; i < this._timeDimension; ++i) {
                    nArray[n2 - 1 - n5][i] = nArray2[n5 * n + i];
                }
            }
            return nArray;
        }
        memoryObj2.setExternalNoise(null, null);
        this.npsdf = null;
        this.nsigf = null;
        this.ndmaxf = null;
        this.ndminf = null;
        return nArray;
    }

    public float[] adjustOffset(float[] fArray) {
        boolean bl = true;
        for (int i = 0; i < fArray.length; ++i) {
            if (!Float.isNaN(fArray[i])) {
                bl = false;
                continue;
            }
            fArray[i] = 0.0f;
        }
        return bl ? null : fArray;
    }

    public int getFreqDimension() {
        return this._freqDimension;
    }

    public int[] getNpsdf() {
        return this.npsdf;
    }

    public void setNpsdf(int[] nArray) {
        this.npsdf = nArray;
    }

    public int[] getNsigf() {
        return this.nsigf;
    }

    public void setNsigf(int[] nArray) {
        this.nsigf = nArray;
    }

    public int[] getNdmaxf() {
        return this.ndmaxf;
    }

    public void setNdmaxf(int[] nArray) {
        this.ndmaxf = nArray;
    }

    public int[] getNdminf() {
        return this.ndminf;
    }

    public void setNdminf(int[] nArray) {
        this.ndminf = nArray;
    }

    public int get_timeDimension() {
        return this._timeDimension;
    }

    public void set_timeDimension(int n) {
        this._timeDimension = n;
    }

    public int[] getNpicf() {
        return this.npicf;
    }

    public void setNpicf(int[] nArray) {
        this.npicf = nArray;
    }
}

