/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.sonoview.swing;

import edu.geophys.commons.detection.AbstractDetection;
import edu.geophys.commons.detection.EventClass;
import edu.geophys.commons.detection.SonoViewDetection;
import edu.geophys.commons.detection.SonoViewPick;
import edu.geophys.commons.detection.TraceViewState;
import edu.geophys.commons.model.knowledgebase.CampaignKnowledge;
import edu.geophys.commons.model.knowledgebase.StationsKnowledge;
import edu.geophys.commons.resamplingmodes.DefaultResamplingModes;
import edu.geophys.commons.resamplingmodes.ResamplingMode;
import edu.geophys.commons.suite.EventFileManager;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.ui.BoundedLongRangeModel;
import edu.geophys.commons.ui.FrameIconSetter;
import edu.geophys.commons.ui.JAboutDialog;
import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.commons.util.PlatformUtil;
import edu.geophys.sonoview.DataManager;
import edu.geophys.sonoview.PickedLongRangeModel;
import edu.geophys.sonoview.SettingsManager;
import edu.geophys.sonoview.SonoViewConfiguration;
import edu.geophys.sonoview.SonoViewManager;
import edu.geophys.sonoview.swing.EventDialogController;
import edu.geophys.sonoview.swing.JSonoviewTimeSelection;
import edu.geophys.sonoview.swing.largesonogram.DefaultLargeSonogramModel;
import edu.geophys.sonoview.swing.largesonogram.JLargeSonogram;
import edu.geophys.sonoview.swing.largesonogram.RowDimensonModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerDateModel;
import layout.TableLayout;

public class JSonoViewMainFrame
extends JFrame {
    private static final long serialVersionUID = -3405137601552021550L;
    private JSonoviewTimeSelection timeControl;
    private JLargeSonogram largeSonogram;
    private JPanel largeSonogramPanel;
    private JMenuBar sonoviewMenuBar;
    private ButtonGroup theFixDynaButtons;
    private JRadioButton setFixedButton;
    private JRadioButton setDynamicButton;
    private JCheckBoxMenuItem showBulletinEventsCheckbox;
    private JPanel timeControlPanel;
    private boolean windowChangeInProgress = false;
    private final ComponentListener windowSizeListener = new ComponentListener(){

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            if (!JSonoViewMainFrame.this.windowChangeInProgress) {
                JSonoViewMainFrame.this.windowChangeInProgress = true;
                if (SettingsManager.getInstance().getUserConfiguration().getDynamicSize()) {
                    SonoViewConfiguration sonoViewConfiguration = new SonoViewConfiguration(SettingsManager.getInstance().getUserConfiguration());
                    CampaignKnowledge campaignKnowledge = SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge();
                    ResamplingMode resamplingMode = DefaultResamplingModes.getModeByIndex((int)campaignKnowledge.getResamplingMode());
                    StationsKnowledge stationsKnowledge = SuiteManager.INSTANCE.getKnowledgebase().getStationsKnowledge();
                    int n = stationsKnowledge.getAllActiveSNS().length == 0 ? 1 : stationsKnowledge.getAllActiveSNS().length;
                    double d = sonoViewConfiguration.getOverlapMinFactorDynamic();
                    boolean bl = d > 1.0E-4;
                    float f = sonoViewConfiguration.getScreensRenderedDynamic();
                    int n2 = 1000 * sonoViewConfiguration.getRoundSecondsPerRowDynamic();
                    boolean bl2 = sonoViewConfiguration.getRoundSecondsPerRowDynamic() > 0;
                    int n3 = (1 + resamplingMode.getSonogramFrequencyBins() * 2) * n + 10;
                    int n4 = JSonoViewMainFrame.this.largeSonogram.getScrollPane().getViewport().getHeight();
                    int n5 = sonoViewConfiguration.getDynAwareMilliSecondsPerRow();
                    int n6 = sonoViewConfiguration.getDynAwareOverlapMilliSeconds();
                    int n7 = sonoViewConfiguration.getDynAwareDisplayedRows();
                    int n8 = Math.max(1, (int)(f * (float)n4 / (float)n3));
                    long l = JSonoViewMainFrame.this.getScreenWidthMilliseconds();
                    long l2 = bl ? (long)((int)((double)l * (1.0 - d))) : l;
                    if (bl2 && l2 > (long)n2) {
                        l2 = l2 / (long)n2 * (long)n2;
                    }
                    long l3 = bl ? l - l2 : 0L;
                    if (n7 != n8 || Math.abs(l2 - (long)n5) > 1000L || Math.abs(l3 - (long)n6) > 1000L) {
                        sonoViewConfiguration.setMilliSecondsPerRowDynamic((int)l2);
                        sonoViewConfiguration.setOverlapMilliSecondsDynamic((int)l3);
                        sonoViewConfiguration.setMilliSecondsPerRowSamplingRateDynamic(campaignKnowledge.getGlobalSamplerate());
                        sonoViewConfiguration.setDisplayedRowsDynamic(n8);
                        SettingsManager.getInstance().setUserConfiguration(sonoViewConfiguration);
                    }
                }
            }
            JSonoViewMainFrame.this.windowChangeInProgress = false;
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }
    };

    public JSonoViewMainFrame() {
        FrameIconSetter.setFrameIcon((JFrame)this);
        this.setMinimumSize(new Dimension(640, 480));
        this.initComponents();
        this.initCustom();
    }

    private void initCustom() {
        this.timeControl = new JSonoviewTimeSelection();
        this.largeSonogram = new JLargeSonogram(this);
        this.timeControlPanel.add((Component)this.timeControl, "Center");
        this.largeSonogramPanel.add((Component)this.largeSonogram, "Center");
        this.setSelectionModel(this.getSelectionModel());
        this.setRowDimension(this.getRowDimension());
        this.addComponentListener(this.windowSizeListener);
    }

    public DefaultLargeSonogramModel getModel() {
        return this.largeSonogram.getModel();
    }

    public JLargeSonogram getJLargeSonogram() {
        return this.largeSonogram;
    }

    public void setModel(DefaultLargeSonogramModel defaultLargeSonogramModel) {
        this.largeSonogram.setModel(defaultLargeSonogramModel);
        if (defaultLargeSonogramModel != null) {
            this.timeControl.setAxisModel(defaultLargeSonogramModel.getTimeRangeModel());
        }
    }

    public BoundedLongRangeModel getSelectionModel() {
        return this.largeSonogram.getSelectionModel();
    }

    public void setSelectionModel(BoundedLongRangeModel boundedLongRangeModel) {
        this.largeSonogram.setSelectionModel(boundedLongRangeModel);
    }

    public RowDimensonModel getRowDimension() {
        return this.largeSonogram.getRowDimension();
    }

    public void setRowDimension(RowDimensonModel rowDimensonModel) {
        this.largeSonogram.setRowDimension(rowDimensonModel);
        this.timeControl.setRowDimension(rowDimensonModel);
    }

    public JScrollPane getScrollpane() {
        return this.largeSonogram.getScrollPane();
    }

    public ComponentListener getWindowSizeListener() {
        return this.windowSizeListener;
    }

    public long getScreenWidthMilliseconds() {
        CampaignKnowledge campaignKnowledge = SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge();
        int n = Math.max(10, this.getWidth() - 110);
        ResamplingMode resamplingMode = DefaultResamplingModes.getModeByIndex((int)campaignKnowledge.getResamplingMode());
        return (int)((float)n * resamplingMode.getSecPerSonoPixel() * 1000.0f);
    }

    private void initComponents() {
        this.timeControlPanel = new JPanel();
        this.largeSonogramPanel = new JPanel();
        this.sonoviewMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu();
        JMenuItem jMenuItem = new JMenuItem();
        JMenuItem jMenuItem2 = new JMenuItem();
        JMenu jMenu2 = new JMenu();
        JMenuItem jMenuItem3 = new JMenuItem();
        JMenuItem jMenuItem4 = new JMenuItem();
        JMenu jMenu3 = new JMenu();
        JMenuItem jMenuItem5 = new JMenuItem();
        JMenuItem jMenuItem6 = new JMenuItem();
        this.setDefaultCloseOperation(0);
        this.setTitle("SonoView ");
        this.setLocationByPlatform(true);
        this.setName("SonoViewMainFrame");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                JSonoViewMainFrame.this.formWindowClosing(windowEvent);
            }
        });
        this.timeControlPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.timeControlPanel, "First");
        this.largeSonogramPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.largeSonogramPanel, "Center");
        jMenu.setMnemonic('F');
        jMenu.setText("File");
        jMenu.add(new JSeparator());
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        jMenuItem2.setMnemonic('x');
        jMenuItem2.setText("Exit");
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSonoViewMainFrame.this.exitMenuItemActionPerformed(actionEvent);
            }
        });
        jMenu.add(jMenuItem2);
        this.sonoviewMenuBar.add(jMenu);
        jMenu2.setMnemonic('V');
        jMenu2.setText("View");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        jMenuItem.setMnemonic('P');
        jMenuItem.setText("Preferences");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSonoViewMainFrame.this.preferencesMenuItemActionPerformed(actionEvent);
            }
        });
        jMenu2.add(jMenuItem);
        jMenu2.addSeparator();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.setFixedButton = new JRadioButton("Fixed view");
        this.setDynamicButton = new JRadioButton("Dynamic view");
        this.theFixDynaButtons = new ButtonGroup();
        this.theFixDynaButtons.add(this.setDynamicButton);
        this.theFixDynaButtons.add(this.setFixedButton);
        this.setDynamicButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSonoViewMainFrame.this.eventSetDynamicActionPerformed(actionEvent, true);
            }
        });
        this.setFixedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSonoViewMainFrame.this.eventSetDynamicActionPerformed(actionEvent, false);
            }
        });
        buttonGroup.add(this.setFixedButton);
        buttonGroup.add(this.setDynamicButton);
        jMenu2.add(this.setFixedButton);
        jMenu2.add(this.setDynamicButton);
        jMenu2.addSeparator();
        this.showBulletinEventsCheckbox = new JCheckBoxMenuItem("Show bulletin events");
        this.showBulletinEventsCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SonoViewConfiguration sonoViewConfiguration = SonoViewManager.getInstance().getSettingsManager().getUserConfiguration();
                sonoViewConfiguration.setShowMarkers(JSonoViewMainFrame.this.showBulletinEventsCheckbox.getState());
                SonoViewManager.getInstance().getSettingsManager().setUserConfiguration(sonoViewConfiguration, false);
            }
        });
        jMenu2.add(this.showBulletinEventsCheckbox);
        jMenu2.addSeparator();
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(76, 0));
        jMenuItem3.setMnemonic('L');
        jMenuItem3.setText("Event List");
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SonoViewManager.getInstance().forceOpenEventList();
            }
        });
        jMenu2.add(jMenuItem3);
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(74, 0));
        jMenuItem4.setMnemonic('J');
        jMenuItem4.setText("Jump to date");
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSonoViewMainFrame.this.eventJumpToDateActionPerformed(actionEvent);
            }
        });
        jMenu2.add(jMenuItem4);
        this.sonoviewMenuBar.add(jMenu2);
        jMenu3.setMnemonic('H');
        jMenu3.setText("Help");
        jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        jMenuItem5.setMnemonic('H');
        jMenuItem5.setText("Help");
        jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSonoViewMainFrame.this.helpDialogMenueItemActionPerformed(actionEvent);
            }
        });
        jMenu3.add(jMenuItem5);
        jMenuItem6.setMnemonic('A');
        jMenuItem6.setText("About");
        jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSonoViewMainFrame.this.aboutDialogMenueItemActionPerformed(actionEvent);
            }
        });
        jMenu3.add(jMenuItem6);
        this.sonoviewMenuBar.add(jMenu3);
        this.sonoviewMenuBar.add(new JSeparator(1));
        this.setJMenuBar(this.sonoviewMenuBar);
        this.pack();
    }

    private void eventJumpToDateActionPerformed(ActionEvent actionEvent) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.getSelectionModel().getValue());
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-3.0, -1.0}, {-1.0}}));
        JLabel jLabel = new JLabel("Date: ");
        SpinnerDateModel spinnerDateModel = new SpinnerDateModel();
        JSpinner jSpinner = new JSpinner(spinnerDateModel);
        SimpleDateFormat simpleDateFormat = ((JSpinner.DateEditor)jSpinner.getEditor()).getFormat();
        simpleDateFormat.applyPattern("yyyy-MM-dd HH:mm:ss");
        jSpinner.setValue(calendar.getTime());
        jPanel.add((Component)jLabel, "0, 0");
        jPanel.add((Component)jSpinner, "1, 0");
        int n = JOptionPane.showOptionDialog(this, jPanel, "Select date to show", 2, -1, null, null, null);
        if (n == 0) {
            calendar.setTime((Date)jSpinner.getValue());
            this.getSelectionModel().setValue(calendar.getTimeInMillis());
        }
    }

    private AbstractDetection getNextEvent(boolean bl) {
        List list = SuiteManager.INSTANCE.getEventFileManager().getAllDetectionEntries();
        AbstractDetection abstractDetection = SonoViewManager.getInstance().getCurrentPattern();
        long l = abstractDetection != null ? abstractDetection.getIndexTimeMs() : this.getSelectionModel().getValue();
        AbstractDetection abstractDetection2 = null;
        for (AbstractDetection abstractDetection3 : list) {
            if (bl) {
                if (abstractDetection3.getIndexTimeMs() <= l) continue;
                if (abstractDetection2 == null) {
                    abstractDetection2 = abstractDetection3;
                    continue;
                }
                if (abstractDetection3.getIndexTimeMs() >= abstractDetection2.getIndexTimeMs()) continue;
                abstractDetection2 = abstractDetection3;
                continue;
            }
            if (abstractDetection3.getIndexTimeMs() >= l) continue;
            if (abstractDetection2 == null) {
                abstractDetection2 = abstractDetection3;
                continue;
            }
            if (abstractDetection3.getIndexTimeMs() <= abstractDetection2.getIndexTimeMs()) continue;
            abstractDetection2 = abstractDetection3;
        }
        return abstractDetection2;
    }

    private void aboutDialogMenueItemActionPerformed(ActionEvent actionEvent) {
        JAboutDialog jAboutDialog = new JAboutDialog((Frame)this, true);
        jAboutDialog.setVisible(true);
    }

    void helpDialogMenueItemActionPerformed(ActionEvent actionEvent) {
        SonoViewManager.getInstance().forceOpenHelpFrame();
    }

    public void quickSaveEventAction(ActionEvent actionEvent) {
        AbstractDetection abstractDetection = SonoViewManager.getInstance().getCurrentPattern();
        BoundedLongRangeModel boundedLongRangeModel = this.getSelectionModel();
        SonoViewPick sonoViewPick = null;
        if (boundedLongRangeModel instanceof PickedLongRangeModel) {
            sonoViewPick = ((PickedLongRangeModel)boundedLongRangeModel).getPick();
        }
        if (abstractDetection == null && sonoViewPick != null) {
            TraceViewState traceViewState = SonoViewManager.getInstance().getTraceView().getTraceViewModel().getState().clone();
            SonoViewDetection sonoViewDetection = new SonoViewDetection(boundedLongRangeModel.getValue(), boundedLongRangeModel.getExtent(), sonoViewPick.copy(), PlatformUtil.getUserName(), DateTimeUtil.nowMs(), EventClass.get((String)""), traceViewState);
            SonoViewManager.getInstance().getTraceView().getTraceViewModel().setState(traceViewState);
            EventFileManager eventFileManager = SuiteManager.INSTANCE.getEventFileManager();
            EventDialogController eventDialogController = new EventDialogController(sonoViewDetection);
            if (eventDialogController.showWriteEventDialog(this) == 0) {
                eventFileManager.getSonoViewDetections().add(eventDialogController.getEvent());
                SonoViewManager.getInstance().setCurrentPattern((AbstractDetection)eventDialogController.getEvent());
                SuiteManager.INSTANCE.getGlobalEventWindowModel().firePropertyChange("eventMarkers", true, false);
                eventFileManager.writeDetectionXml();
            }
            SonoViewManager.getInstance().updateEventList();
        } else if (sonoViewPick == null) {
            LogUtil.warn(this.getClass(), (String)"Place a pick on an active trace before writing a new event.", (boolean)true);
        }
    }

    public void editEventAction() {
        AbstractDetection abstractDetection = SonoViewManager.getInstance().getCurrentPattern();
        if (abstractDetection != null) {
            SonoViewDetection sonoViewDetection = null;
            if (abstractDetection instanceof SonoViewDetection && !abstractDetection.isBulletinEntry()) {
                sonoViewDetection = ((SonoViewDetection)abstractDetection).deepclone();
            }
            if (sonoViewDetection == null) {
                return;
            }
            EventDialogController eventDialogController = new EventDialogController(sonoViewDetection);
            if (eventDialogController.showEditEventDialog(this) == 0) {
                if (sonoViewDetection.isValid() == 0) {
                    sonoViewDetection.setTimeModifiedMs(DateTimeUtil.nowMs());
                    sonoViewDetection.setUserID(PlatformUtil.getUserName());
                    EventFileManager eventFileManager = SuiteManager.INSTANCE.getEventFileManager();
                    eventFileManager.removeDetection(abstractDetection);
                    eventFileManager.getSonoViewDetections().add(sonoViewDetection);
                    eventFileManager.writeDetectionXml();
                    SonoViewManager.getInstance().setCurrentPattern((AbstractDetection)sonoViewDetection);
                    SonoViewManager.getInstance().updateEventList();
                } else {
                    Object object = (String)SonoViewDetection.VALIDITY_MESSAGES.get(sonoViewDetection.isValid());
                    object = (String)object + "\nCan't write changes to event.";
                    LogUtil.error(EventDialogController.class, (String)object, (boolean)true);
                }
            }
        }
    }

    public void deleteEventAction() {
        AbstractDetection abstractDetection = SonoViewManager.getInstance().getCurrentPattern();
        if (abstractDetection != null) {
            if (abstractDetection instanceof SonoViewDetection && !abstractDetection.isBulletinEntry()) {
                SonoViewDetection sonoViewDetection = (SonoViewDetection)abstractDetection;
                EventDialogController eventDialogController = new EventDialogController(sonoViewDetection);
                if (eventDialogController.showDeleteEventDialog(this) == 0) {
                    EventFileManager eventFileManager = SuiteManager.INSTANCE.getEventFileManager();
                    eventFileManager.removeDetection((AbstractDetection)sonoViewDetection);
                    eventFileManager.writeDetectionXml();
                    SonoViewManager.getInstance().setCurrentPattern(null);
                    SonoViewManager.getInstance().updateEventList();
                }
            } else if (abstractDetection.isBulletinEntry()) {
                LogUtil.error(SonoViewDetection.class, (String)"Can't delete events from bulletin files", (boolean)true);
            }
        }
    }

    private void exitMenuItemActionPerformed(ActionEvent actionEvent) {
        SonoViewManager.getInstance().onShutdownRequest();
    }

    private void formWindowClosing(WindowEvent windowEvent) {
        SonoViewManager.getInstance().onShutdownRequest();
    }

    private void preferencesMenuItemActionPerformed(ActionEvent actionEvent) {
        SonoViewManager.getInstance().onDisplayPreferences();
    }

    public void largeShiftRightButtonActionPerformed(ActionEvent actionEvent) {
        long l = this.getSelectionModel().getValue() + this.getSelectionModel().getExtent();
        if (l <= SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge().getCampaignEpochEnd()) {
            this.getSelectionModel().setValue(l);
        }
    }

    public void largeShiftLeftButtonActionPerformed(ActionEvent actionEvent) {
        long l = this.getSelectionModel().getValue() - this.getSelectionModel().getExtent();
        if (l + this.getSelectionModel().getExtent() >= SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge().getCampaignEpochStart()) {
            this.getSelectionModel().setValue(l);
        }
    }

    public void smallShiftRightButtonActionPerformed(ActionEvent actionEvent) {
        long l = this.getSelectionModel().getValue() + this.getSelectionModel().getExtent() / 10L;
        if (l <= SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge().getCampaignEpochEnd()) {
            this.getSelectionModel().setValue(l);
        }
    }

    public void smallShiftLeftButtonActionPerformed(ActionEvent actionEvent) {
        long l = this.getSelectionModel().getValue() - this.getSelectionModel().getExtent() / 10L;
        if (l + this.getSelectionModel().getExtent() >= SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge().getCampaignEpochStart()) {
            this.getSelectionModel().setValue(l);
        }
    }

    public void sonogramLengthShiftLeftActionPerformed(ActionEvent actionEvent) {
        long l = this.getSelectionModel().getValue() - this.getModel().getTimeRangeModel().getIncrement();
        if (l + this.getSelectionModel().getExtent() >= SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge().getCampaignEpochStart()) {
            this.getSelectionModel().setValue(l);
        }
    }

    public void sonogramLengthShiftRightActionPerformed(ActionEvent actionEvent) {
        long l = this.getSelectionModel().getValue() + this.getModel().getTimeRangeModel().getIncrement();
        if (l <= SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge().getCampaignEpochEnd()) {
            this.getSelectionModel().setValue(l);
        }
    }

    protected void eventSetDynamicActionPerformed(ActionEvent actionEvent, boolean bl) {
        SonoViewConfiguration sonoViewConfiguration = SonoViewManager.getInstance().getSettingsManager().getUserConfiguration();
        sonoViewConfiguration.setDynamicSize(bl);
        SonoViewManager.getInstance().getSettingsManager().setUserConfiguration(sonoViewConfiguration);
    }

    public void updateModeButtons() {
        SonoViewConfiguration sonoViewConfiguration = SonoViewManager.getInstance().getSettingsManager().getUserConfiguration();
        this.setDynamicButton.setSelected(sonoViewConfiguration.getDynamicSize());
        this.setFixedButton.setSelected(!sonoViewConfiguration.getDynamicSize());
        this.showBulletinEventsCheckbox.setState(sonoViewConfiguration.getShowMarkers());
    }

    public void onePageDownActionPerformed() {
        BoundedLongRangeModel boundedLongRangeModel = this.timeControl.getAxisModel();
        int n = SettingsManager.getInstance().getUserConfiguration().getDynAwareDisplayedRows();
        if (n > 5) {
            --n;
        }
        boundedLongRangeModel.setValue(boundedLongRangeModel.getValue() + boundedLongRangeModel.getIncrement() * (long)n);
        this.largeSonogram.scrollTop();
        SuiteManager.INSTANCE.getGlobalEventWindowModel().setUpdating(false);
    }

    public void onePageUpActionPerformed() {
        BoundedLongRangeModel boundedLongRangeModel = this.timeControl.getAxisModel();
        int n = SettingsManager.getInstance().getUserConfiguration().getDynAwareDisplayedRows();
        if (n > 5) {
            --n;
        }
        boundedLongRangeModel.setValue(boundedLongRangeModel.getValue() - boundedLongRangeModel.getIncrement() * (long)n);
        this.largeSonogram.scrollBottom();
        SuiteManager.INSTANCE.getGlobalEventWindowModel().setUpdating(false);
    }

    public void oneLineDownActionPerformed() {
        BoundedLongRangeModel boundedLongRangeModel = this.timeControl.getAxisModel();
        boundedLongRangeModel.setValue(boundedLongRangeModel.getValue() + boundedLongRangeModel.getIncrement());
        SuiteManager.INSTANCE.getGlobalEventWindowModel().setUpdating(false);
    }

    public void oneLineUpActionPerformed() {
        BoundedLongRangeModel boundedLongRangeModel = this.timeControl.getAxisModel();
        boundedLongRangeModel.setValue(boundedLongRangeModel.getValue() - boundedLongRangeModel.getIncrement());
        SuiteManager.INSTANCE.getGlobalEventWindowModel().setUpdating(false);
    }

    public void resizeSelectionActionPerformed(boolean bl) {
        BoundedLongRangeModel boundedLongRangeModel = this.getSelectionModel();
        DataManager.getInstance().setEventWindowLength(bl);
        AbstractDetection abstractDetection = SonoViewManager.getInstance().getCurrentPattern();
        if (abstractDetection != null && abstractDetection instanceof SonoViewDetection) {
            SonoViewDetection sonoViewDetection = (SonoViewDetection)abstractDetection;
            sonoViewDetection.setStartTimeMs(boundedLongRangeModel.getValue());
            sonoViewDetection.setDurationMs((long)((int)boundedLongRangeModel.getExtent()));
            sonoViewDetection.setTimeModifiedMs(DateTimeUtil.nowMs());
            sonoViewDetection.setUserID(PlatformUtil.getUserName());
            SuiteManager.INSTANCE.getEventFileManager().writeDetectionXml();
        }
    }

    public void nextEventActionPerformed(ActionEvent actionEvent) {
        this.jumpToEvent(this.getNextEvent(true));
    }

    public void prevEventActionPerformed(ActionEvent actionEvent) {
        this.jumpToEvent(this.getNextEvent(false));
    }

    public void jumpToEvent(AbstractDetection abstractDetection) {
        if (abstractDetection != null) {
            SonoViewManager sonoViewManager = SonoViewManager.getInstance();
            BoundedLongRangeModel boundedLongRangeModel = this.getSelectionModel();
            TraceViewState traceViewState = null;
            if (abstractDetection instanceof SonoViewDetection) {
                boundedLongRangeModel.setValue(abstractDetection.getStartTimeMs());
                boundedLongRangeModel.setExtent(abstractDetection.getDurationMs());
                if (boundedLongRangeModel instanceof PickedLongRangeModel) {
                    ((PickedLongRangeModel)boundedLongRangeModel).setPick(abstractDetection.getPick());
                }
                traceViewState = ((SonoViewDetection)abstractDetection).getTraceViewState();
            } else {
                int n = SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge().getResamplingMode();
                long l = DefaultResamplingModes.getModeByIndex((int)n).getSelectionLengthMs();
                int n2 = (int)(l / 5L);
                boundedLongRangeModel.setValue(abstractDetection.getStartTimeMs() - (long)n2);
                boundedLongRangeModel.setExtent(l);
                if (boundedLongRangeModel instanceof PickedLongRangeModel) {
                    ((PickedLongRangeModel)boundedLongRangeModel).setPick(null);
                }
            }
            sonoViewManager.getTraceView().getTraceViewModel().setState(traceViewState);
            sonoViewManager.setCurrentPattern(abstractDetection);
            sonoViewManager.forceOpenTraceView();
            sonoViewManager.updateEventList();
        }
    }

    public void showFirstStartMessage() {
        SonoViewConfiguration sonoViewConfiguration = SonoViewManager.getInstance().getSettingsManager().getUserConfiguration();
        if (SettingsManager.getInstance().getUserConfiguration().isSonoviewFirstStart()) {
            sonoViewConfiguration.setSonoviewFirstStart(false);
            SonoViewManager.getInstance().getSettingsManager().setUserConfiguration(sonoViewConfiguration);
            LogUtil.info(this.getClass(), (String)"<html><center>Loaded data segment exceeds window size.<br>Use scroll bar to view lower part of sonograms.<br>or<br>Exclude scrolling by selecting View->dynamic view.</center></html>", (boolean)true);
        }
    }
}

