/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.sonoview.swing;

import edu.geophys.commons.themes.ThemeManager;
import edu.geophys.sonoview.swing.SonoViewBorderFactory;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.Timer;

public class SonoViewHelp
extends JFrame {
    private static final String TITLE = "Sonoview & TraceView Help";
    final JPanel svPanel = new JPanel();
    final JPanel tvPanel = new JPanel();

    public SonoViewHelp() {
        super(TITLE);
        this.setDefaultCloseOperation(1);
        this.svPanel.setOpaque(true);
        this.tvPanel.setOpaque(true);
        this.add(this.getHelpPanel());
        InputMap inputMap = this.getRootPane().getInputMap(2);
        ActionMap actionMap = this.getRootPane().getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "escape_event");
        actionMap.put("escape_event", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SonoViewHelp.this.setVisible(false);
            }
        });
        this.pack();
    }

    private JPanel getHelpPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        Font font = new Font("Dialog", 0, 15);
        jPanel.setBorder(SonoViewBorderFactory.getSonoViewBorder());
        JLabel jLabel = new JLabel();
        jLabel.setOpaque(true);
        jPanel.add(this.svPanel);
        this.svPanel.add(jLabel);
        this.svPanel.setBorder(BorderFactory.createTitledBorder("SonoView"));
        jLabel.setFont(font);
        jLabel.setText("<html>\t<table width='500px' cellspacing='1px'> <tr><td><b>LMB on Sonogram</b></td> \t\t<td>selected current [candidate] event</td></tr><tr><td><b>ctrl + LMB on Sonogram</b></td><td> create new candidate event on existing event</td></tr><tr><td><b>&uarr;, &darr;</b></td> \t\t<td>show next/previous page of Supersonograms</td></tr><tr><td><b>ctrl + &uarr;, ctrl + &darr;</b></td> <td>show next/previous row of Supersonograms</td></tr><tr><td><b>j</b></td> \t\t\t\t\t<td>jump to date</td></tr><tr>&nbsp;</tr><tr><td><b>&rarr;, &larr;</b></td> \t\t<td>jump to next/previous event</td></tr><tr><td><b>l</b></td> \t\t\t\t\t<td>list events </td></tr><tr><td><b>m</b></td> \t\t\t\t\t<td>mask/show event markers in Supersonogram </td></tr><tr><td><b>w,e,d</b></td>\t\t\t\t<td>Write/Edit/Delete current event [candidate]</td></tr><tr>&nbsp;</tr><tr><td><b>PageUp,PageDown</b>\t\t\t</td> <td>increase/decrease length of current [candidate] event</td></tr><tr>&nbsp;</tr></table></html>");
        JLabel jLabel2 = new JLabel();
        jLabel2.setOpaque(true);
        jPanel.add(this.tvPanel);
        this.tvPanel.add(jLabel2);
        this.tvPanel.setBorder(BorderFactory.createTitledBorder("TraceView"));
        jLabel2.setFont(font);
        jLabel2.setText("<html>\t<table width='500px' cellspacing='1px'> <tr><td><b>c</b></td> \t\t\t\t\t<td>toggle common scaling length</td></tr><tr><td><b>h</b></td> \t\t\t\t\t<td>toggle horizontal traces</td></tr><tr><td><b>a</b></td> \t\t\t\t\t<td>toggle Aux traces</td></tr><tr><td><b>G,g</b></td> \t\t\t\t\t<td>increase/decrease gain </td></tr><tr><td><b>ctrl + g</b></td> \t\t\t<td>reset gain </td></tr><tr><td><b>0-5</b></td> \t\t\t\t\t<td>toggle filter band</td></tr></table></html>");
        return jPanel;
    }

    public void blink() {
        Color color = ThemeManager.getInstance().getTheme().getHypolineRed();
        final Color color2 = this.tvPanel.getBackground();
        Timer timer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() instanceof Timer) {
                    SonoViewHelp.this.tvPanel.setBackground(color2);
                }
                SonoViewHelp.this.svPanel.setBackground(color2);
            }
        });
        timer.setRepeats(false);
        this.tvPanel.setBackground(color);
        this.svPanel.setBackground(color);
        timer.start();
    }
}

