/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.sonoview.swing.largesonogram;

import edu.geophys.commons.model.SNS;
import edu.geophys.commons.ui.AbstractChangeReportingModel;
import edu.geophys.commons.ui.BoundedLongRangeModel;
import edu.geophys.commons.ui.sonogram.ArraySonogramModel;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.sonoview.SonoViewManager;
import edu.geophys.sonoview.swing.largesonogram.RowSonogramModel;
import edu.geophys.sonoview.swing.largesonogram.SonogramProvider;
import java.awt.Container;
import java.awt.Cursor;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DefaultLargeSonogramModel
extends AbstractChangeReportingModel {
    private static final long serialVersionUID = -2667498630748905672L;
    private final RowSonogramModel[] rows;
    private final BoundedLongRangeModel timeRangeModel;
    private final SNS[] arrays;
    private final SonogramProvider sonogramProvider;
    private final int prefetchNum;
    private final long overlapMilliSeconds;
    private Worker worker = null;
    private boolean screenUpdating = false;

    public DefaultLargeSonogramModel(SNS[] sNSArray, BoundedLongRangeModel boundedLongRangeModel, SonogramProvider sonogramProvider, int n, long l) {
        long l2 = boundedLongRangeModel.getExtent() / boundedLongRangeModel.getIncrement();
        if (l2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("extend of time range model contains more sonograms than an array could handle");
        }
        this.arrays = sNSArray;
        this.prefetchNum = n > 0 ? n : 0;
        this.overlapMilliSeconds = l > 0L ? l : 0L;
        this.rows = new RowSonogramModel[(int)l2];
        this.sonogramProvider = sonogramProvider;
        this.timeRangeModel = boundedLongRangeModel;
        boundedLongRangeModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                DefaultLargeSonogramModel.this.updateData();
            }
        });
        this.updateData();
    }

    public int size() {
        return this.rows.length;
    }

    public RowSonogramModel get(int n) {
        return this.rows[n];
    }

    private void reset() {
        Arrays.fill((Object[])this.rows, null);
        this.fireStateChanged();
    }

    public final long getOverlapMilliSeconds() {
        return this.overlapMilliSeconds;
    }

    public final void destroyWorkers() {
        if (this.worker != null) {
            this.worker.cancel(true);
            this.worker = null;
        }
    }

    private void updateData() {
        if (this.worker != null) {
            this.worker.cancel(false);
            this.worker = null;
        }
        long l = this.timeRangeModel.getValue();
        long l2 = this.timeRangeModel.getExtent() / (long)this.rows.length;
        LinkedList<WorkerConfiguration> linkedList = new LinkedList<WorkerConfiguration>();
        for (int i = 0; i < this.rows.length + this.prefetchNum; ++i) {
            linkedList.add(new WorkerConfiguration(i, l, l2 + this.overlapMilliSeconds, this.overlapMilliSeconds));
            l += l2;
        }
        this.worker = new Worker(linkedList, this.sonogramProvider);
        LogUtil.debug(((Object)((Object)this)).getClass(), (String)("updateData(): starting worker (timeRangeModel=" + this.timeRangeModel.toString() + ")"));
        this.worker.execute();
    }

    public BoundedLongRangeModel getTimeRangeModel() {
        return this.timeRangeModel;
    }

    private final class Worker
    extends SwingWorker<List<WorkerConfiguration>, WorkerConfiguration> {
        private final List<WorkerConfiguration> jobConfig;
        private final SonogramProvider provider;

        private Worker(List<WorkerConfiguration> list, SonogramProvider sonogramProvider) {
            this.jobConfig = list;
            this.provider = sonogramProvider;
        }

        @Override
        protected List<WorkerConfiguration> doInBackground() throws Exception {
            Iterator<WorkerConfiguration> iterator = this.jobConfig.iterator();
            Container container = SonoViewManager.getInstance().getMainFrame().getContentPane();
            container.setCursor(Cursor.getPredefinedCursor(3));
            DefaultLargeSonogramModel.this.screenUpdating = true;
            LogUtil.debug(this.getClass(), (String)"worker.doInBackground(): worker running");
            while (!this.isCancelled() && iterator.hasNext()) {
                WorkerConfiguration workerConfiguration = iterator.next();
                for (SNS sNS : DefaultLargeSonogramModel.this.arrays) {
                    ArraySonogramModel arraySonogramModel = this.provider.getStationSonogram(workerConfiguration.start, workerConfiguration.fullLengthMs, sNS);
                    if (arraySonogramModel == null) continue;
                    arraySonogramModel.setArray(sNS);
                    workerConfiguration.result.add(arraySonogramModel);
                }
                this.publish(workerConfiguration);
            }
            LogUtil.debug(this.getClass(), (String)"worker.doInBackground(): worker finished");
            return this.jobConfig;
        }

        @Override
        protected void process(List<WorkerConfiguration> list) {
            if (this.isCancelled() || this.isDone() || list.size() < 1) {
                return;
            }
            for (WorkerConfiguration workerConfiguration : list) {
                if (workerConfiguration.position < DefaultLargeSonogramModel.this.rows.length) {
                    DefaultLargeSonogramModel.this.rows[workerConfiguration.position] = workerConfiguration.result;
                    continue;
                }
                if (!DefaultLargeSonogramModel.this.screenUpdating) continue;
                Container container = SonoViewManager.getInstance().getMainFrame().getContentPane();
                container.setCursor(Cursor.getPredefinedCursor(0));
                DefaultLargeSonogramModel.this.screenUpdating = false;
            }
            LogUtil.debug(this.getClass(), (String)"worker.process(): processed partial results");
            DefaultLargeSonogramModel.this.fireStateChanged();
        }

        @Override
        protected void done() {
            Container container = SonoViewManager.getInstance().getMainFrame().getContentPane();
            container.setCursor(Cursor.getPredefinedCursor(0));
            DefaultLargeSonogramModel.this.screenUpdating = false;
            if (this.isCancelled()) {
                return;
            }
            try {
                List list;
                try {
                    list = (List)this.get();
                }
                catch (Exception exception) {
                    list = null;
                }
                if (list != null) {
                    for (WorkerConfiguration workerConfiguration : (List)this.get()) {
                        if (workerConfiguration.position >= DefaultLargeSonogramModel.this.rows.length) continue;
                        DefaultLargeSonogramModel.this.rows[workerConfiguration.position] = workerConfiguration.result;
                    }
                }
                LogUtil.debug(this.getClass(), (String)"worker.done(): updated results");
                DefaultLargeSonogramModel.this.fireStateChanged();
            }
            catch (InterruptedException interruptedException) {
                LogUtil.error(((Object)((Object)DefaultLargeSonogramModel.this)).getClass(), (String)"Data loading interupted: computation was interrupted", (Throwable)interruptedException);
                DefaultLargeSonogramModel.this.reset();
            }
            catch (ExecutionException executionException) {
                LogUtil.warn(((Object)((Object)DefaultLargeSonogramModel.this)).getClass(), (String)"Data loading interupted: computation execution error", (Throwable)executionException);
                DefaultLargeSonogramModel.this.reset();
            }
        }
    }

    private final class WorkerConfiguration {
        public final int position;
        public final long start;
        public final long fullLengthMs;
        public final long overlapMs;
        public final RowSonogramModel result;

        public WorkerConfiguration(int n, long l, long l2, long l3) {
            this.position = n;
            this.start = l;
            this.fullLengthMs = l2;
            this.overlapMs = l3;
            this.result = new RowSonogramModel(l, l2, l3);
        }
    }
}

