/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.sonoview.swing.largesonogram;

import edu.geophys.commons.detection.AbstractDetection;
import edu.geophys.commons.detection.SonoViewDetection;
import edu.geophys.commons.detection.SonoViewPick;
import edu.geophys.commons.detection.TraceViewState;
import edu.geophys.commons.detection.interfaces.HasOnsetMarkers;
import edu.geophys.commons.model.knowledgebase.CampaignKnowledge;
import edu.geophys.commons.resamplingmodes.DefaultResamplingModes;
import edu.geophys.commons.suite.EventFileManager;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.themes.ThemeManager;
import edu.geophys.commons.ui.BoundedLongRangeModel;
import edu.geophys.commons.ui.DefaultBoundedLongRangeModel;
import edu.geophys.commons.ui.sonogram.AbstractSonogramComponent;
import edu.geophys.commons.ui.sonogram.EmptySelectionRenderer;
import edu.geophys.commons.ui.sonogram.JStationSonogram;
import edu.geophys.commons.ui.sonogram.SelectionRenderer;
import edu.geophys.sonoview.PickedLongRangeModel;
import edu.geophys.sonoview.SonoViewConfiguration;
import edu.geophys.sonoview.SonoViewManager;
import edu.geophys.sonoview.swing.largesonogram.JRowSonogram;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SonoViewStationSonogram
extends JStationSonogram {
    private static final long serialVersionUID = -530639078556448082L;
    private boolean stationNameVisible = false;
    private List<AbstractDetection> detections = null;
    private final JRowSonogram parentRow;

    public boolean isStationNameVisible() {
        return this.stationNameVisible;
    }

    public SonoViewStationSonogram(JRowSonogram jRowSonogram) {
        this.setSelectionRenderer((SelectionRenderer)new EmptySelectionRenderer());
        this.parentRow = jRowSonogram;
    }

    public void setStationNameVisible(boolean bl) {
        this.stationNameVisible = bl;
        this.repaint();
    }

    private void repaintRow() {
        this.parentRow.updateChilds();
    }

    protected MouseAdapter newDefaultMouseClickAdapter() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    int n = SonoViewStationSonogram.this.getTimePartition(mouseEvent.getPoint());
                    long l = SonoViewStationSonogram.this.renderedSonogram.getStartTime() + (long)n * SonoViewStationSonogram.this.renderedSonogram.getTimeIncrement();
                    if (!SonoViewStationSonogram.this.hasValidData() || n < 0) {
                        return;
                    }
                    BoundedLongRangeModel boundedLongRangeModel = SonoViewStationSonogram.this.getCursorModel();
                    BoundedLongRangeModel boundedLongRangeModel2 = SonoViewStationSonogram.this.getSelectionModel();
                    AbstractSonogramComponent.RenderedSonogramModel renderedSonogramModel = SonoViewStationSonogram.this.getRenderedSonogramModel();
                    EventFileManager eventFileManager = SuiteManager.INSTANCE.getEventFileManager();
                    AbstractDetection abstractDetection = eventFileManager.getDetectionAt(l);
                    CampaignKnowledge campaignKnowledge = SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge();
                    SonoViewConfiguration sonoViewConfiguration = SonoViewManager.getInstance().getSettingsManager().getUserConfiguration();
                    if (abstractDetection == null || !(abstractDetection instanceof SonoViewDetection) || (mouseEvent.getModifiers() & 2) == 2) {
                        abstractDetection = null;
                        SonoViewManager.getInstance().setCurrentPattern(null);
                        boundedLongRangeModel.setRangeProperties(l, renderedSonogramModel.getTimeIncrement(), renderedSonogramModel.getStartTime(), renderedSonogramModel.getEndTime(), 1L, false);
                        long l2 = DefaultResamplingModes.getModeByIndex((int)campaignKnowledge.getResamplingMode()).getSelectionLengthMs(0);
                        sonoViewConfiguration.setSelectionLengthIndex(0);
                        boundedLongRangeModel2.setValue(l - l2 / 5L);
                        boundedLongRangeModel2.setExtent(l2);
                        if (boundedLongRangeModel2 instanceof PickedLongRangeModel) {
                            ((PickedLongRangeModel)boundedLongRangeModel2).setPick(new SonoViewPick(l, SonoViewStationSonogram.this.getModel().getArray().getID()));
                        }
                        SonoViewManager.getInstance().getTraceView().getTraceViewModel().setState(null);
                    } else {
                        boundedLongRangeModel.setRangeProperties(abstractDetection.getStartTimeMs(), renderedSonogramModel.getTimeIncrement(), renderedSonogramModel.getStartTime(), renderedSonogramModel.getEndTime(), 1L, false);
                        boundedLongRangeModel2.setValue(abstractDetection.getStartTimeMs());
                        boundedLongRangeModel2.setExtent(abstractDetection.getDurationMs());
                        int n2 = DefaultResamplingModes.getModeByIndex((int)campaignKnowledge.getResamplingMode()).getSelectionIndexByMs((double)abstractDetection.getDurationMs());
                        sonoViewConfiguration.setSelectionLengthIndex(n2);
                        if (abstractDetection.getPick() != null) {
                            ((PickedLongRangeModel)boundedLongRangeModel2).setPick(abstractDetection.getPick());
                        } else {
                            ((PickedLongRangeModel)boundedLongRangeModel2).setPick(null);
                        }
                        SonoViewManager.getInstance().setCurrentPattern(abstractDetection);
                        if (abstractDetection instanceof SonoViewDetection) {
                            TraceViewState traceViewState = ((SonoViewDetection)abstractDetection).getTraceViewState();
                            SonoViewManager.getInstance().getTraceView().getTraceViewModel().setState(traceViewState);
                        }
                    }
                    SonoViewManager.getInstance().forceOpenTraceView();
                    SonoViewManager.getInstance().updateEventList();
                    SonoViewStationSonogram.this.repaintRow();
                }
            }
        };
    }

    protected void paintComponent(Graphics graphics) {
        DefaultBoundedLongRangeModel defaultBoundedLongRangeModel;
        Rectangle2D rectangle2D;
        BoundedLongRangeModel boundedLongRangeModel;
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (this.stationNameVisible) {
            graphics2D.setColor(this.getSelectionColor());
            graphics2D.setFont(graphics2D.getFont().deriveFont(1, this.getHeight()));
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            graphics2D.drawString(this.getModel().getArray().getID(), 2, this.getHeight() - 2);
        }
        if ((boundedLongRangeModel = this.getSelectionModel()) != null & boundedLongRangeModel instanceof PickedLongRangeModel) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            SonoViewPick sonoViewPick = ((PickedLongRangeModel)boundedLongRangeModel).getPick();
            if (sonoViewPick != null && SonoViewManager.getInstance().isUseTraceViewFrame() && Arrays.asList(sonoViewPick.getTraceIDs()).contains(this.getModel().getArray().getID())) {
                this.drawArrow(graphics2D, sonoViewPick.getTimeMs(), this.getSelectionColor());
            }
        }
        this.drawEventArrows(graphics2D, SonoViewManager.getInstance().getSettingsManager().getUserConfiguration().getShowMarkers());
        long l = SonoViewManager.getInstance().getMainFrame().getModel().getOverlapMilliSeconds();
        if (l > 0L && (rectangle2D = this.getAreaInSonogram((BoundedLongRangeModel)(defaultBoundedLongRangeModel = new DefaultBoundedLongRangeModel((long)(this.getModel().getEndEpochTime() * 1000.0 - (double)l), l, (long)(this.getModel().getEndEpochTime() * 1000.0 - (double)l), (long)(this.getModel().getEndEpochTime() * 1000.0), 1L)))) != null) {
            graphics2D.setColor(ThemeManager.getInstance().getTheme().getAxisColor());
            graphics2D.setComposite(AlphaComposite.getInstance(3, SonoViewManager.getInstance().getSettingsManager().getUserConfiguration().getOverlapComposite()));
            graphics2D.fillRect((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
            graphics2D.setComposite(AlphaComposite.SrcOver);
        }
        graphics2D.dispose();
    }

    private void drawArrow(Graphics2D graphics2D, long l, Color color) {
        Rectangle2D rectangle2D = this.getAreaInSonogram((BoundedLongRangeModel)new DefaultBoundedLongRangeModel(l, 1L, l, l + 1L, 1L));
        if (rectangle2D != null) {
            Stroke stroke = graphics2D.getStroke();
            if (color != null) {
                graphics2D.setColor(color);
            } else {
                graphics2D.setColor(ThemeManager.getInstance().getTheme().getAxisColor());
            }
            double d = rectangle2D.getHeight();
            double d2 = rectangle2D.getX();
            double d3 = rectangle2D.getY();
            int n = (int)d2;
            int n2 = (int)((d3 + d) / 2.0);
            int n3 = (int)(d2 - d / 6.0);
            int n4 = (int)(d2 - d / 3.0);
            int n5 = (int)d3;
            int n6 = (int)(d2 - d / 3.0);
            int n7 = (int)(d3 + d);
            Path2D.Double double_ = new Path2D.Double();
            double_.moveTo(n4, n5);
            double_.lineTo(n, n2);
            double_.lineTo(n6, n7);
            double_.lineTo(n3, n2);
            double_.closePath();
            graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
            graphics2D.fill(double_);
            graphics2D.setStroke(stroke);
        }
    }

    private void drawEventArrows(Graphics2D graphics2D, boolean bl) {
        if (this.detections == null) {
            return;
        }
        String string = this.getModel().getArray().getID();
        for (AbstractDetection abstractDetection : this.detections) {
            Long l;
            boolean bl2;
            if (!(abstractDetection instanceof HasOnsetMarkers)) continue;
            boolean bl3 = bl2 = abstractDetection.getSource() != null;
            if (bl2 && !bl || (l = ((HasOnsetMarkers)abstractDetection).getMarker(string)) == null) continue;
            this.drawArrow(graphics2D, l, abstractDetection.getColor());
        }
    }

    public void setTrainingEntries(List<AbstractDetection> list) {
        this.detections = new ArrayList<AbstractDetection>();
        String string = this.getModel().getArray().getID();
        for (AbstractDetection abstractDetection : list) {
            HasOnsetMarkers hasOnsetMarkers;
            if (!(abstractDetection instanceof HasOnsetMarkers) || (hasOnsetMarkers = (HasOnsetMarkers)abstractDetection).getMarker(string) == null) continue;
            this.detections.add(abstractDetection);
        }
    }
}

