/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.sonoview.traceview;

import edu.geophys.commons.ui.BoundedLongRangeModel;
import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.sonoview.traceview.TraceViewDataStore;
import edu.geophys.sonoview.traceview.TraceViewModel;
import edu.geophys.sonoview.traceview.swing.TraceViewFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TraceView {
    private final TraceViewFrame traceViewFrame;
    private TraceViewModel traceViewModel;
    private TraceViewDataStore dataStore = null;
    BoundedLongRangeModel selection = null;
    public final ChangeListener traceViewListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            TraceView.this.update();
        }
    };

    public TraceView() {
        this.traceViewModel = new TraceViewModel(this);
        this.traceViewFrame = new TraceViewFrame(this);
        this.traceViewModel.updateActiveSns();
    }

    public TraceViewFrame getFrame() {
        return this.traceViewFrame;
    }

    public void setTitle(String string) {
        if (this.traceViewFrame != null) {
            this.traceViewFrame.setTitle(string);
        }
    }

    public void setSelection(BoundedLongRangeModel boundedLongRangeModel) {
        this.selection = boundedLongRangeModel;
    }

    public BoundedLongRangeModel getSelection() {
        return this.selection;
    }

    public void update() {
        if (this.dataStore == null || !this.dataStore.isIncluding(this.selection)) {
            this.dataStore = new TraceViewDataStore(this.traceViewModel.getAllTraceIDs(), this.selection);
        }
        this.traceViewModel.fireSelectionChange();
        this.traceViewFrame.update();
        this.traceViewFrame.revalidate();
    }

    public String toString() {
        Object object = " TraceView state:\nSelection: ";
        object = this.selection == null ? (String)object + "null\n" : (String)object + DateTimeUtil.formatDateTimeISO((long)this.selection.getValue()) + " Length: " + (int)(this.selection.getExtent() / 1000L) + " sec\n";
        object = (String)object + this.dataStore;
        return object;
    }

    public TraceViewModel getTraceViewModel() {
        return this.traceViewModel;
    }

    public TraceViewDataStore getDataStore() {
        return this.dataStore;
    }

    public void setTraceViewModel(TraceViewModel traceViewModel) {
        this.traceViewModel = traceViewModel;
    }
}

