/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.sonoview.traceview;

import edu.geophys.commons.detection.TraceViewState;
import edu.geophys.commons.model.AbstractTrace;
import edu.geophys.commons.model.DefaultTrace;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.suite.TraceProvider;
import edu.geophys.commons.ui.BoundedLongRangeModel;
import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.sonoview.swing.FilteringTrace;
import java.util.ArrayList;
import java.util.HashMap;

public class TraceViewDataStore {
    private final double epochStart;
    private final double epochEnd;
    private final HashMap<String, AbstractTrace> rawData;
    private final HashMap<TraceViewState.FilterType, HashMap<String, AbstractTrace>> filteredData;

    public TraceViewDataStore(ArrayList<String> arrayList, BoundedLongRangeModel boundedLongRangeModel) {
        float f = SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge().getGlobalSamplerate();
        int n = (int)(1.6384E7f / f);
        this.epochStart = DateTimeUtil.convertLongMsToDoubleS((long)(boundedLongRangeModel.getValue() - (long)n));
        this.epochEnd = DateTimeUtil.convertLongMsToDoubleS((long)(boundedLongRangeModel.getValue() + boundedLongRangeModel.getExtent() + (long)n));
        this.rawData = new HashMap();
        this.filteredData = new HashMap();
        TraceProvider traceProvider = SuiteManager.INSTANCE.getTraceProvider();
        for (String string : arrayList) {
            try {
                DefaultTrace defaultTrace = traceProvider.requestTrace(this.getEpochStart(), this.getEpochEnd(), f, new String[]{string})[0];
                this.rawData.put(string, (AbstractTrace)defaultTrace);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LogUtil.info(this.getClass(), (String)illegalArgumentException.getMessage());
            }
        }
    }

    public float[] getTraceData(String string, double d, double d2, TraceViewState.FilterType filterType) {
        if (filterType == null) {
            return this.rawData.get(string).getSamples(d, d2);
        }
        if (!this.filteredData.containsKey(filterType)) {
            this.filterData(filterType);
        }
        return this.filteredData.get(filterType).get(string).getSamples(d, d2);
    }

    public void filterData(TraceViewState.FilterType filterType) {
        this.filteredData.put(filterType, new HashMap());
        for (String string : this.rawData.keySet()) {
            FilteringTrace filteringTrace = new FilteringTrace(this.rawData.get(string));
            filteringTrace.filter(filterType);
            this.filteredData.get(filterType).put(string, filteringTrace);
        }
    }

    public boolean isIncluding(BoundedLongRangeModel boundedLongRangeModel) {
        double d = DateTimeUtil.convertLongMsToDoubleS((long)boundedLongRangeModel.getValue());
        double d2 = DateTimeUtil.convertLongMsToDoubleS((long)(boundedLongRangeModel.getValue() + boundedLongRangeModel.getExtent()));
        return d > this.epochStart && d2 < this.epochEnd;
    }

    public double getEpochStart() {
        return this.epochStart;
    }

    public double getEpochEnd() {
        return this.epochEnd;
    }

    public String toString() {
        Object object = "TraceViewDataStore:\n";
        object = (String)object + "from " + DateTimeUtil.formatDateTimeISO((double)this.getEpochStart()) + "\nto   " + DateTimeUtil.formatDateTimeISO((double)this.getEpochEnd()) + "\n";
        for (String string : this.rawData.keySet()) {
            AbstractTrace abstractTrace = this.rawData.get(string);
            object = (String)object + "RAW:" + string + ": " + abstractTrace.getStationID() + "-" + abstractTrace.hashCode() + "-" + DateTimeUtil.formatDateTimeISO((double)abstractTrace.getStartEpochTime()) + "-" + abstractTrace.getLength() + "nspl-" + abstractTrace.getSamplerate() + "Hz\n";
        }
        for (TraceViewState.FilterType filterType : this.filteredData.keySet()) {
            for (String string : this.filteredData.get(filterType).keySet()) {
                AbstractTrace abstractTrace = this.rawData.get(string);
                object = (String)object + filterType.toString() + ":" + string + ": " + abstractTrace.getStationID() + "-" + abstractTrace.hashCode() + "-" + DateTimeUtil.formatDateTimeISO((double)abstractTrace.getStartEpochTime()) + "-" + abstractTrace.getLength() + "nspl-" + abstractTrace.getSamplerate() + "Hz\n";
            }
        }
        return object;
    }
}

