/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.sonoview.traceview;

import edu.geophys.commons.model.SNS;
import edu.geophys.commons.model.Site;
import edu.geophys.sonoview.traceview.TraceViewModel;
import edu.geophys.sonoview.traceview.TraceViewTraceModel;
import java.util.ArrayList;

public class TraceViewSnsModel {
    private final TraceViewModel traceViewModel;
    private final String snsName;
    private final TraceViewTraceModel ZCenter;
    private final ArrayList<TraceViewTraceModel> HCenter = new ArrayList();
    private final ArrayList<TraceViewTraceModel> ZAux = new ArrayList();

    public TraceViewSnsModel(SNS sNS, TraceViewModel traceViewModel) {
        this.snsName = sNS.getID();
        this.traceViewModel = traceViewModel;
        this.ZCenter = new TraceViewTraceModel(sNS.getCenter().getTraceZ(), this);
        String string = sNS.getCenter().getTraceNS();
        if (string != null) {
            this.HCenter.add(new TraceViewTraceModel(string, this));
        }
        if ((string = sNS.getCenter().getTraceEW()) != null) {
            this.HCenter.add(new TraceViewTraceModel(string, this));
        }
        for (Site site : sNS.getAllSatellites()) {
            string = site.getTraceZ();
            if (string == null) continue;
            this.ZAux.add(new TraceViewTraceModel(string, this));
        }
    }

    public ArrayList<TraceViewTraceModel> getAllTraces() {
        ArrayList<TraceViewTraceModel> arrayList = new ArrayList<TraceViewTraceModel>();
        arrayList.add(this.ZCenter);
        for (TraceViewTraceModel traceViewTraceModel : this.HCenter) {
            arrayList.add(traceViewTraceModel);
        }
        for (TraceViewTraceModel traceViewTraceModel : this.ZAux) {
            arrayList.add(traceViewTraceModel);
        }
        return arrayList;
    }

    public String getSnsName() {
        return this.snsName;
    }

    public float getAbsValueAllTraces() {
        float f = 0.0f;
        for (TraceViewTraceModel traceViewTraceModel : this.getAllTraces()) {
            float f2 = traceViewTraceModel.getAbsValue();
            if (!(f2 > f)) continue;
            f = f2;
        }
        return f;
    }

    public TraceViewModel getTraceViewModel() {
        return this.traceViewModel;
    }

    public TraceViewTraceModel getZCenter() {
        return this.ZCenter;
    }

    public ArrayList<TraceViewTraceModel> getHCenter() {
        return this.HCenter;
    }

    public ArrayList<TraceViewTraceModel> getZAux() {
        return this.ZAux;
    }

    public void fireSelectionChange() {
        for (TraceViewTraceModel traceViewTraceModel : this.getAllTraces()) {
            traceViewTraceModel.fireSelectionChange();
        }
    }
}

