/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.sonoview.traceview.swing;

import edu.geophys.commons.ui.FrameIconSetter;
import edu.geophys.sonoview.traceview.TraceView;
import edu.geophys.sonoview.traceview.TraceViewSnsModel;
import edu.geophys.sonoview.traceview.swing.TraceViewSnsPanel;
import edu.geophys.sonoview.traceview.swing.TraceViewStatusbar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TraceViewFrame
extends JFrame {
    private final JPanel seismogramPanel = new JPanel();
    private final TraceView traceView;
    private final TraceViewStatusbar statusBar;

    public TraceViewFrame(TraceView traceView) {
        super("TraceView");
        FrameIconSetter.setFrameIcon((JFrame)this);
        this.traceView = traceView;
        this.setAutoRequestFocus(false);
        this.setDefaultCloseOperation(1);
        this.setMinimumSize(new Dimension(400, 400));
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.seismogramPanel, 20, 31);
        this.seismogramPanel.setLayout(new BoxLayout(this.seismogramPanel, 3));
        jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.add((Component)jScrollPane, "Center");
        this.statusBar = new TraceViewStatusbar(traceView.getTraceViewModel());
        this.add((Component)this.statusBar, "South");
        this.statusBar.update();
        this.pack();
    }

    public void update() {
        this.statusBar.update();
        this.seismogramPanel.removeAll();
        for (TraceViewSnsModel traceViewSnsModel : this.traceView.getTraceViewModel().getActiveSns()) {
            this.seismogramPanel.add(new TraceViewSnsPanel(traceViewSnsModel));
            this.seismogramPanel.add(Box.createRigidArea(new Dimension(2, 2)));
        }
    }

    public TraceViewStatusbar getStatusBar() {
        return this.statusBar;
    }
}

