/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.sonoview.traceview.swing;

import edu.geophys.commons.themes.SuiteTheme;
import edu.geophys.commons.themes.ThemeManager;
import edu.geophys.commons.ui.BoundedLongRangeModel;
import edu.geophys.commons.ui.trace.PlotRenderer;
import edu.geophys.sonoview.SonoViewConfiguration;
import edu.geophys.sonoview.SonoViewManager;
import edu.geophys.sonoview.traceview.TraceView;
import edu.geophys.sonoview.traceview.TraceViewModel;
import edu.geophys.sonoview.traceview.TraceViewSnsModel;
import edu.geophys.sonoview.traceview.TraceViewTraceModel;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JComponent;

public class TraceViewSnsPlot
extends JComponent {
    private PlotRenderer plotZCenter = null;
    private final ArrayList<PlotRenderer> plotZAux = new ArrayList();
    private final ArrayList<PlotRenderer> plotHCenter = new ArrayList();
    private TraceViewSnsModel snsModel;
    private float scale;
    SuiteTheme theme = null;
    private MouseAdapter mouseAdapter = new MouseAdapter(){

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            TraceViewSnsPlot.this.snsModel.getTraceViewModel().getTraceView().getFrame().getStatusBar().clearTimeLabel();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            TraceView traceView = TraceViewSnsPlot.this.snsModel.getTraceViewModel().getTraceView();
            BoundedLongRangeModel boundedLongRangeModel = traceView.getSelection();
            long l = boundedLongRangeModel.getValue() + boundedLongRangeModel.getExtent() * (long)mouseEvent.getX() / (long)TraceViewSnsPlot.this.getWidth();
            traceView.getFrame().getStatusBar().updateTimeLabel(l);
            float f = (1.0f - (float)(2.0 * point.getY() / (double)TraceViewSnsPlot.this.getHeight())) / TraceViewSnsPlot.this.scale;
            traceView.getFrame().getStatusBar().updateAmplitudeLabel(f);
        }
    };

    public TraceViewSnsPlot(TraceViewSnsModel traceViewSnsModel) {
        PlotRenderer plotRenderer;
        SonoViewConfiguration sonoViewConfiguration = SonoViewManager.getInstance().getSettingsManager().getUserConfiguration();
        this.snsModel = traceViewSnsModel;
        TraceViewModel traceViewModel = traceViewSnsModel.getTraceViewModel();
        this.plotZCenter = new PlotRenderer();
        TraceViewTraceModel traceViewTraceModel = traceViewSnsModel.getZCenter();
        if (traceViewTraceModel.getValues() != null) {
            this.plotZCenter.setValues(traceViewTraceModel.getValues());
        }
        for (TraceViewTraceModel traceViewTraceModel2 : traceViewSnsModel.getHCenter()) {
            if (traceViewTraceModel2.getValues() == null) continue;
            plotRenderer = new PlotRenderer();
            plotRenderer.setValues(traceViewTraceModel2.getValues());
            this.plotHCenter.add(plotRenderer);
        }
        for (TraceViewTraceModel traceViewTraceModel2 : traceViewSnsModel.getZAux()) {
            if (traceViewTraceModel2.getValues() == null) continue;
            plotRenderer = new PlotRenderer();
            plotRenderer.setValues(traceViewTraceModel2.getValues());
            this.plotZAux.add(plotRenderer);
        }
        this.reloadPlotColors();
        this.scale = traceViewModel.isCommonScaling() ? 0.97f / traceViewModel.getAbsValueAllSns() : 0.97f / traceViewSnsModel.getAbsValueAllTraces();
        this.scale /= traceViewModel.getGain();
        for (PlotRenderer plotRenderer2 : this.getAllRenderers()) {
            plotRenderer2.setExternalScale((double)this.scale);
        }
        this.addMouseMotionListener(this.mouseAdapter);
        this.addMouseListener(this.mouseAdapter);
    }

    private void reloadPlotColors() {
        SuiteTheme suiteTheme = ThemeManager.getInstance().getTheme();
        if (suiteTheme == this.theme) {
            return;
        }
        this.theme = suiteTheme;
        TraceViewTraceModel traceViewTraceModel = this.snsModel.getZCenter();
        this.plotZCenter.setForegroundColor(suiteTheme.getZCenterColor());
        for (PlotRenderer plotRenderer : this.plotHCenter) {
            plotRenderer.setForegroundColor(suiteTheme.getHCenterColor());
        }
        for (PlotRenderer plotRenderer : this.plotZAux) {
            plotRenderer.setForegroundColor(suiteTheme.getZSatteliteColor());
        }
    }

    private ArrayList<PlotRenderer> getAllRenderers() {
        ArrayList<PlotRenderer> arrayList = new ArrayList<PlotRenderer>();
        arrayList.add(this.plotZCenter);
        for (PlotRenderer plotRenderer : this.plotZAux) {
            arrayList.add(plotRenderer);
        }
        for (PlotRenderer plotRenderer : this.plotHCenter) {
            arrayList.add(plotRenderer);
        }
        return arrayList;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.reloadPlotColors();
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Rectangle2D.Double double_ = new Rectangle2D.Double(this.getInsets().left, this.getInsets().top, this.getWidth() - (this.getInsets().left + this.getInsets().right), this.getHeight() - (this.getInsets().top + this.getInsets().bottom));
        if (this.snsModel.getTraceViewModel().isShowAuxTraces()) {
            for (PlotRenderer plotRenderer : this.plotZAux) {
                plotRenderer.draw(graphics2D, (Rectangle2D)double_);
            }
        }
        if (this.snsModel.getTraceViewModel().isShowHorizontalTraces()) {
            for (PlotRenderer plotRenderer : this.plotHCenter) {
                plotRenderer.draw(graphics2D, (Rectangle2D)double_);
            }
        }
        this.plotZCenter.draw(graphics2D, (Rectangle2D)double_);
        graphics2D.dispose();
    }

    public float getScale() {
        return this.scale;
    }
}

