/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.ProxySurface;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.opengl.Debug;
import jogamp.opengl.GLDrawableFactoryImpl;
import jogamp.opengl.GLDynamicLookupHelper;

public abstract class GLDrawableImpl
implements GLDrawable {
    protected static final boolean DEBUG = Debug.debug("GLDrawable");
    protected GLDrawableFactory factory;
    protected NativeSurface surface;
    protected GLCapabilitiesImmutable requestedCapabilities;
    protected boolean realized;

    protected GLDrawableImpl(GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface, boolean bl) {
        this.factory = gLDrawableFactory;
        this.surface = nativeSurface;
        this.realized = bl;
        this.requestedCapabilities = (GLCapabilitiesImmutable)this.surface.getGraphicsConfiguration().getRequestedCapabilities();
    }

    public abstract GLDynamicLookupHelper getGLDynamicLookupHelper();

    public final GLDrawableFactoryImpl getFactoryImpl() {
        return (GLDrawableFactoryImpl)this.getFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void swapBuffers() throws GLException {
        if (!this.realized) {
            return;
        }
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)this.surface.getGraphicsConfiguration().getChosenCapabilities();
        if (gLCapabilitiesImmutable.getDoubleBuffered()) {
            if (!this.surface.surfaceSwap()) {
                int n = this.lockSurface();
                if (1 == n) {
                    return;
                }
                try {
                    if (2 == n) {
                        this.updateHandle();
                    }
                    this.swapBuffersImpl();
                }
                finally {
                    this.unlockSurface();
                }
            }
        } else {
            GLContext gLContext = GLContext.getCurrent();
            if (null != gLContext && gLContext.getGLDrawable() == this) {
                gLContext.getGL().glFinish();
            }
        }
        this.surface.surfaceUpdated(this, this.surface, System.currentTimeMillis());
    }

    protected abstract void swapBuffersImpl();

    public static final String toHexString(long l) {
        return "0x" + Long.toHexString(l);
    }

    @Override
    public final GLProfile getGLProfile() {
        return this.requestedCapabilities.getGLProfile();
    }

    @Override
    public GLCapabilitiesImmutable getChosenGLCapabilities() {
        return (GLCapabilitiesImmutable)this.surface.getGraphicsConfiguration().getChosenCapabilities();
    }

    public final GLCapabilitiesImmutable getRequestedGLCapabilities() {
        return this.requestedCapabilities;
    }

    @Override
    public NativeSurface getNativeSurface() {
        return this.surface;
    }

    protected void destroyHandle() {
    }

    protected void updateHandle() {
    }

    @Override
    public long getHandle() {
        return this.surface.getSurfaceHandle();
    }

    @Override
    public final GLDrawableFactory getFactory() {
        return this.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void setRealized(boolean bl) {
        if (this.realized != bl) {
            if (DEBUG) {
                System.err.println(GLDrawableImpl.getThreadName() + ": setRealized: " + this.getClass().getSimpleName() + " " + this.realized + " -> " + bl);
            }
            this.realized = bl;
            AbstractGraphicsDevice abstractGraphicsDevice = this.surface.getGraphicsConfiguration().getScreen().getDevice();
            if (bl) {
                if (this.surface instanceof ProxySurface) {
                    ((ProxySurface)this.surface).createNotify();
                }
                if (1 >= this.lockSurface()) {
                    throw new GLException("GLDrawableImpl.setRealized(true): Surface not ready (lockSurface)");
                }
            } else {
                abstractGraphicsDevice.lock();
            }
            try {
                if (bl) {
                    this.setRealizedImpl();
                    this.updateHandle();
                }
                this.destroyHandle();
                this.setRealizedImpl();
            }
            finally {
                if (bl) {
                    this.unlockSurface();
                } else {
                    abstractGraphicsDevice.unlock();
                    if (this.surface instanceof ProxySurface) {
                        ((ProxySurface)this.surface).destroyNotify();
                    }
                }
            }
        } else if (DEBUG) {
            System.err.println(GLDrawableImpl.getThreadName() + ": setRealized: " + this.getClass().getName() + " " + this.realized + " == " + bl);
        }
    }

    protected abstract void setRealizedImpl();

    protected void contextRealized(GLContext gLContext, boolean bl) {
    }

    protected void contextMadeCurrent(GLContext gLContext, boolean bl) {
    }

    protected int getDefaultDrawFramebuffer() {
        return 0;
    }

    protected int getDefaultReadFramebuffer() {
        return 0;
    }

    @Override
    public final synchronized boolean isRealized() {
        return this.realized;
    }

    @Override
    public int getWidth() {
        return this.surface.getWidth();
    }

    @Override
    public int getHeight() {
        return this.surface.getHeight();
    }

    public final int lockSurface() throws GLException {
        return this.surface.lockSurface();
    }

    public final void unlockSurface() {
        this.surface.unlockSurface();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[Realized " + this.isRealized() + ",\n\tFactory   " + this.getFactory() + ",\n\thandle    " + GLDrawableImpl.toHexString(this.getHandle()) + ",\n\tWindow    " + this.getNativeSurface() + "]";
    }

    protected static String getThreadName() {
        return Thread.currentThread().getName();
    }
}

