/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import java.util.List;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;

public class GLGraphicsConfigurationUtil {
    public static final String NV_coverage_sample = "NV_coverage_sample";
    public static final int WINDOW_BIT = 1;
    public static final int BITMAP_BIT = 2;
    public static final int PBUFFER_BIT = 4;
    public static final int FBO_BIT = 8;
    public static final int ALL_BITS = 15;

    public static final StringBuilder winAttributeBits2String(StringBuilder stringBuilder, int n) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        boolean bl = false;
        if (0 != (1 & n)) {
            stringBuilder.append("WINDOW");
            bl = true;
        }
        if (0 != (2 & n)) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("BITMAP");
            bl = true;
        }
        if (0 != (4 & n)) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("PBUFFER");
            bl = true;
        }
        if (0 != (8 & n)) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("FBO");
        }
        return stringBuilder;
    }

    public static final int getWinAttributeBits(boolean bl, boolean bl2, boolean bl3) {
        int n = 0;
        if (bl) {
            n |= 1;
        } else {
            if (bl3) {
                n |= 8;
            }
            n = !bl2 ? (n |= 2) : (n |= 4);
        }
        return n;
    }

    public static final int getWinAttributeBits(GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        return GLGraphicsConfigurationUtil.getWinAttributeBits(gLCapabilitiesImmutable.isOnscreen(), gLCapabilitiesImmutable.isPBuffer(), false);
    }

    public static final boolean addGLCapabilitiesPermutations(List<GLCapabilitiesImmutable> list, GLCapabilitiesImmutable gLCapabilitiesImmutable, int n) {
        GLCapabilities gLCapabilities;
        int n2 = list.size();
        if (0 != (1 & n)) {
            gLCapabilities = (GLCapabilities)gLCapabilitiesImmutable.cloneMutable();
            gLCapabilities.setOnscreen(true);
            gLCapabilities.setPBuffer(false);
            gLCapabilities.setFBO(false);
            list.add(gLCapabilities);
        }
        if (0 != (4 & n) || 0 != (8 & n)) {
            gLCapabilities = (GLCapabilities)gLCapabilitiesImmutable.cloneMutable();
            gLCapabilities.setFBO(0 != (8 & n));
            gLCapabilities.setPBuffer(0 != (4 & n));
            list.add(gLCapabilities);
        }
        if (0 != (2 & n)) {
            gLCapabilities = (GLCapabilities)gLCapabilitiesImmutable.cloneMutable();
            gLCapabilities.setOnscreen(false);
            gLCapabilities.setPBuffer(false);
            gLCapabilities.setFBO(false);
            list.add(gLCapabilities);
        }
        return list.size() > n2;
    }

    public static GLCapabilitiesImmutable fixGLCapabilities(GLCapabilitiesImmutable gLCapabilitiesImmutable, boolean bl, boolean bl2) {
        if (!gLCapabilitiesImmutable.isOnscreen()) {
            return GLGraphicsConfigurationUtil.fixOffscreenGLCapabilities(gLCapabilitiesImmutable, bl, bl2);
        }
        return GLGraphicsConfigurationUtil.fixOnscreenGLCapabilities(gLCapabilitiesImmutable);
    }

    public static GLCapabilitiesImmutable fixOnscreenGLCapabilities(GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        if (!gLCapabilitiesImmutable.isOnscreen()) {
            GLCapabilities gLCapabilities = (GLCapabilities)gLCapabilitiesImmutable.cloneMutable();
            gLCapabilities.setOnscreen(true);
            return gLCapabilities;
        }
        return gLCapabilitiesImmutable;
    }

    public static GLCapabilitiesImmutable fixOffscreenGLCapabilities(GLCapabilitiesImmutable gLCapabilitiesImmutable, boolean bl, boolean bl2) {
        if (gLCapabilitiesImmutable.getDoubleBuffered() || gLCapabilitiesImmutable.isOnscreen() || bl != gLCapabilitiesImmutable.isFBO() || bl2 != gLCapabilitiesImmutable.isPBuffer()) {
            GLCapabilities gLCapabilities = (GLCapabilities)gLCapabilitiesImmutable.cloneMutable();
            gLCapabilities.setDoubleBuffered(false);
            gLCapabilities.setOnscreen(false);
            gLCapabilities.setFBO(bl);
            gLCapabilities.setPBuffer(bl2);
            return gLCapabilities;
        }
        return gLCapabilitiesImmutable;
    }

    public static GLCapabilitiesImmutable fixGLPBufferGLCapabilities(GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        if (gLCapabilitiesImmutable.getDoubleBuffered() || gLCapabilitiesImmutable.isOnscreen() || !gLCapabilitiesImmutable.isPBuffer() || gLCapabilitiesImmutable.isFBO()) {
            GLCapabilities gLCapabilities = (GLCapabilities)gLCapabilitiesImmutable.cloneMutable();
            gLCapabilities.setDoubleBuffered(false);
            gLCapabilities.setOnscreen(false);
            gLCapabilities.setPBuffer(true);
            gLCapabilities.setFBO(false);
            return gLCapabilities;
        }
        return gLCapabilitiesImmutable;
    }

    public static GLCapabilitiesImmutable fixOpaqueGLCapabilities(GLCapabilitiesImmutable gLCapabilitiesImmutable, boolean bl) {
        GLCapabilities gLCapabilities = null;
        if (gLCapabilitiesImmutable.isBackgroundOpaque() != bl) {
            int n = gLCapabilitiesImmutable.getAlphaBits();
            gLCapabilities = (GLCapabilities)gLCapabilitiesImmutable.cloneMutable();
            gLCapabilities.setBackgroundOpaque(bl);
            gLCapabilities.setAlphaBits(n);
            return gLCapabilities;
        }
        return gLCapabilitiesImmutable;
    }
}

