/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.common.util.locks.LockFactory;
import com.jogamp.common.util.locks.RecursiveLock;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLPbuffer;
import jogamp.opengl.GLAutoDrawableBase;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableImpl;

public class GLPbufferImpl
extends GLAutoDrawableBase
implements GLPbuffer {
    private int floatMode;
    private final RecursiveLock lock = LockFactory.createRecursiveLock();
    protected final Runnable initAction = new Runnable(){

        @Override
        public final void run() {
            GLPbufferImpl.this.floatMode = GLPbufferImpl.this.context.getFloatingPointMode();
            GLPbufferImpl.this.defaultInitAction.run();
        }
    };

    public GLPbufferImpl(GLDrawableImpl gLDrawableImpl, GLContext gLContext, boolean bl) {
        super(gLDrawableImpl, null, bl);
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)this.drawable.getNativeSurface().getGraphicsConfiguration().getChosenCapabilities();
        if (gLCapabilitiesImmutable.isOnscreen()) {
            if (gLCapabilitiesImmutable.isPBuffer()) {
                throw new IllegalArgumentException("Error: Given drawable is Onscreen and Pbuffer: " + gLDrawableImpl);
            }
            throw new IllegalArgumentException("Error: Given drawable is Onscreen: " + gLDrawableImpl);
        }
        if (!gLCapabilitiesImmutable.isPBuffer()) {
            throw new IllegalArgumentException("Error: Given drawable is not Pbuffer: " + gLDrawableImpl);
        }
        this.context = (GLContextImpl)this.drawable.createContext(gLContext);
    }

    @Override
    public void bindTexture() {
        this.context.bindPbufferToTexture();
    }

    @Override
    public void releaseTexture() {
        this.context.releasePbufferFromTexture();
    }

    @Override
    public int getFloatingPointMode() {
        if (this.floatMode == 0) {
            throw new GLException("Pbuffer not initialized, or floating-point support not requested");
        }
        return this.floatMode;
    }

    @Override
    public final void setRealized(boolean bl) {
    }

    @Override
    protected final RecursiveLock getLock() {
        return this.lock;
    }

    @Override
    public final Object getUpstreamWidget() {
        return null;
    }

    @Override
    public void destroy() {
        this.defaultDestroy();
    }

    @Override
    public GLDrawableFactory getFactory() {
        return this.drawable.getFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void display() {
        RecursiveLock recursiveLock = this.lock;
        recursiveLock.lock();
        try {
            if (null != this.context) {
                this.helper.invokeGL(this.drawable, this.context, this.defaultDisplayAction, this.initAction);
            }
        }
        finally {
            recursiveLock.unlock();
        }
    }

    @Override
    public final void swapBuffers() throws GLException {
        this.defaultSwapBuffers();
    }
}

