/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.av;

import com.jogamp.opengl.util.av.GLMediaPlayer;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureIO;
import com.jogamp.opengl.util.texture.TextureSequence;
import java.io.IOException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.media.opengl.GL;
import javax.media.opengl.GLException;

public abstract class GLMediaPlayerImpl
implements GLMediaPlayer {
    protected static final String unknown = "unknown";
    protected GLMediaPlayer.State state;
    protected int textureCount = 3;
    protected int textureTarget = 3553;
    protected int textureFormat = 6408;
    protected int textureType = 5121;
    protected int texUnit = 0;
    protected int[] texMinMagFilter = new int[]{9728, 9728};
    protected int[] texWrapST = new int[]{33071, 33071};
    protected URLConnection urlConn = null;
    protected float playSpeed = 1.0f;
    protected int width = 0;
    protected int height = 0;
    protected float fps = 0.0f;
    protected int bps_stream = 0;
    protected int bps_video = 0;
    protected int bps_audio = 0;
    protected int totalFrames = 0;
    protected int duration = 0;
    protected String acodec = "unknown";
    protected String vcodec = "unknown";
    protected int frameNumber = 0;
    protected TextureSequence.TextureFrame[] texFrames = null;
    protected HashMap<Integer, TextureSequence.TextureFrame> texFrameMap = new HashMap();
    private ArrayList<GLMediaPlayer.GLMediaEventListener> eventListeners = new ArrayList();
    private Object eventListenersLock = new Object();

    protected GLMediaPlayerImpl() {
        this.state = GLMediaPlayer.State.Uninitialized;
    }

    @Override
    public void setTextureUnit(int n) {
        this.texUnit = n;
    }

    @Override
    public int getTextureUnit() {
        return this.texUnit;
    }

    protected final void setTextureCount(int n) {
        this.textureCount = n;
    }

    @Override
    public final int getTextureCount() {
        return this.textureCount;
    }

    protected final void setTextureTarget(int n) {
        this.textureTarget = n;
    }

    protected final void setTextureFormat(int n) {
        this.textureFormat = n;
    }

    protected final void setTextureType(int n) {
        this.textureType = n;
    }

    @Override
    public final void setTextureMinMagFilter(int[] nArray) {
        this.texMinMagFilter[0] = nArray[0];
        this.texMinMagFilter[1] = nArray[1];
    }

    @Override
    public final int[] getTextureMinMagFilter() {
        return this.texMinMagFilter;
    }

    @Override
    public final void setTextureWrapST(int[] nArray) {
        this.texWrapST[0] = nArray[0];
        this.texWrapST[1] = nArray[1];
    }

    @Override
    public final int[] getTextureWrapST() {
        return this.texWrapST;
    }

    @Override
    public final TextureSequence.TextureFrame getLastTexture() throws IllegalStateException {
        if (GLMediaPlayer.State.Uninitialized == this.state) {
            throw new IllegalStateException("Instance not initialized: " + this);
        }
        return this.getLastTextureImpl();
    }

    protected abstract TextureSequence.TextureFrame getLastTextureImpl();

    @Override
    public final synchronized TextureSequence.TextureFrame getNextTexture(GL gL, boolean bl) throws IllegalStateException {
        if (GLMediaPlayer.State.Uninitialized == this.state) {
            throw new IllegalStateException("Instance not initialized: " + this);
        }
        if (GLMediaPlayer.State.Playing == this.state) {
            TextureSequence.TextureFrame textureFrame = this.getNextTextureImpl(gL, bl);
            return textureFrame;
        }
        return this.getLastTextureImpl();
    }

    protected abstract TextureSequence.TextureFrame getNextTextureImpl(GL var1, boolean var2);

    @Override
    public String getRequiredExtensionsShaderStub() throws IllegalStateException {
        if (GLMediaPlayer.State.Uninitialized == this.state) {
            throw new IllegalStateException("Instance not initialized: " + this);
        }
        if (36197 == this.textureTarget) {
            return "#extension GL_OES_EGL_image_external : enable\n";
        }
        return "";
    }

    @Override
    public String getTextureSampler2DType() throws IllegalStateException {
        if (GLMediaPlayer.State.Uninitialized == this.state) {
            throw new IllegalStateException("Instance not initialized: " + this);
        }
        switch (this.textureTarget) {
            case 3553: 
            case 34037: {
                return "sampler2D";
            }
            case 36197: {
                return "samplerExternalOES";
            }
        }
        throw new GLException("Unsuported texture target: " + GLMediaPlayerImpl.toHexString(this.textureTarget));
    }

    @Override
    public String getTextureLookupFunctionName(String string) throws IllegalStateException {
        if (GLMediaPlayer.State.Uninitialized == this.state) {
            throw new IllegalStateException("Instance not initialized: " + this);
        }
        return "texture2D";
    }

    @Override
    public String getTextureLookupFragmentShaderImpl() throws IllegalStateException {
        if (GLMediaPlayer.State.Uninitialized == this.state) {
            throw new IllegalStateException("Instance not initialized: " + this);
        }
        return "";
    }

    @Override
    public final synchronized float getPlaySpeed() {
        return this.playSpeed;
    }

    @Override
    public final synchronized void setPlaySpeed(float f) {
        if (GLMediaPlayer.State.Uninitialized != this.state && this.setPlaySpeedImpl(f)) {
            this.playSpeed = f;
        }
        if (DEBUG) {
            System.err.println("SetPlaySpeed: " + this.toString());
        }
    }

    protected abstract boolean setPlaySpeedImpl(float var1);

    @Override
    public final GLMediaPlayer.State start() {
        switch (this.state) {
            case Stopped: 
            case Paused: {
                if (!this.startImpl()) break;
                this.state = GLMediaPlayer.State.Playing;
            }
        }
        if (DEBUG) {
            System.err.println("Start: " + this.toString());
        }
        return this.state;
    }

    protected abstract boolean startImpl();

    @Override
    public final GLMediaPlayer.State pause() {
        if (GLMediaPlayer.State.Playing == this.state && this.pauseImpl()) {
            this.state = GLMediaPlayer.State.Paused;
        }
        if (DEBUG) {
            System.err.println("Pause: " + this.toString());
        }
        return this.state;
    }

    protected abstract boolean pauseImpl();

    @Override
    public final GLMediaPlayer.State stop() {
        switch (this.state) {
            case Paused: 
            case Playing: {
                if (!this.stopImpl()) break;
                this.state = GLMediaPlayer.State.Stopped;
            }
        }
        if (DEBUG) {
            System.err.println("Stop: " + this.toString());
        }
        return this.state;
    }

    protected abstract boolean stopImpl();

    @Override
    public final int getCurrentPosition() {
        if (GLMediaPlayer.State.Uninitialized != this.state) {
            return this.getCurrentPositionImpl();
        }
        return 0;
    }

    protected abstract int getCurrentPositionImpl();

    @Override
    public final int seek(int n) {
        int n2;
        switch (this.state) {
            case Stopped: 
            case Paused: 
            case Playing: {
                n2 = this.seekImpl(n);
                break;
            }
            default: {
                n2 = 0;
            }
        }
        if (DEBUG) {
            System.err.println("Seek(" + n + "): " + this.toString());
        }
        return n2;
    }

    protected abstract int seekImpl(int var1);

    @Override
    public final GLMediaPlayer.State getState() {
        return this.state;
    }

    @Override
    public final GLMediaPlayer.State initGLStream(GL gL, URLConnection uRLConnection) throws IllegalStateException, GLException, IOException {
        if (GLMediaPlayer.State.Uninitialized != this.state) {
            throw new IllegalStateException("Instance not in state " + (Object)((Object)GLMediaPlayer.State.Uninitialized) + ", but " + (Object)((Object)this.state) + ", " + this);
        }
        this.urlConn = uRLConnection;
        if (this.urlConn != null) {
            try {
                if (null != gL) {
                    if (null != this.texFrames) {
                        this.removeAllImageTextures(gL);
                    } else {
                        this.texFrames = new TextureSequence.TextureFrame[this.textureCount];
                    }
                    int[] nArray = new int[this.textureCount];
                    gL.glGenTextures(this.textureCount, nArray, 0);
                    int n = gL.glGetError();
                    if (0 != n) {
                        throw new RuntimeException("TextureNames creation failed (num: " + this.textureCount + "): err " + GLMediaPlayerImpl.toHexString(n));
                    }
                    this.initGLStreamImpl(gL, nArray);
                    for (n = 0; n < this.textureCount; ++n) {
                        TextureSequence.TextureFrame textureFrame;
                        this.texFrames[n] = textureFrame = this.createTexImage(gL, n, nArray);
                        this.texFrameMap.put(nArray[n], textureFrame);
                    }
                }
                this.state = GLMediaPlayer.State.Stopped;
                return this.state;
            }
            catch (Throwable throwable) {
                throw new GLException("Error initializing GL resources", throwable);
            }
        }
        return this.state;
    }

    protected abstract void initGLStreamImpl(GL var1, int[] var2) throws IOException;

    protected TextureSequence.TextureFrame createTexImage(GL gL, int n, int[] nArray) {
        return new TextureSequence.TextureFrame(this.createTexImageImpl(gL, n, nArray, this.width, this.height, false));
    }

    protected Texture createTexImageImpl(GL gL, int n, int[] nArray, int n2, int n3, boolean bl) {
        if (0 > nArray[n]) {
            throw new RuntimeException("TextureName " + GLMediaPlayerImpl.toHexString(nArray[n]) + " invalid.");
        }
        gL.glActiveTexture(33984 + this.getTextureUnit());
        gL.glBindTexture(this.textureTarget, nArray[n]);
        int n4 = gL.glGetError();
        if (0 != n4) {
            throw new RuntimeException("Couldn't bind textureName " + GLMediaPlayerImpl.toHexString(nArray[n]) + " to 2D target, err " + GLMediaPlayerImpl.toHexString(n4));
        }
        if (36197 != this.textureTarget) {
            gL.glTexImage2D(this.textureTarget, 0, 6408, n2, n3, 0, this.textureFormat, this.textureType, null);
            n4 = gL.glGetError();
            if (0 != n4) {
                throw new RuntimeException("Couldn't create TexImage2D RGBA " + n2 + "x" + n3 + ", err " + GLMediaPlayerImpl.toHexString(n4));
            }
            if (DEBUG) {
                System.err.println("Created TexImage2D RGBA " + n2 + "x" + n3 + ", target " + GLMediaPlayerImpl.toHexString(this.textureTarget) + ", ifmt " + GLMediaPlayerImpl.toHexString(6408) + ", fmt " + GLMediaPlayerImpl.toHexString(this.textureFormat) + ", type " + GLMediaPlayerImpl.toHexString(this.textureType));
            }
        }
        gL.glTexParameteri(this.textureTarget, 10241, this.texMinMagFilter[0]);
        gL.glTexParameteri(this.textureTarget, 10240, this.texMinMagFilter[1]);
        gL.glTexParameteri(this.textureTarget, 10242, this.texWrapST[0]);
        gL.glTexParameteri(this.textureTarget, 10243, this.texWrapST[1]);
        return TextureIO.newTexture(nArray[n], this.textureTarget, n2, n3, this.width, this.height, bl);
    }

    protected void destroyTexImage(GL gL, TextureSequence.TextureFrame textureFrame) {
        textureFrame.getTexture().destroy(gL);
    }

    protected void removeAllImageTextures(GL gL) {
        if (null != this.texFrames) {
            for (int i = 0; i < this.textureCount; ++i) {
                TextureSequence.TextureFrame textureFrame = this.texFrames[i];
                if (null == textureFrame) continue;
                this.destroyTexImage(gL, textureFrame);
                this.texFrames[i] = null;
            }
        }
        this.texFrameMap.clear();
    }

    protected final void updateAttributes(int n, int n2, int n3, int n4, int n5, float f, int n6, int n7, String string, String string2) {
        int n8 = 0;
        if (this.width != n || this.height != n2) {
            n8 |= 1;
            this.width = n;
            this.height = n2;
        }
        if (this.fps != f) {
            n8 |= 2;
            this.fps = f;
        }
        if (this.bps_stream != n3 || this.bps_video != n4 || this.bps_audio != n5) {
            n8 |= 4;
            this.bps_stream = n3;
            this.bps_video = n4;
            this.bps_audio = n5;
        }
        if (this.totalFrames != n6 || this.duration != n7) {
            n8 |= 8;
            this.totalFrames = n6;
            this.duration = n7;
        }
        if (null != string2 && string2.length() > 0 && !this.acodec.equals(string2)) {
            n8 |= 8;
            this.acodec = string2;
        }
        if (null != string && string.length() > 0 && !this.vcodec.equals(string)) {
            n8 |= 8;
            this.vcodec = string;
        }
        if (0 == n8) {
            return;
        }
        this.attributesUpdated(n8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void attributesUpdated(int n) {
        Object object = this.eventListenersLock;
        synchronized (object) {
            Iterator<GLMediaPlayer.GLMediaEventListener> iterator = this.eventListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().attributesChanges(this, n, System.currentTimeMillis());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void newFrameAvailable() {
        ++this.frameNumber;
        Object object = this.eventListenersLock;
        synchronized (object) {
            Iterator<GLMediaPlayer.GLMediaEventListener> iterator = this.eventListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().newFrameAvailable(this, System.currentTimeMillis());
            }
        }
    }

    @Override
    public final synchronized GLMediaPlayer.State destroy(GL gL) {
        this.destroyImpl(gL);
        this.removeAllImageTextures(gL);
        this.state = GLMediaPlayer.State.Uninitialized;
        return this.state;
    }

    protected abstract void destroyImpl(GL var1);

    @Override
    public final synchronized URLConnection getURLConnection() {
        return this.urlConn;
    }

    @Override
    public final synchronized String getVideoCodec() {
        return this.vcodec;
    }

    @Override
    public final synchronized String getAudioCodec() {
        return this.acodec;
    }

    @Override
    public final synchronized long getTotalFrames() {
        return this.totalFrames;
    }

    @Override
    public final synchronized int getDuration() {
        return this.duration;
    }

    @Override
    public final synchronized long getStreamBitrate() {
        return this.bps_stream;
    }

    @Override
    public final synchronized int getVideoBitrate() {
        return this.bps_video;
    }

    @Override
    public final synchronized int getAudioBitrate() {
        return this.bps_audio;
    }

    @Override
    public final synchronized float getFramerate() {
        return this.fps;
    }

    @Override
    public final synchronized int getWidth() {
        return this.width;
    }

    @Override
    public final synchronized int getHeight() {
        return this.height;
    }

    @Override
    public final synchronized String toString() {
        float f = (float)this.getCurrentPosition() / 1000.0f;
        float f2 = (float)this.getDuration() / 1000.0f;
        String string = null != this.urlConn ? this.urlConn.getURL().toExternalForm() : "<undefined stream>";
        return "GLMediaPlayer[" + (Object)((Object)this.state) + ", " + this.frameNumber + "/" + this.totalFrames + " frames, " + f + "/" + f2 + "s, speed " + this.playSpeed + ", " + this.bps_stream + " bps, " + "Texture[count " + this.textureCount + ", target " + GLMediaPlayerImpl.toHexString(this.textureTarget) + ", format " + GLMediaPlayerImpl.toHexString(this.textureFormat) + ", type " + GLMediaPlayerImpl.toHexString(this.textureType) + "], " + "Stream[Video[<" + this.vcodec + ">, " + this.width + "x" + this.height + ", " + this.fps + " fps, " + this.bps_video + " bsp], " + "Audio[<" + this.acodec + ">, " + this.bps_audio + " bsp]], " + string + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addEventListener(GLMediaPlayer.GLMediaEventListener gLMediaEventListener) {
        if (gLMediaEventListener == null) {
            return;
        }
        Object object = this.eventListenersLock;
        synchronized (object) {
            this.eventListeners.add(gLMediaEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeEventListener(GLMediaPlayer.GLMediaEventListener gLMediaEventListener) {
        if (gLMediaEventListener == null) {
            return;
        }
        Object object = this.eventListenersLock;
        synchronized (object) {
            this.eventListeners.remove(gLMediaEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized GLMediaPlayer.GLMediaEventListener[] getEventListeners() {
        Object object = this.eventListenersLock;
        synchronized (object) {
            return this.eventListeners.toArray(new GLMediaPlayer.GLMediaEventListener[this.eventListeners.size()]);
        }
    }

    protected static final String toHexString(long l) {
        return "0x" + Long.toHexString(l);
    }

    protected static final String toHexString(int n) {
        return "0x" + Integer.toHexString(n);
    }
}

