/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.x11.glx;

import com.jogamp.common.util.VersionNumber;
import com.jogamp.nativewindow.x11.X11GraphicsDevice;
import javax.media.opengl.GLException;
import jogamp.opengl.Debug;
import jogamp.opengl.x11.glx.GLX;

public class GLXUtil {
    public static final boolean DEBUG = Debug.debug("GLXUtil");
    private static boolean clientMultisampleAvailable = false;
    private static String clientVendorName = null;
    private static VersionNumber clientVersionNumber = null;

    public static synchronized boolean isGLXAvailableOnServer(X11GraphicsDevice x11GraphicsDevice) {
        if (null == x11GraphicsDevice) {
            throw new IllegalArgumentException("null X11GraphicsDevice");
        }
        if (0L == x11GraphicsDevice.getHandle()) {
            throw new IllegalArgumentException("null X11GraphicsDevice display handle");
        }
        boolean bl = false;
        try {
            bl = GLX.glXQueryExtension(x11GraphicsDevice.getHandle(), null, 0, null, 0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    public static VersionNumber getGLXServerVersionNumber(long l) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (!GLX.glXQueryVersion(l, nArray, 0, nArray2, 0)) {
            throw new GLException("glXQueryVersion failed");
        }
        if (nArray[0] == 1 && nArray2[0] == 2) {
            String string = GLX.glXGetClientString(l, 2);
            try {
                nArray[0] = Integer.valueOf(string.substring(0, 1));
                nArray2[0] = Integer.valueOf(string.substring(2, 3));
            }
            catch (Exception exception) {
                nArray[0] = 1;
                nArray2[0] = 2;
            }
        }
        return new VersionNumber(nArray[0], nArray2[0], 0);
    }

    public static boolean isMultisampleAvailable(String string) {
        if (string != null) {
            return string.indexOf("GLX_ARB_multisample") >= 0;
        }
        return false;
    }

    public static boolean isVendorNVIDIA(String string) {
        return string != null && string.startsWith("NVIDIA");
    }

    public static boolean isVendorATI(String string) {
        return string != null && string.startsWith("ATI");
    }

    public static boolean isClientMultisampleAvailable() {
        return clientMultisampleAvailable;
    }

    public static String getClientVendorName() {
        return clientVendorName;
    }

    public static VersionNumber getClientVersionNumber() {
        return clientVersionNumber;
    }

    public static synchronized void initGLXClientDataSingleton(X11GraphicsDevice x11GraphicsDevice) {
        if (null != clientVendorName) {
            return;
        }
        if (null == x11GraphicsDevice) {
            throw new IllegalArgumentException("null X11GraphicsDevice");
        }
        if (0L == x11GraphicsDevice.getHandle()) {
            throw new IllegalArgumentException("null X11GraphicsDevice display handle");
        }
        clientMultisampleAvailable = GLXUtil.isMultisampleAvailable(GLX.glXGetClientString(x11GraphicsDevice.getHandle(), 3));
        clientVendorName = GLX.glXGetClientString(x11GraphicsDevice.getHandle(), 1);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        String string = GLX.glXGetClientString(x11GraphicsDevice.getHandle(), 2);
        try {
            nArray[0] = Integer.valueOf(string.substring(0, 1));
            nArray2[0] = Integer.valueOf(string.substring(2, 3));
        }
        catch (Exception exception) {
            nArray[0] = 1;
            nArray2[0] = 2;
        }
        clientVersionNumber = new VersionNumber(nArray[0], nArray2[0], 0);
    }
}

