/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.x11.glx;

import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.MutableSurface;
import javax.media.nativewindow.NativeSurface;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import jogamp.opengl.x11.glx.GLX;
import jogamp.opengl.x11.glx.X11GLXDrawable;
import jogamp.opengl.x11.glx.X11GLXGraphicsConfiguration;
import jogamp.opengl.x11.glx.X11PbufferGLXContext;

public class X11PbufferGLXDrawable
extends X11GLXDrawable {
    protected X11PbufferGLXDrawable(GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface) {
        super(gLDrawableFactory, nativeSurface, false);
    }

    @Override
    protected void setRealizedImpl() {
        if (this.realized) {
            this.createPbuffer();
        } else {
            this.destroyPbuffer();
        }
    }

    @Override
    public GLContext createContext(GLContext gLContext) {
        return new X11PbufferGLXContext(this, gLContext);
    }

    protected void destroyPbuffer() {
        NativeSurface nativeSurface = this.getNativeSurface();
        if (nativeSurface.getSurfaceHandle() != 0L) {
            GLX.glXDestroyPbuffer(nativeSurface.getDisplayHandle(), nativeSurface.getSurfaceHandle());
        }
        ((MutableSurface)nativeSurface).setSurfaceHandle(0L);
    }

    private void createPbuffer() {
        X11GLXGraphicsConfiguration x11GLXGraphicsConfiguration = (X11GLXGraphicsConfiguration)this.getNativeSurface().getGraphicsConfiguration();
        AbstractGraphicsScreen abstractGraphicsScreen = x11GLXGraphicsConfiguration.getScreen();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsScreen.getDevice();
        long l = abstractGraphicsDevice.getHandle();
        if (DEBUG) {
            System.out.println("Pbuffer config: " + x11GLXGraphicsConfiguration);
        }
        if (l == 0L) {
            throw new GLException("Null display");
        }
        NativeSurface nativeSurface = this.getNativeSurface();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)x11GLXGraphicsConfiguration.getChosenCapabilities();
        if (gLCapabilitiesImmutable.getPbufferRenderToTexture()) {
            throw new GLException("Render-to-texture pbuffers not supported yet on X11");
        }
        if (gLCapabilitiesImmutable.getPbufferRenderToTextureRectangle()) {
            throw new GLException("Render-to-texture-rectangle pbuffers not supported yet on X11");
        }
        int n = 0;
        int[] nArray = new int[7];
        nArray[n++] = 32833;
        nArray[n++] = nativeSurface.getWidth();
        nArray[n++] = 32832;
        nArray[n++] = nativeSurface.getHeight();
        nArray[n++] = 32796;
        nArray[n++] = 0;
        nArray[n++] = 0;
        long l2 = GLX.glXCreatePbuffer(l, x11GLXGraphicsConfiguration.getFBConfig(), nArray, 0);
        if (l2 == 0L) {
            throw new GLException("pbuffer creation error: glXCreatePbuffer() failed");
        }
        ((MutableSurface)nativeSurface).setSurfaceHandle(l2);
        if (DEBUG) {
            System.err.println("Created pbuffer " + this);
        }
    }

    public int getFloatingPointMode() {
        return 3;
    }
}

