/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.AbstractFeatureLocking;
import org.geotools.data.AbstractFeatureSource;
import org.geotools.data.AbstractFeatureStore;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.data.DelegatingFeatureReader;
import org.geotools.data.Diff;
import org.geotools.data.DiffFeatureReader;
import org.geotools.data.EmptyFeatureReader;
import org.geotools.data.EmptyFeatureWriter;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureListenerManager;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.FilteringFeatureWriter;
import org.geotools.data.InProcessLockingManager;
import org.geotools.data.LockingManager;
import org.geotools.data.MaxFeatureReader;
import org.geotools.data.Query;
import org.geotools.data.ReTypeFeatureReader;
import org.geotools.data.ServiceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.TransactionStateDiff;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.NameImpl;
import org.geotools.feature.SchemaException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;

public abstract class AbstractDataStore
implements DataStore {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data");
    public FeatureListenerManager listenerManager = new FeatureListenerManager();
    protected final boolean isWriteable;
    private InProcessLockingManager lockingManager;

    public AbstractDataStore() {
        this(true);
    }

    public AbstractDataStore(boolean isWriteable) {
        this.isWriteable = isWriteable;
        this.lockingManager = this.createLockingManager();
    }

    protected InProcessLockingManager createLockingManager() {
        return new InProcessLockingManager();
    }

    protected Map createMetadata(String typeName) {
        return Collections.EMPTY_MAP;
    }

    @Override
    public abstract String[] getTypeNames() throws IOException;

    @Override
    public ServiceInfo getInfo() {
        DefaultServiceInfo info = new DefaultServiceInfo();
        info.setDescription("Features from " + this.getClass().getSimpleName());
        info.setSchema(FeatureTypes.DEFAULT_NAMESPACE);
        return info;
    }

    @Override
    public abstract SimpleFeatureType getSchema(String var1) throws IOException;

    protected abstract FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(String var1) throws IOException;

    protected FeatureWriter<SimpleFeatureType, SimpleFeature> createFeatureWriter(String typeName, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException("FeatureWriter not supported");
    }

    @Override
    public void createSchema(SimpleFeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("Schema creation not supported");
    }

    @Override
    public void updateSchema(String typeName, SimpleFeatureType featureType) {
        throw new UnsupportedOperationException("Schema modification not supported");
    }

    @Override
    public SimpleFeatureSource getFeatureSource(final String typeName) throws IOException {
        final SimpleFeatureType featureType = this.getSchema(typeName);
        if (this.isWriteable) {
            if (this.lockingManager != null) {
                return new AbstractFeatureLocking(this.getSupportedHints()){

                    @Override
                    public DataStore getDataStore() {
                        return AbstractDataStore.this;
                    }

                    public String toString() {
                        return "AbstractDataStore.AbstractFeatureLocking(" + typeName + ")";
                    }

                    @Override
                    public void addFeatureListener(FeatureListener listener) {
                        AbstractDataStore.this.listenerManager.addFeatureListener(this, listener);
                    }

                    @Override
                    public void removeFeatureListener(FeatureListener listener) {
                        AbstractDataStore.this.listenerManager.removeFeatureListener(this, listener);
                    }

                    @Override
                    public SimpleFeatureType getSchema() {
                        return featureType;
                    }
                };
            }
            return new AbstractFeatureStore(this.getSupportedHints()){

                @Override
                public DataStore getDataStore() {
                    return AbstractDataStore.this;
                }

                public String toString() {
                    return "AbstractDataStore.AbstractFeatureStore(" + typeName + ")";
                }

                @Override
                public void addFeatureListener(FeatureListener listener) {
                    AbstractDataStore.this.listenerManager.addFeatureListener(this, listener);
                }

                @Override
                public void removeFeatureListener(FeatureListener listener) {
                    AbstractDataStore.this.listenerManager.removeFeatureListener(this, listener);
                }

                @Override
                public SimpleFeatureType getSchema() {
                    return featureType;
                }
            };
        }
        return new AbstractFeatureSource(this.getSupportedHints()){

            @Override
            public DataStore getDataStore() {
                return AbstractDataStore.this;
            }

            public String toString() {
                return "AbstractDataStore.AbstractFeatureSource(" + typeName + ")";
            }

            @Override
            public void addFeatureListener(FeatureListener listener) {
                AbstractDataStore.this.listenerManager.addFeatureListener(this, listener);
            }

            @Override
            public void removeFeatureListener(FeatureListener listener) {
                AbstractDataStore.this.listenerManager.removeFeatureListener(this, listener);
            }

            @Override
            public SimpleFeatureType getSchema() {
                return featureType;
            }
        };
    }

    @Override
    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query, Transaction transaction) throws IOException {
        TransactionStateDiff state;
        Filter filter = query.getFilter();
        String typeName = query.getTypeName();
        String[] propertyNames = query.getPropertyNames();
        if (filter == null) {
            throw new NullPointerException("getFeatureReader requires Filter: did you mean Filter.INCLUDE?");
        }
        if (typeName == null) {
            throw new NullPointerException("getFeatureReader requires typeName: use getTypeNames() for a list of available types");
        }
        if (transaction == null) {
            throw new NullPointerException("getFeatureReader requires Transaction: did you mean to use Transaction.AUTO_COMMIT?");
        }
        SimpleFeatureType featureType = this.getSchema(query.getTypeName());
        if (propertyNames != null || query.getCoordinateSystem() != null) {
            try {
                featureType = DataUtilities.createSubType(featureType, propertyNames, query.getCoordinateSystem());
            }
            catch (SchemaException e) {
                LOGGER.log(Level.FINEST, e.getMessage(), e);
                throw new DataSourceException("Could not create Feature Type for query", e);
            }
        }
        if (filter == Filter.EXCLUDE || filter.equals(Filter.EXCLUDE)) {
            return new EmptyFeatureReader<SimpleFeatureType, SimpleFeature>(featureType);
        }
        if ((filter = this.getUnsupportedFilter(typeName, filter)) == null) {
            throw new NullPointerException("getUnsupportedFilter shouldn't return null. Do you mean Filter.INCLUDE?");
        }
        Diff diff = null;
        if (transaction != Transaction.AUTO_COMMIT && (state = this.state(transaction)) != null) {
            diff = state.diff(typeName);
        }
        DelegatingFeatureReader<SimpleFeatureType, SimpleFeature> reader = this.getFeatureReader(typeName, query);
        if (diff != null) {
            reader = new DiffFeatureReader<SimpleFeatureType, SimpleFeature>(reader, diff, query.getFilter());
        }
        if (!filter.equals(Filter.INCLUDE)) {
            reader = new FilteringFeatureReader<SimpleFeatureType, SimpleFeature>(reader, filter);
        }
        if (!featureType.equals(reader.getFeatureType())) {
            LOGGER.fine("Recasting feature type to subtype by using a ReTypeFeatureReader");
            reader = new ReTypeFeatureReader(reader, featureType, false);
        }
        if (query.getMaxFeatures() != Integer.MAX_VALUE) {
            reader = new MaxFeatureReader<SimpleFeatureType, SimpleFeature>(reader, query.getMaxFeatures());
        }
        return reader;
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(String typeName, Query query) throws IOException {
        return this.getFeatureReader(typeName);
    }

    protected Filter getUnsupportedFilter(String typeName, Filter filter) {
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TransactionStateDiff state(Transaction transaction) {
        Transaction transaction2 = transaction;
        synchronized (transaction2) {
            TransactionStateDiff state = (TransactionStateDiff)transaction.getState(this);
            if (state == null) {
                state = new TransactionStateDiff(this);
                transaction.putState(this, state);
            }
            return state;
        }
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
        FilteringFeatureWriter writer;
        if (filter == null) {
            throw new NullPointerException("getFeatureReader requires Filter: did you mean Filter.INCLUDE?");
        }
        if (filter == Filter.EXCLUDE) {
            SimpleFeatureType featureType = this.getSchema(typeName);
            return new EmptyFeatureWriter(featureType);
        }
        if (transaction == null) {
            throw new NullPointerException("getFeatureWriter requires Transaction: did you mean to use Transaction.AUTO_COMMIT?");
        }
        if (transaction == Transaction.AUTO_COMMIT) {
            writer = this.createFeatureWriter(typeName, transaction);
        } else {
            TransactionStateDiff state = this.state(transaction);
            if (state != null) {
                writer = state.writer(typeName, filter);
            } else {
                throw new UnsupportedOperationException("Subclass sould implement");
            }
        }
        if (this.lockingManager != null) {
            writer = this.lockingManager.checkedWriter(writer, transaction);
        }
        if (filter != Filter.INCLUDE) {
            writer = new FilteringFeatureWriter(writer, filter);
        }
        return writer;
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Transaction transaction) throws IOException {
        return this.getFeatureWriter(typeName, (Filter)Filter.INCLUDE, transaction);
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.getFeatureWriter(typeName, transaction);
        while (writer.hasNext()) {
            writer.next();
        }
        return writer;
    }

    @Override
    public LockingManager getLockingManager() {
        return this.lockingManager;
    }

    protected ReferencedEnvelope getBounds(Query query) throws IOException {
        return null;
    }

    protected int getCount(Query query) throws IOException {
        return -1;
    }

    protected Set getSupportedHints() {
        return Collections.EMPTY_SET;
    }

    @Override
    public void dispose() {
    }

    @Override
    public SimpleFeatureSource getFeatureSource(Name typeName) throws IOException {
        return this.getFeatureSource(typeName.getLocalPart());
    }

    @Override
    public List<Name> getNames() throws IOException {
        String[] typeNames = this.getTypeNames();
        ArrayList<Name> names = new ArrayList<Name>(typeNames.length);
        for (String typeName : typeNames) {
            names.add(new NameImpl(typeName));
        }
        return names;
    }

    @Override
    public SimpleFeatureType getSchema(Name name) throws IOException {
        return this.getSchema(name.getLocalPart());
    }

    @Override
    public void updateSchema(Name typeName, SimpleFeatureType featureType) throws IOException {
        this.updateSchema(typeName.getLocalPart(), featureType);
    }
}

