/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.feature.FeatureTypes;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public final class ArrayDataStore
extends AbstractDataStore {
    private final SimpleFeatureType featureType;
    private final SimpleFeature[] featureArray;

    public ArrayDataStore(SimpleFeature[] featureArray) {
        this.featureType = featureArray == null || featureArray.length == 0 ? FeatureTypes.EMPTY : featureArray[0].getFeatureType();
        this.featureArray = featureArray;
    }

    @Override
    public String[] getTypeNames() {
        return new String[]{this.featureType.getTypeName()};
    }

    @Override
    public SimpleFeatureType getSchema(String typeName) throws IOException {
        if (typeName != null && typeName.equals(this.featureType.getTypeName())) {
            return this.featureType;
        }
        throw new IOException(typeName + " not available");
    }

    @Override
    protected FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(String typeName) throws IOException {
        return DataUtilities.reader(this.featureArray);
    }
}

