/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.event;

import com.jogamp.newt.event.NEWTEvent;

public abstract class InputEvent
extends NEWTEvent {
    public static final int SHIFT_MASK = 1;
    public static final int CTRL_MASK = 2;
    public static final int META_MASK = 4;
    public static final int ALT_MASK = 8;
    public static final int ALT_GRAPH_MASK = 32;
    public static final int BUTTON1_MASK = 64;
    public static final int BUTTON2_MASK = 128;
    public static final int BUTTON3_MASK = 256;
    public static final int BUTTON4_MASK = 512;
    public static final int BUTTON5_MASK = 1024;
    public static final int BUTTON6_MASK = 2048;
    public static final int CONFINED_MASK = 65536;
    public static final int INVISIBLE_MASK = 131072;
    public static final Object consumedTag = new Object();
    private final int modifiers;

    public static final int getButtonMask(int n) {
        if (0 < n && n <= 6) {
            return 1 << 5 + n;
        }
        return 0;
    }

    protected InputEvent(int n, Object object, long l, int n2) {
        super(n, object, l);
        this.modifiers = n2;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public boolean isAltDown() {
        return (this.modifiers & 8) != 0;
    }

    public boolean isAltGraphDown() {
        return (this.modifiers & 0x20) != 0;
    }

    public boolean isControlDown() {
        return (this.modifiers & 2) != 0;
    }

    public boolean isMetaDown() {
        return (this.modifiers & 4) != 0;
    }

    public boolean isShiftDown() {
        return (this.modifiers & 1) != 0;
    }

    public boolean isConfined() {
        return (this.modifiers & 0x10000) != 0;
    }

    public boolean isInvisible() {
        return (this.modifiers & 0x20000) != 0;
    }

    public final int[] getButtonsDown() {
        int n = 0;
        for (int i = 1; i <= 6; ++i) {
            if (!this.isButtonDown(i)) continue;
            ++n;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 1; i <= 6; ++i) {
            if (!this.isButtonDown(i)) continue;
            nArray[n2++] = 0 + i;
        }
        return nArray;
    }

    public final boolean isButtonDown(int n) {
        return (this.modifiers & InputEvent.getButtonMask(n)) != 0;
    }

    @Override
    public String toString() {
        return "InputEvent[modifiers: 0x" + Integer.toHexString(this.modifiers) + ", " + super.toString() + "]";
    }
}

