/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl;

import com.jogamp.opengl.JoglVersion;
import java.util.ArrayList;
import java.util.Arrays;
import javax.media.opengl.GL;
import javax.media.opengl.GL2GL3;
import javax.media.opengl.GLException;
import jogamp.opengl.Debug;

public class FBObject {
    protected static final boolean DEBUG = Debug.debug("FBObject");
    private boolean initialized = false;
    private boolean basicFBOSupport = false;
    private boolean fullFBOSupport = false;
    private boolean rgba8Avail = false;
    private boolean depth24Avail = false;
    private boolean depth32Avail = false;
    private boolean stencil01Avail = false;
    private boolean stencil04Avail = false;
    private boolean stencil08Avail = false;
    private boolean stencil16Avail = false;
    private boolean packedDepthStencilAvail = false;
    private int maxColorAttachments = -1;
    private int maxSamples = -1;
    private int maxTextureSize = 0;
    private int maxRenderbufferSize = 0;
    private int width = 0;
    private int height = 0;
    private int samples = 0;
    private int vStatus = -1;
    private int fbName = 0;
    private boolean bound = false;
    private int colorAttachmentCount = 0;
    private Colorbuffer[] colorAttachmentPoints = null;
    private RenderAttachment depth = null;
    private RenderAttachment stencil = null;
    private final FBObject samplesSink;
    private TextureAttachment samplesSinkTexture;
    private boolean samplesSinkDirty;

    public static final boolean supportsBasicFBO(GL gL) {
        return gL.getContext().hasFBO();
    }

    public static final boolean supportsFullFBO(GL gL) {
        return gL.isGL3() || gL.isExtensionAvailable("GL_ARB_framebuffer_object") || gL.isExtensionAvailable("GL_EXT_framebuffer_object") && gL.isExtensionAvailable("GL_EXT_framebuffer_multisample") && gL.isExtensionAvailable("GL_EXT_framebuffer_blit") && gL.isExtensionAvailable("GL_EXT_packed_depth_stencil");
    }

    public static final int getMaxSamples(GL gL) {
        if (FBObject.supportsFullFBO(gL)) {
            int[] nArray = new int[]{0};
            gL.glGetIntegerv(36183, nArray, 0);
            return nArray[0];
        }
        return 0;
    }

    private final void validateColorAttachmentPointRange(int n) {
        if (this.maxColorAttachments != this.colorAttachmentPoints.length) {
            throw new InternalError("maxColorAttachments " + this.maxColorAttachments + ", array.lenght " + this.colorAttachmentPoints);
        }
        if (0 > n || n >= this.maxColorAttachments) {
            throw new IllegalArgumentException("attachment point out of range: " + n + ", should be within [0.." + (this.maxColorAttachments - 1) + "]");
        }
    }

    private final void validateAddColorAttachment(int n, Colorbuffer colorbuffer) {
        this.validateColorAttachmentPointRange(n);
        if (null != this.colorAttachmentPoints[n]) {
            throw new IllegalArgumentException("Cannot attach " + colorbuffer + ", attachment point already in use by " + this.colorAttachmentPoints[n]);
        }
    }

    private final void addColorAttachment(int n, Colorbuffer colorbuffer) {
        this.validateColorAttachmentPointRange(n);
        Colorbuffer colorbuffer2 = this.colorAttachmentPoints[n];
        if (null != colorbuffer2 && colorbuffer2 != colorbuffer) {
            throw new IllegalArgumentException("Add failed: requested to add " + colorbuffer + " at " + n + ", but slot is holding " + colorbuffer2 + "; " + this);
        }
        this.colorAttachmentPoints[n] = colorbuffer;
        ++this.colorAttachmentCount;
    }

    private final void removeColorAttachment(int n, Colorbuffer colorbuffer) {
        this.validateColorAttachmentPointRange(n);
        Colorbuffer colorbuffer2 = this.colorAttachmentPoints[n];
        if (null != colorbuffer2 && colorbuffer2 != colorbuffer) {
            throw new IllegalArgumentException("Remove failed: requested to removed " + colorbuffer + " at " + n + ", but slot is holding " + colorbuffer2 + "; " + this);
        }
        this.colorAttachmentPoints[n] = null;
        --this.colorAttachmentCount;
    }

    public final Colorbuffer getColorbuffer(int n) {
        this.validateColorAttachmentPointRange(n);
        return this.colorAttachmentPoints[n];
    }

    public final int getColorbufferAttachmentPoint(Colorbuffer colorbuffer) {
        for (int i = 0; i < this.colorAttachmentPoints.length; ++i) {
            if (this.colorAttachmentPoints[i] != colorbuffer) continue;
            return i;
        }
        return -1;
    }

    public final Colorbuffer getColorbuffer(Colorbuffer colorbuffer) {
        int n = this.getColorbufferAttachmentPoint(colorbuffer);
        return n >= 0 ? this.getColorbuffer(n) : null;
    }

    public FBObject() {
        this(false);
    }

    FBObject(boolean bl) {
        this.samplesSink = bl ? null : new FBObject(true);
        this.samplesSinkTexture = null;
        this.samplesSinkDirty = true;
    }

    private void init(GL gL, int n, int n2, int n3) throws GLException {
        if (this.initialized) {
            throw new GLException("FBO already initialized");
        }
        this.fullFBOSupport = FBObject.supportsFullFBO(gL);
        if (!this.fullFBOSupport && !FBObject.supportsBasicFBO(gL)) {
            throw new GLException("FBO not supported w/ context: " + gL.getContext() + ", " + this);
        }
        this.basicFBOSupport = true;
        this.rgba8Avail = gL.isGL2GL3() || gL.isExtensionAvailable("GL_OES_rgb8_rgba8");
        this.depth24Avail = this.fullFBOSupport || gL.isExtensionAvailable("GL_OES_depth24");
        this.depth32Avail = this.fullFBOSupport || gL.isExtensionAvailable("GL_OES_depth32");
        this.stencil01Avail = this.fullFBOSupport || gL.isExtensionAvailable("GL_OES_stencil1");
        this.stencil04Avail = this.fullFBOSupport || gL.isExtensionAvailable("GL_OES_stencil4");
        this.stencil08Avail = this.fullFBOSupport || gL.isExtensionAvailable("GL_OES_stencil8");
        this.stencil16Avail = this.fullFBOSupport;
        this.packedDepthStencilAvail = this.fullFBOSupport || gL.isExtensionAvailable("GL_OES_packed_depth_stencil");
        boolean bl = gL.isExtensionAvailable("GL_NV_fbo_color_attachments");
        int[] nArray = new int[1];
        int n4 = gL.glGetError();
        if (DEBUG && 0 != n4) {
            System.err.println("FBObject.init-preexisting.0 GL Error 0x" + Integer.toHexString(n4));
        }
        int n5 = 1;
        this.maxColorAttachments = 1;
        if (null != this.samplesSink && this.fullFBOSupport || bl) {
            try {
                gL.glGetIntegerv(36063, nArray, 0);
                n4 = gL.glGetError();
                if (0 == n4) {
                    n5 = 1 <= nArray[0] ? nArray[0] : 1;
                } else if (DEBUG) {
                    System.err.println("FBObject.init-GL_MAX_COLOR_ATTACHMENTS query GL Error 0x" + Integer.toHexString(n4));
                }
            }
            catch (GLException gLException) {
                // empty catch block
            }
        }
        this.maxColorAttachments = n5 <= 8 ? n5 : 8;
        this.colorAttachmentPoints = new Colorbuffer[this.maxColorAttachments];
        this.colorAttachmentCount = 0;
        this.maxSamples = 0;
        if (this.fullFBOSupport) {
            gL.glGetIntegerv(36183, nArray, 0);
            n4 = gL.glGetError();
            if (0 == n4) {
                this.maxSamples = nArray[0];
            } else if (DEBUG) {
                System.err.println("FBObject.init-GL_MAX_SAMPLES query GL Error 0x" + Integer.toHexString(n4));
            }
        }
        gL.glGetIntegerv(3379, nArray, 0);
        this.maxTextureSize = nArray[0];
        gL.glGetIntegerv(34024, nArray, 0);
        this.maxRenderbufferSize = nArray[0];
        n4 = gL.glGetError();
        if (DEBUG && 0 != n4) {
            System.err.println("FBObject.init-preexisting.1 GL Error 0x" + Integer.toHexString(n4));
        }
        this.width = n;
        this.height = n2;
        int n6 = this.samples = n3 <= this.maxSamples ? n3 : this.maxSamples;
        if (DEBUG) {
            System.err.println("FBObject " + n + "x" + n2 + ", " + n3 + " -> " + n3 + " samples");
            System.err.println("basicFBOSupport:          " + this.basicFBOSupport);
            System.err.println("fullFBOSupport:           " + this.fullFBOSupport);
            System.err.println("maxColorAttachments:      " + this.maxColorAttachments + "/" + n5);
            System.err.println("maxSamples:               " + this.maxSamples);
            System.err.println("maxTextureSize:           " + this.maxTextureSize);
            System.err.println("maxRenderbufferSize:      " + this.maxRenderbufferSize);
            System.err.println("rgba8:                    " + this.rgba8Avail);
            System.err.println("depth24:                  " + this.depth24Avail);
            System.err.println("depth32:                  " + this.depth32Avail);
            System.err.println("stencil01:                " + this.stencil01Avail);
            System.err.println("stencil04:                " + this.stencil04Avail);
            System.err.println("stencil08:                " + this.stencil08Avail);
            System.err.println("stencil16:                " + this.stencil16Avail);
            System.err.println("packedDepthStencil:       " + this.packedDepthStencilAvail);
            System.err.println("NV_fbo_color_attachments: " + bl);
            System.err.println(gL.getContext().getGLVersion());
            System.err.println(JoglVersion.getGLStrings(gL, null).toString());
            System.err.println(gL.getContext());
        }
        this.checkNoError(null, gL.glGetError(), "FBObject Init.pre");
        if (n > 2 + this.maxTextureSize || n2 > 2 + this.maxTextureSize || n > this.maxRenderbufferSize || n2 > this.maxRenderbufferSize) {
            throw new GLException("size " + n + "x" + n2 + " exceeds on of the maxima [texture " + this.maxTextureSize + ", renderbuffer " + this.maxRenderbufferSize + "]");
        }
        if (null != this.samplesSink) {
            this.samplesSink.reset(gL, n, n2);
            this.resetMSAATexture2DSink(gL);
        }
        gL.glGenFramebuffers(1, nArray, 0);
        this.fbName = nArray[0];
        if (0 == this.fbName) {
            throw new GLException("null framebuffer");
        }
        gL.glBindFramebuffer(36160, this.fbName);
        this.checkNoError(gL, gL.glGetError(), "FBObject Init.bindFB");
        if (!gL.glIsFramebuffer(this.fbName)) {
            this.checkNoError(gL, 1281, "FBObject Init.isFB");
        }
        this.bound = true;
        this.initialized = true;
        this.updateStatus(gL);
        if (DEBUG) {
            System.err.println("FBObject.init(): " + this);
        }
    }

    public final void reset(GL gL, int n, int n2) {
        this.reset(gL, n, n2, 0);
    }

    public final void reset(GL gL, int n, int n2, int n3) {
        if (!this.initialized) {
            this.init(gL, n, n2, n3);
            return;
        }
        int n4 = n3 = n3 <= this.maxSamples ? n3 : this.maxSamples;
        if (n != this.width || n2 != this.height || n3 != this.samples) {
            if (DEBUG) {
                System.err.println("FBObject.reset - START - " + this);
            }
            boolean bl = this.isBound();
            this.width = n;
            this.height = n2;
            this.samples = n3;
            this.detachAllImpl(gL, true, true);
            this.resetMSAATexture2DSink(gL);
            if (bl) {
                this.bind(gL);
            } else {
                this.unbind(gL);
            }
            if (DEBUG) {
                System.err.println("FBObject.reset - END - " + this);
            }
        }
    }

    public final int getStatus() {
        return this.vStatus;
    }

    public final String getStatusString() {
        return FBObject.getStatusString(this.vStatus);
    }

    public static final String getStatusString(int n) {
        switch (n) {
            case -1: {
                return "NOT A FBO";
            }
            case 36053: {
                return "OK";
            }
            case 36054: {
                return "GL FBO: incomplete, incomplete attachment\n";
            }
            case 36055: {
                return "GL FBO: incomplete, missing attachment";
            }
            case 36057: {
                return "GL FBO: incomplete, attached images must have same dimensions";
            }
            case 36058: {
                return "GL FBO: incomplete, attached images must have same format";
            }
            case 36059: {
                return "GL FBO: incomplete, missing draw buffer";
            }
            case 36060: {
                return "GL FBO: incomplete, missing read buffer";
            }
            case 36182: {
                return "GL FBO: incomplete, missing multisample buffer";
            }
            case 36264: {
                return "GL FBO: incomplete, layer targets";
            }
            case 36061: {
                return "GL FBO: Unsupported framebuffer format";
            }
            case 33305: {
                return "GL FBO: framebuffer undefined";
            }
            case 0: {
                return "GL FBO: incomplete, implementation fault";
            }
        }
        return "GL FBO: incomplete, implementation ERROR 0x" + Integer.toHexString(n);
    }

    public final boolean isStatusValid() {
        switch (this.vStatus) {
            case 36053: {
                return true;
            }
            case 36054: 
            case 36055: 
            case 36057: 
            case 36058: 
            case 36059: 
            case 36060: 
            case 36182: 
            case 36264: {
                if (0 != this.colorAttachmentCount && null != this.depth) break;
                return true;
            }
        }
        System.out.println("Framebuffer " + this.fbName + " is incomplete: status = 0x" + Integer.toHexString(this.vStatus) + " : " + FBObject.getStatusString(this.vStatus));
        return false;
    }

    private final boolean checkNoError(GL gL, int n, String string) throws GLException {
        if (0 != n) {
            if (null != gL) {
                this.destroy(gL);
            }
            if (null != string) {
                throw new GLException(string + " GL Error 0x" + Integer.toHexString(n));
            }
            return false;
        }
        return true;
    }

    private final void checkInitialized() throws GLException {
        if (!this.initialized) {
            throw new GLException("FBO not initialized, call init(GL) first.");
        }
    }

    public final TextureAttachment attachTexture2D(GL gL, int n, boolean bl) throws GLException {
        return this.attachTexture2D(gL, n, bl, 9728, 9728, 33071, 33071);
    }

    public final TextureAttachment attachTexture2D(GL gL, int n, boolean bl, int n2, int n3, int n4, int n5) throws GLException {
        int n6;
        int n7;
        int n8;
        if (gL.isGLES()) {
            n8 = bl ? 6408 : 6407;
            n7 = bl ? 6408 : 6407;
            n6 = 5121;
        } else {
            n8 = bl ? 32856 : 32849;
            n7 = bl ? 32993 : 6407;
            n6 = bl ? 33639 : 5121;
        }
        return this.attachTexture2D(gL, n, n8, n7, n6, n2, n3, n4, n5);
    }

    public final TextureAttachment attachTexture2D(GL gL, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws GLException {
        return this.attachTexture2D(gL, n, new TextureAttachment(Attachment.Type.COLOR_TEXTURE, n2, this.width, this.height, n3, n4, n5, n6, n7, n8, 0));
    }

    public final TextureAttachment attachTexture2D(GL gL, int n, TextureAttachment textureAttachment) throws GLException {
        this.validateAddColorAttachment(n, textureAttachment);
        if (this.samples > 0) {
            this.removeColorAttachment(n, textureAttachment);
            throw new GLException("Texture2D not supported w/ MSAA. If you have enabled MSAA with exisiting texture attachments, you may want to detach them via detachAllTexturebuffer(gl).");
        }
        textureAttachment.initialize(gL);
        this.addColorAttachment(n, textureAttachment);
        this.bind(gL);
        gL.glFramebufferTexture2D(36160, 36064 + n, 3553, textureAttachment.getName(), 0);
        this.updateStatus(gL);
        if (!this.isStatusValid()) {
            this.detachColorbuffer(gL, n);
            throw new GLException("attachTexture2D " + textureAttachment + " at " + n + " failed " + this.getStatusString() + ", " + this);
        }
        if (DEBUG) {
            System.err.println("FBObject.attachTexture2D: " + this);
        }
        return textureAttachment;
    }

    public final ColorAttachment attachColorbuffer(GL gL, int n, boolean bl) throws GLException {
        int n2 = this.rgba8Avail ? (bl ? 32856 : 32849) : (bl ? 32854 : 36194);
        return this.attachColorbuffer(gL, n, n2);
    }

    public final ColorAttachment attachColorbuffer(GL gL, int n, int n2) throws GLException, IllegalArgumentException {
        Attachment.Type type = Attachment.Type.determine(n2);
        if (Attachment.Type.COLOR != type) {
            throw new IllegalArgumentException("colorformat invalid: 0x" + Integer.toHexString(n2) + ", " + this);
        }
        return this.attachColorbuffer(gL, n, new ColorAttachment(n2, this.samples, this.width, this.height, 0));
    }

    public final ColorAttachment attachColorbuffer(GL gL, int n, ColorAttachment colorAttachment) throws GLException {
        this.validateAddColorAttachment(n, colorAttachment);
        colorAttachment.initialize(gL);
        this.addColorAttachment(n, colorAttachment);
        this.bind(gL);
        gL.glFramebufferRenderbuffer(36160, 36064 + n, 36161, colorAttachment.getName());
        this.updateStatus(gL);
        if (!this.isStatusValid()) {
            this.detachColorbuffer(gL, n);
            throw new GLException("attachColorbuffer " + colorAttachment + " at " + n + " failed " + this.getStatusString() + ", " + this);
        }
        if (DEBUG) {
            System.err.println("FBObject.attachColorbuffer: " + this);
        }
        return colorAttachment;
    }

    public final void attachRenderbuffer(GL gL, Attachment.Type type, int n) throws GLException, IllegalArgumentException {
        int n2;
        if (0 > n) {
            n = 24;
        }
        int n3 = -1;
        switch (type) {
            case DEPTH: {
                if (32 <= n && this.depth32Avail) {
                    n2 = 33191;
                    break;
                }
                if (24 <= n && this.depth24Avail) {
                    n2 = 33190;
                    break;
                }
                n2 = 33189;
                break;
            }
            case STENCIL: {
                if (16 <= n && this.stencil16Avail) {
                    n2 = 36169;
                    break;
                }
                if (8 <= n && this.stencil08Avail) {
                    n2 = 36168;
                    break;
                }
                if (4 <= n && this.stencil04Avail) {
                    n2 = 36167;
                    break;
                }
                if (1 <= n && this.stencil01Avail) {
                    n2 = 36166;
                    break;
                }
                throw new GLException("stencil buffer n/a");
            }
            case DEPTH_STENCIL: {
                if (this.packedDepthStencilAvail) {
                    n2 = 35056;
                    break;
                }
                n2 = 24 <= n && this.depth24Avail ? 33190 : 33189;
                if (this.stencil08Avail) {
                    n3 = 36168;
                    break;
                }
                if (this.stencil04Avail) {
                    n3 = 36167;
                    break;
                }
                if (this.stencil01Avail) {
                    n3 = 36166;
                    break;
                }
                throw new GLException("stencil buffer n/a");
            }
            default: {
                throw new IllegalArgumentException("only depth/stencil types allowed, was " + (Object)((Object)type) + ", " + this);
            }
        }
        this.attachRenderbufferImpl(gL, type, n2);
        if (0 <= n3) {
            this.attachRenderbufferImpl(gL, Attachment.Type.STENCIL, n3);
        }
    }

    public final void attachRenderbuffer(GL gL, int n) throws GLException, IllegalArgumentException {
        Attachment.Type type = Attachment.Type.determine(n);
        if (Attachment.Type.DEPTH != type && Attachment.Type.STENCIL != type && Attachment.Type.DEPTH_STENCIL != type) {
            throw new IllegalArgumentException("renderformat invalid: 0x" + Integer.toHexString(n) + ", " + this);
        }
        this.attachRenderbufferImpl(gL, type, n);
    }

    protected final void attachRenderbufferImpl(GL gL, Attachment.Type type, int n) throws GLException {
        if (null != this.depth && (Attachment.Type.DEPTH == type || Attachment.Type.DEPTH_STENCIL == type)) {
            throw new GLException("FBO depth buffer already attached (rb " + this.depth + "), type is " + (Object)((Object)type) + ", 0x" + Integer.toHexString(n) + ", " + this);
        }
        if (null != this.stencil && (Attachment.Type.STENCIL == type || Attachment.Type.DEPTH_STENCIL == type)) {
            throw new GLException("FBO stencil buffer already attached (rb " + this.stencil + "), type is " + (Object)((Object)type) + ", 0x" + Integer.toHexString(n) + ", " + this);
        }
        this.attachRenderbufferImpl2(gL, type, n);
    }

    private final void attachRenderbufferImpl2(GL gL, Attachment.Type type, int n) throws GLException {
        if (Attachment.Type.DEPTH == type) {
            if (null == this.depth) {
                this.depth = new RenderAttachment(Attachment.Type.DEPTH, n, this.samples, this.width, this.height, 0);
            } else {
                this.depth.setSize(this.width, this.height);
                this.depth.setSamples(this.samples);
            }
            this.depth.initialize(gL);
        } else if (Attachment.Type.STENCIL == type) {
            if (null == this.stencil) {
                this.stencil = new RenderAttachment(Attachment.Type.STENCIL, n, this.samples, this.width, this.height, 0);
            } else {
                this.stencil.setSize(this.width, this.height);
                this.stencil.setSamples(this.samples);
            }
            this.stencil.initialize(gL);
        } else if (Attachment.Type.DEPTH_STENCIL == type) {
            if (null == this.depth) {
                this.depth = new RenderAttachment(Attachment.Type.DEPTH, n, this.samples, this.width, this.height, 0);
            } else {
                this.depth.setSize(this.width, this.height);
                this.depth.setSamples(this.samples);
            }
            this.depth.initialize(gL);
            if (null == this.stencil) {
                this.stencil = new RenderAttachment(Attachment.Type.STENCIL, n, this.samples, this.width, this.height, this.depth.getName());
            } else {
                this.stencil.setName(this.depth.getName());
                this.stencil.setSize(this.width, this.height);
                this.stencil.setSamples(this.samples);
            }
            this.stencil.initialize(gL);
        }
        this.bind(gL);
        if (Attachment.Type.DEPTH == type) {
            gL.glFramebufferRenderbuffer(36160, 36096, 36161, this.depth.getName());
        } else if (Attachment.Type.STENCIL == type) {
            gL.glFramebufferRenderbuffer(36160, 36128, 36161, this.stencil.getName());
        } else if (Attachment.Type.DEPTH_STENCIL == type) {
            gL.glFramebufferRenderbuffer(36160, 36096, 36161, this.depth.getName());
            gL.glFramebufferRenderbuffer(36160, 36128, 36161, this.stencil.getName());
        }
        this.updateStatus(gL);
        if (!this.isStatusValid()) {
            this.detachRenderbuffer(gL, type);
            throw new GLException("renderbuffer attachment failed: " + this.getStatusString());
        }
        if (DEBUG) {
            System.err.println("FBObject.attachRenderbuffer: " + this);
        }
    }

    public final void detachColorbuffer(GL gL, int n) throws IllegalArgumentException {
        if (null == this.detachColorbufferImpl(gL, n, false)) {
            throw new IllegalArgumentException("ColorAttachment at " + n + ", not attached, " + this);
        }
        if (DEBUG) {
            System.err.println("FBObject.detachAll: " + this);
        }
    }

    private final Colorbuffer detachColorbufferImpl(GL gL, int n, boolean bl) {
        Colorbuffer colorbuffer = this.colorAttachmentPoints[n];
        if (null == colorbuffer) {
            return null;
        }
        this.bind(gL);
        if (colorbuffer instanceof TextureAttachment) {
            TextureAttachment textureAttachment = (TextureAttachment)colorbuffer;
            if (0 != textureAttachment.getName()) {
                gL.glFramebufferTexture2D(36160, 36064 + n, 3553, 0, 0);
                gL.glBindTexture(3553, 0);
            }
            textureAttachment.free(gL);
            this.removeColorAttachment(n, textureAttachment);
            if (bl) {
                textureAttachment.setSize(this.width, this.height);
                this.attachTexture2D(gL, n, textureAttachment);
            }
        } else if (colorbuffer instanceof ColorAttachment) {
            ColorAttachment colorAttachment = (ColorAttachment)colorbuffer;
            if (0 != colorAttachment.getName()) {
                gL.glFramebufferRenderbuffer(36160, 36064 + n, 36161, 0);
            }
            colorAttachment.free(gL);
            this.removeColorAttachment(n, colorbuffer);
            if (bl) {
                colorAttachment.setSize(this.width, this.height);
                colorAttachment.setSamples(this.samples);
                this.attachColorbuffer(gL, n, colorAttachment);
            }
        }
        return colorbuffer;
    }

    public final void detachRenderbuffer(GL gL, Attachment.Type type) throws IllegalArgumentException {
        this.detachRenderbufferImpl(gL, type, false);
    }

    public final boolean isDepthStencilPackedFormat() {
        boolean bl;
        boolean bl2 = bl = null != this.depth && null != this.stencil && this.depth.format == this.stencil.format;
        if (bl && this.depth.getName() != this.stencil.getName()) {
            throw new InternalError("depth/stencil packed format not sharing: depth " + this.depth + ", stencil " + this.stencil);
        }
        return bl;
    }

    private final void detachRenderbufferImpl(GL gL, Attachment.Type type, boolean bl) throws IllegalArgumentException {
        switch (type) {
            case DEPTH: 
            case STENCIL: 
            case DEPTH_STENCIL: {
                break;
            }
            default: {
                throw new IllegalArgumentException("only depth/stencil types allowed, was " + (Object)((Object)type) + ", " + this);
            }
        }
        if (null == this.depth && null == this.stencil) {
            return;
        }
        ArrayList<Attachment.Type> arrayList = new ArrayList<Attachment.Type>(2);
        if (this.isDepthStencilPackedFormat()) {
            arrayList.add(Attachment.Type.DEPTH_STENCIL);
        } else {
            switch (type) {
                case DEPTH: {
                    if (null == this.depth) break;
                    arrayList.add(Attachment.Type.DEPTH);
                    break;
                }
                case STENCIL: {
                    if (null == this.stencil) break;
                    arrayList.add(Attachment.Type.STENCIL);
                    break;
                }
                case DEPTH_STENCIL: {
                    if (null != this.depth) {
                        arrayList.add(Attachment.Type.DEPTH);
                    }
                    if (null == this.stencil) break;
                    arrayList.add(Attachment.Type.STENCIL);
                    break;
                }
            }
        }
        this.bind(gL);
        for (int i = 0; i < arrayList.size(); ++i) {
            int n;
            Attachment.Type type2 = (Attachment.Type)((Object)arrayList.get(i));
            switch (type2) {
                case DEPTH: {
                    n = this.depth.format;
                    if (0 != this.depth.getName()) {
                        gL.glFramebufferRenderbuffer(36160, 36096, 36161, 0);
                    }
                    this.depth.free(gL);
                    if (bl) break;
                    this.depth = null;
                    break;
                }
                case STENCIL: {
                    n = this.stencil.format;
                    if (0 != this.stencil.getName()) {
                        gL.glFramebufferRenderbuffer(36160, 36128, 36161, 0);
                    }
                    this.stencil.free(gL);
                    if (bl) break;
                    this.stencil = null;
                    break;
                }
                case DEPTH_STENCIL: {
                    n = this.depth.format;
                    if (0 != this.depth.getName()) {
                        gL.glFramebufferRenderbuffer(36160, 36096, 36161, 0);
                        gL.glFramebufferRenderbuffer(36160, 36128, 36161, 0);
                    }
                    this.depth.free(gL);
                    this.stencil.free(gL);
                    if (bl) break;
                    this.depth = null;
                    this.stencil = null;
                    break;
                }
                default: {
                    throw new InternalError("XXX");
                }
            }
            if (!bl) continue;
            this.attachRenderbufferImpl2(gL, type2, n);
        }
    }

    public final void detachAll(GL gL) {
        if (null != this.samplesSink) {
            this.samplesSink.detachAll(gL);
        }
        this.detachAllImpl(gL, true, false);
    }

    public final void detachAllColorbuffer(GL gL) {
        if (null != this.samplesSink) {
            this.samplesSink.detachAllColorbuffer(gL);
        }
        this.detachAllImpl(gL, false, false);
    }

    public final void detachAllTexturebuffer(GL gL) {
        if (null != this.samplesSink) {
            this.samplesSink.detachAllTexturebuffer(gL);
        }
        for (int i = 0; i < this.maxColorAttachments; ++i) {
            if (!(this.colorAttachmentPoints[i] instanceof TextureAttachment)) continue;
            this.detachColorbufferImpl(gL, i, false);
        }
    }

    public final void detachAllRenderbuffer(GL gL) {
        if (null != this.samplesSink) {
            this.samplesSink.detachAllRenderbuffer(gL);
        }
        this.detachRenderbufferImpl(gL, Attachment.Type.DEPTH_STENCIL, false);
    }

    private final void detachAllImpl(GL gL, boolean bl, boolean bl2) {
        for (int i = 0; i < this.maxColorAttachments; ++i) {
            this.detachColorbufferImpl(gL, i, bl2);
        }
        if (!bl2 && this.colorAttachmentCount > 0) {
            throw new InternalError("Non zero ColorAttachments " + this);
        }
        if (bl) {
            this.detachRenderbufferImpl(gL, Attachment.Type.DEPTH_STENCIL, bl2);
        }
        if (DEBUG) {
            System.err.println("FBObject.detachAll: [resetNonColorbuffer " + bl + ", recreate " + bl2 + "]: " + this);
        }
    }

    public final void destroy(GL gL) {
        if (null != this.samplesSink) {
            this.samplesSink.destroy(gL);
        }
        this.detachAllImpl(gL, true, false);
        int n = this.fbName;
        this.fbName = 0;
        int[] nArray = new int[1];
        if (0 != n) {
            nArray[0] = n;
            gL.glDeleteFramebuffers(1, nArray, 0);
        }
        this.initialized = false;
        this.bound = false;
        if (DEBUG) {
            System.err.println("FBObject.destroy: " + this);
        }
    }

    private final boolean sampleSinkSizeMismatch() {
        return this.samplesSink.getWidth() != this.width || this.samplesSink.getHeight() != this.height;
    }

    private final boolean sampleSinkTexMismatch() {
        return null == this.samplesSinkTexture || 0 == this.samplesSinkTexture.getName();
    }

    private final boolean sampleSinkDepthStencilMismatch() {
        boolean bl = null != this.depth && null == this.samplesSink.depth || null != this.depth && null != this.samplesSink.depth && this.depth.format != this.samplesSink.depth.format;
        boolean bl2 = null != this.stencil && null == this.samplesSink.stencil || null != this.stencil && null != this.samplesSink.stencil && this.stencil.format != this.samplesSink.stencil.format;
        return bl || bl2;
    }

    private final void resetMSAATexture2DSink(GL gL) throws GLException {
        if (0 == this.samples) {
            if (null != this.samplesSink) {
                this.samplesSink.detachAll(gL);
            }
            return;
        }
        boolean bl = this.sampleSinkSizeMismatch();
        boolean bl2 = this.sampleSinkTexMismatch();
        boolean bl3 = this.sampleSinkDepthStencilMismatch();
        if (!(bl || bl2 || bl3)) {
            return;
        }
        this.unbind(gL);
        if (DEBUG) {
            System.err.println("FBObject.resetMSAATexture2DSink: BEGIN\n\tTHIS " + this + ",\n\tSINK " + this.samplesSink + "\n\t size " + bl + ", tex " + bl2 + ", depthStencil " + bl3);
        }
        if (bl3) {
            this.samplesSink.detachAllRenderbuffer(gL);
        }
        if (bl) {
            this.samplesSink.reset(gL, this.width, this.height);
        }
        if (null == this.samplesSinkTexture) {
            this.samplesSinkTexture = this.samplesSink.attachTexture2D(gL, 0, true);
        } else if (0 == this.samplesSinkTexture.getName()) {
            this.samplesSinkTexture.setSize(this.width, this.height);
            this.samplesSink.attachTexture2D(gL, 0, this.samplesSinkTexture);
        }
        if (bl3) {
            this.samplesSink.attachRenderbuffer(gL, this.depth.format);
            if (null != this.stencil && !this.isDepthStencilPackedFormat()) {
                this.samplesSink.attachRenderbuffer(gL, this.stencil.format);
            }
        }
        bl = this.sampleSinkSizeMismatch();
        bl2 = this.sampleSinkTexMismatch();
        bl3 = this.sampleSinkDepthStencilMismatch();
        if (bl || bl2 || bl3) {
            throw new InternalError("Samples sink mismatch after reset: \n\tTHIS " + this + ",\n\t SINK " + this.samplesSink + "\n\t size " + bl + ", tex " + bl2 + ", depthStencil " + bl3);
        }
        if (DEBUG) {
            System.err.println("FBObject.resetMSAATexture2DSink: END\n\tTHIS " + this + ",\n\tSINK " + this.samplesSink + "\n\t size " + bl + ", tex " + bl2 + ", depthStencil " + bl3);
        }
    }

    public final void bind(GL gL) throws GLException {
        if (!this.bound || this.fbName != gL.getBoundFramebuffer(36160)) {
            this.checkInitialized();
            if (this.samples > 0 && this.fullFBOSupport) {
                gL.glBindFramebuffer(36009, this.getWriteFramebuffer());
                gL.glBindFramebuffer(36008, this.getReadFramebuffer());
            } else {
                gL.glBindFramebuffer(36160, this.getWriteFramebuffer());
            }
            this.checkNoError(null, gL.glGetError(), "FBObject post-bind");
            this.bound = true;
            this.samplesSinkDirty = true;
        }
    }

    public final void unbind(GL gL) throws GLException {
        if (this.bound) {
            if (this.fullFBOSupport) {
                gL.glBindFramebuffer(36009, 0);
                gL.glBindFramebuffer(36008, 0);
            } else {
                gL.glBindFramebuffer(36160, 0);
            }
            this.checkNoError(null, gL.glGetError(), "FBObject post-unbind");
            this.bound = false;
        }
    }

    public final boolean isBound(GL gL) {
        this.bound = this.bound && this.fbName != gL.getBoundFramebuffer(36160);
        return this.bound;
    }

    public final boolean isBound() {
        return this.bound;
    }

    public final void syncSamplingBuffer(GL gL) {
        this.unbind(gL);
        if (this.samples > 0 && this.samplesSinkDirty) {
            this.samplesSinkDirty = false;
            this.resetMSAATexture2DSink(gL);
            gL.glBindFramebuffer(36008, this.fbName);
            gL.glBindFramebuffer(36009, this.samplesSink.getWriteFramebuffer());
            ((GL2GL3)gL).glBlitFramebuffer(0, 0, this.width, this.height, 0, 0, this.width, this.height, 16384, 9728);
            if (this.fullFBOSupport) {
                gL.glBindFramebuffer(36009, 0);
                gL.glBindFramebuffer(36008, 0);
            } else {
                gL.glBindFramebuffer(36160, 0);
            }
        }
    }

    public final void use(GL gL, TextureAttachment textureAttachment) throws IllegalArgumentException {
        if (null == textureAttachment) {
            throw new IllegalArgumentException("null TextureAttachment");
        }
        if (this.samples > 0 && this.samplesSinkTexture == textureAttachment) {
            this.syncSamplingBuffer(gL);
        } else {
            this.unbind(gL);
        }
        gL.glBindTexture(3553, textureAttachment.getName());
    }

    public final void unuse(GL gL) {
        this.unbind(gL);
        gL.glBindTexture(3553, 0);
    }

    public final boolean supportsFBO(boolean bl) throws GLException {
        this.checkInitialized();
        return bl ? this.fullFBOSupport : this.basicFBOSupport;
    }

    public final boolean supportsRGBA8() throws GLException {
        this.checkInitialized();
        return this.rgba8Avail;
    }

    public final boolean supportsDepth(int n) throws GLException {
        this.checkInitialized();
        switch (n) {
            case 16: {
                return this.basicFBOSupport;
            }
            case 24: {
                return this.depth24Avail;
            }
            case 32: {
                return this.depth32Avail;
            }
        }
        return false;
    }

    public final boolean supportsStencil(int n) throws GLException {
        this.checkInitialized();
        switch (n) {
            case 1: {
                return this.stencil01Avail;
            }
            case 4: {
                return this.stencil04Avail;
            }
            case 8: {
                return this.stencil08Avail;
            }
            case 16: {
                return this.stencil16Avail;
            }
        }
        return false;
    }

    public final boolean supportsPackedDepthStencil() throws GLException {
        this.checkInitialized();
        return this.packedDepthStencilAvail;
    }

    public final int getMaxColorAttachments() throws GLException {
        this.checkInitialized();
        return this.maxColorAttachments;
    }

    public final int getMaxSamples() throws GLException {
        this.checkInitialized();
        return this.maxSamples;
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getNumSamples() {
        return this.samples;
    }

    public final int getWriteFramebuffer() {
        return this.fbName;
    }

    public final int getReadFramebuffer() {
        return this.samples > 0 ? this.samplesSink.getReadFramebuffer() : this.fbName;
    }

    public final int getColorAttachmentCount() {
        return this.colorAttachmentCount;
    }

    public final RenderAttachment getStencilAttachment() {
        return this.stencil;
    }

    public final RenderAttachment getDepthAttachment() {
        return this.depth;
    }

    public final FBObject getSamplingSinkFBO() {
        return this.samplesSink;
    }

    public final TextureAttachment getSamplingSink() {
        return this.samplesSinkTexture;
    }

    public final boolean isSamplingBufferDirty() {
        return this.samplesSinkDirty;
    }

    int objectHashCode() {
        return super.hashCode();
    }

    public final String toString() {
        String string = null != this.colorAttachmentPoints ? Arrays.asList(this.colorAttachmentPoints).toString() : null;
        return "FBO[name r/w " + this.fbName + "/" + this.getReadFramebuffer() + ", init " + this.initialized + ", bound " + this.bound + ", size " + this.width + "x" + this.height + ", samples " + this.samples + "/" + this.maxSamples + ", depth " + this.depth + ", stencil " + this.stencil + ", color attachments: " + this.colorAttachmentCount + "/" + this.maxColorAttachments + ": " + string + ", msaa-sink " + this.samplesSinkTexture + ", isSamplesSink " + (null == this.samplesSink) + ", obj 0x" + Integer.toHexString(this.objectHashCode()) + "]";
    }

    private final void updateStatus(GL gL) {
        this.vStatus = 0 == this.fbName ? -1 : gL.glCheckFramebufferStatus(36160);
    }

    public static abstract class Attachment {
        public final Type type;
        public final int format;
        private int width;
        private int height;
        private int name;
        protected boolean resourceOwner;
        private int initCounter;

        protected Attachment(Type type, int n, int n2, int n3, int n4) {
            this.type = type;
            this.format = n;
            this.width = n2;
            this.height = n3;
            this.name = n4;
            this.resourceOwner = false;
            this.initCounter = 0;
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        final void setSize(int n, int n2) {
            this.width = n;
            this.height = n2;
        }

        public final int getName() {
            return this.name;
        }

        final void setName(int n) {
            this.name = n;
        }

        public final int getInitCounter() {
            return this.initCounter;
        }

        public void initialize(GL gL) throws GLException {
            ++this.initCounter;
        }

        public void free(GL gL) throws GLException {
            --this.initCounter;
            if (0 == this.initCounter) {
                this.resourceOwner = false;
                this.name = 0;
            }
            if (DEBUG) {
                System.err.println("Attachment.free: " + this);
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Attachment)) {
                return false;
            }
            Attachment attachment = (Attachment)object;
            return this.type == attachment.type && this.format == attachment.format || this.width == attachment.width || this.height == attachment.height || this.name == attachment.name;
        }

        public int hashCode() {
            int n = 31 + this.type.ordinal();
            n = (n << 5) - n + this.format;
            n = (n << 5) - n + this.width;
            n = (n << 5) - n + this.height;
            n = (n << 5) - n + this.name;
            return n;
        }

        int objectHashCode() {
            return super.hashCode();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[type " + (Object)((Object)this.type) + ", format 0x" + Integer.toHexString(this.format) + ", " + this.width + "x" + this.height + ", name 0x" + Integer.toHexString(this.name) + ", obj 0x" + Integer.toHexString(this.objectHashCode()) + ", resOwner " + this.resourceOwner + ", initCount " + this.initCounter + "]";
        }

        public static Type getType(int n, int n2) {
            if (36064 <= n && n < 36064 + n2) {
                return Type.COLOR;
            }
            switch (n) {
                case 36096: {
                    return Type.DEPTH;
                }
                case 36128: {
                    return Type.STENCIL;
                }
            }
            throw new IllegalArgumentException("Invalid attachment point 0x" + Integer.toHexString(n));
        }

        public static enum Type {
            NONE,
            DEPTH,
            STENCIL,
            DEPTH_STENCIL,
            COLOR,
            COLOR_TEXTURE,
            DEPTH_TEXTURE,
            STENCIL_TEXTURE;


            public static Type determine(int n) throws IllegalArgumentException {
                switch (n) {
                    case 32849: 
                    case 32854: 
                    case 32855: 
                    case 32856: 
                    case 36194: {
                        return COLOR;
                    }
                    case 33189: 
                    case 33190: 
                    case 33191: {
                        return DEPTH;
                    }
                    case 36166: 
                    case 36167: 
                    case 36168: {
                        return STENCIL;
                    }
                    case 35056: {
                        return DEPTH_STENCIL;
                    }
                }
                throw new IllegalArgumentException("format invalid: 0x" + Integer.toHexString(n));
            }
        }
    }

    public static class ColorAttachment
    extends RenderAttachment
    implements Colorbuffer {
        public ColorAttachment(int n, int n2, int n3, int n4, int n5) {
            super(Attachment.Type.COLOR, n, n2, n3, n4, n5);
        }
    }

    public static interface Colorbuffer {
    }

    public static class RenderAttachment
    extends Attachment {
        private int samples;

        public RenderAttachment(Attachment.Type type, int n, int n2, int n3, int n4, int n5) {
            super(RenderAttachment.validateType(type), n, n3, n4, n5);
            this.samples = n2;
        }

        public final int getSamples() {
            return this.samples;
        }

        final void setSamples(int n) {
            this.samples = n;
        }

        private static Attachment.Type validateType(Attachment.Type type) {
            switch (type) {
                case DEPTH: 
                case STENCIL: 
                case COLOR: {
                    return type;
                }
            }
            throw new IllegalArgumentException("Invalid type: " + (Object)((Object)type));
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof RenderAttachment)) {
                return false;
            }
            return super.equals(object) && this.samples == ((RenderAttachment)object).samples;
        }

        @Override
        public int hashCode() {
            int n = super.hashCode();
            n = (n << 5) - n + this.samples;
            return n;
        }

        @Override
        public void initialize(GL gL) throws GLException {
            super.initialize(gL);
            if (1 == this.getInitCounter() && 0 == this.getName()) {
                int[] nArray = new int[]{-1};
                gL.glGenRenderbuffers(1, nArray, 0);
                if (0 == nArray[0]) {
                    throw new GLException("null renderbuffer, " + this);
                }
                this.setName(nArray[0]);
                gL.glBindRenderbuffer(36161, this.getName());
                if (this.samples > 0) {
                    ((GL2GL3)gL).glRenderbufferStorageMultisample(36161, this.samples, this.format, this.getWidth(), this.getHeight());
                } else {
                    gL.glRenderbufferStorage(36161, this.format, this.getWidth(), this.getHeight());
                }
                int n = gL.glGetError();
                if (0 != n) {
                    gL.glDeleteRenderbuffers(1, nArray, 0);
                    this.setName(0);
                    throw new GLException("GL Error 0x" + Integer.toHexString(n) + " while creating " + this);
                }
                this.resourceOwner = true;
                if (DEBUG) {
                    System.err.println("Attachment.init: " + this);
                }
            }
        }

        @Override
        public void free(GL gL) {
            if (1 == this.getInitCounter() && this.resourceOwner && 0 != this.getName()) {
                int[] nArray = new int[]{this.getName()};
                gL.glDeleteRenderbuffers(1, nArray, 0);
            }
            super.free(gL);
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "[type " + (Object)((Object)this.type) + ", format 0x" + Integer.toHexString(this.format) + ", samples " + this.samples + ", " + this.getWidth() + "x" + this.getHeight() + ", name 0x" + Integer.toHexString(this.getName()) + ", obj 0x" + Integer.toHexString(this.objectHashCode()) + ", resOwner " + this.resourceOwner + ", initCount " + this.getInitCounter() + "]";
        }
    }

    public static class TextureAttachment
    extends Attachment
    implements Colorbuffer {
        public final int dataFormat;
        public final int dataType;
        public final int magFilter;
        public final int minFilter;
        public final int wrapS;
        public final int wrapT;

        public TextureAttachment(Attachment.Type type, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
            super(TextureAttachment.validateType(type), n, n2, n3, n10);
            this.dataFormat = n4;
            this.dataType = n5;
            this.magFilter = n6;
            this.minFilter = n7;
            this.wrapS = n8;
            this.wrapT = n9;
        }

        private static Attachment.Type validateType(Attachment.Type type) {
            switch (type) {
                case COLOR_TEXTURE: 
                case DEPTH_TEXTURE: 
                case STENCIL_TEXTURE: {
                    return type;
                }
            }
            throw new IllegalArgumentException("Invalid type: " + (Object)((Object)type));
        }

        @Override
        public void initialize(GL gL) throws GLException {
            super.initialize(gL);
            if (1 == this.getInitCounter() && 0 == this.getName()) {
                int n;
                int[] nArray = new int[]{-1};
                gL.glGenTextures(1, nArray, 0);
                if (0 == nArray[0]) {
                    throw new GLException("null texture, " + this);
                }
                this.setName(nArray[0]);
                gL.glBindTexture(3553, nArray[0]);
                gL.glTexImage2D(3553, 0, this.format, this.getWidth(), this.getHeight(), 0, this.dataFormat, this.dataType, null);
                if (0 < this.magFilter) {
                    gL.glTexParameteri(3553, 10240, this.magFilter);
                }
                if (0 < this.minFilter) {
                    gL.glTexParameteri(3553, 10241, this.minFilter);
                }
                if (0 < this.wrapS) {
                    gL.glTexParameteri(3553, 10242, this.wrapS);
                }
                if (0 < this.wrapT) {
                    gL.glTexParameteri(3553, 10243, this.wrapT);
                }
                if (0 != (n = gL.glGetError())) {
                    gL.glDeleteTextures(1, nArray, 0);
                    this.setName(0);
                    throw new GLException("GL Error 0x" + Integer.toHexString(n) + " while creating " + this);
                }
                this.resourceOwner = true;
            }
            if (DEBUG) {
                System.err.println("Attachment.init: " + this);
            }
        }

        @Override
        public void free(GL gL) {
            if (1 == this.getInitCounter() && this.resourceOwner && 0 != this.getName()) {
                int[] nArray = new int[]{this.getName()};
                gL.glDeleteTextures(1, nArray, 0);
            }
            super.free(gL);
        }
    }
}

