/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.util.GLBuffers;
import com.jogamp.opengl.util.GLPixelStorageModes;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLDrawable;

public class GLReadBufferUtil {
    protected final int components;
    protected final int alignment;
    protected final Texture readTexture;
    protected final GLPixelStorageModes psm;
    protected int readPixelSizeLast = 0;
    protected ByteBuffer readPixelBuffer = null;
    protected TextureData readTextureData = null;

    public GLReadBufferUtil(boolean bl, boolean bl2) {
        this.components = bl ? 4 : 3;
        this.alignment = bl ? 4 : 1;
        this.readTexture = bl2 ? new Texture(3553) : null;
        this.psm = new GLPixelStorageModes();
    }

    public boolean isValid() {
        return null != this.readTextureData && null != this.readPixelBuffer;
    }

    public boolean hasAlpha() {
        return 4 == this.components;
    }

    public GLPixelStorageModes getGLPixelStorageModes() {
        return this.psm;
    }

    public ByteBuffer getPixelBuffer() {
        return this.readPixelBuffer;
    }

    public void rewindPixelBuffer() {
        if (null != this.readPixelBuffer) {
            this.readPixelBuffer.rewind();
        }
    }

    public TextureData getTextureData() {
        return this.readTextureData;
    }

    public Texture getTexture() {
        return this.readTexture;
    }

    public void write(File file) {
        try {
            TextureIO.write(this.readTextureData, file);
            this.rewindPixelBuffer();
        }
        catch (IOException iOException) {
            throw new RuntimeException("can not write to file: " + file.getAbsolutePath(), iOException);
        }
    }

    public boolean readPixels(GL gL, boolean bl) {
        boolean bl2;
        int n;
        int n2;
        int n3;
        GLDrawable gLDrawable = gL.getContext().getGLReadDrawable();
        int[] nArray = new int[]{0, 0};
        if (gL.isGL2GL3() && 3 == this.components) {
            n3 = 6407;
            n2 = 6407;
            n = 5121;
        } else if (gL.isGLES2Compatible() || gL.isExtensionAvailable("GL_OES_read_format")) {
            gL.glGetIntegerv(35739, nArray, 0);
            gL.glGetIntegerv(35738, nArray, 1);
            n3 = 4 == this.components ? 6408 : 6407;
            n2 = nArray[0];
            n = nArray[1];
        } else {
            n3 = 4 == this.components ? 6408 : 6407;
            n2 = 6408;
            n = 5121;
        }
        int[] nArray2 = new int[1];
        int n4 = GLBuffers.sizeof(gL, nArray2, n2, n, gLDrawable.getWidth(), gLDrawable.getHeight(), 1, true);
        boolean bl3 = false;
        if (n4 > this.readPixelSizeLast) {
            this.readPixelBuffer = Buffers.newDirectByteBuffer((int)n4);
            this.readPixelSizeLast = n4;
            try {
                this.readTextureData = new TextureData(gL.getGLProfile(), n3, gLDrawable.getWidth(), gLDrawable.getHeight(), 0, n2, n, false, false, bl, this.readPixelBuffer, null);
                bl3 = true;
            }
            catch (Exception exception) {
                this.readTextureData = null;
                this.readPixelBuffer = null;
                this.readPixelSizeLast = 0;
                throw new RuntimeException("can not fetch offscreen texture", exception);
            }
        } else {
            this.readTextureData.setInternalFormat(n3);
            this.readTextureData.setWidth(gLDrawable.getWidth());
            this.readTextureData.setHeight(gLDrawable.getHeight());
            this.readTextureData.setPixelFormat(n2);
            this.readTextureData.setPixelType(n);
        }
        boolean bl4 = bl2 = null != this.readPixelBuffer;
        if (bl2) {
            this.psm.setAlignment(gL, this.alignment, this.alignment);
            this.readPixelBuffer.clear();
            gL.glReadPixels(0, 0, gLDrawable.getWidth(), gLDrawable.getHeight(), n2, n, this.readPixelBuffer);
            this.readPixelBuffer.position(n4);
            this.readPixelBuffer.flip();
            int n5 = gL.glGetError();
            if (0 != n5) {
                System.err.println("GLReadBufferUtil.readPixels: readPixels error 0x" + Integer.toHexString(n5) + " " + gLDrawable.getWidth() + "x" + gLDrawable.getHeight() + ", fmt 0x" + Integer.toHexString(n2) + ", type 0x" + Integer.toHexString(n) + ", impl-fmt 0x" + Integer.toHexString(nArray[0]) + ", impl-type 0x" + Integer.toHexString(nArray[1]) + ", " + this.readPixelBuffer + ", sz " + n4);
                bl2 = false;
            }
            if (bl2 && null != this.readTexture) {
                if (bl3) {
                    this.readTexture.updateImage(gL, this.readTextureData);
                } else {
                    this.readTexture.updateSubImage(gL, this.readTextureData, 0, 0, 0, 0, 0, gLDrawable.getWidth(), gLDrawable.getHeight());
                }
                this.readPixelBuffer.rewind();
            }
            this.psm.restore(gL);
        }
        return bl2;
    }

    public void dispose(GL gL) {
        if (null != this.readTexture) {
            this.readTexture.destroy(gL);
            this.readTextureData = null;
        }
        if (null != this.readPixelBuffer) {
            this.readPixelBuffer.clear();
            this.readPixelBuffer = null;
        }
        this.readPixelSizeLast = 0;
    }
}

