/*
 * Decompiled with CFR 0.152.
 */
package javax.media.opengl;

import javax.media.nativewindow.Capabilities;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;

public class GLCapabilities
extends Capabilities
implements Cloneable,
GLCapabilitiesImmutable {
    private GLProfile glProfile = null;
    private boolean isPBuffer = false;
    private boolean isFBO = false;
    private boolean doubleBuffered = true;
    private boolean stereo = false;
    private boolean hardwareAccelerated = true;
    private int depthBits = 16;
    private int stencilBits = 0;
    private int accumRedBits = 0;
    private int accumGreenBits = 0;
    private int accumBlueBits = 0;
    private int accumAlphaBits = 0;
    private String sampleExtension = "default";
    private boolean sampleBuffers = false;
    private int numSamples = 2;
    private boolean pbufferFloatingPointBuffers;
    private boolean pbufferRenderToTexture;
    private boolean pbufferRenderToTextureRectangle;

    public GLCapabilities(GLProfile gLProfile) throws GLException {
        this.glProfile = null != gLProfile ? gLProfile : GLProfile.getDefault(GLProfile.getDefaultDevice());
    }

    @Override
    public Object cloneMutable() {
        return this.clone();
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (RuntimeException runtimeException) {
            throw new GLException(runtimeException);
        }
    }

    @Override
    public int hashCode() {
        int n = 31 + this.glProfile.hashCode();
        n = (n << 5) - n + (this.isFBO ? 1 : 0);
        n = (n << 5) - n + (this.isPBuffer ? 1 : 0);
        n = (n << 5) - n + (this.stereo ? 1 : 0);
        n = (n << 5) - n + (this.hardwareAccelerated ? 1 : 0);
        n = (n << 5) - n + this.depthBits;
        n = (n << 5) - n + this.stencilBits;
        n = (n << 5) - n + this.accumRedBits;
        n = (n << 5) - n + this.accumGreenBits;
        n = (n << 5) - n + this.accumBlueBits;
        n = (n << 5) - n + this.accumAlphaBits;
        n = (n << 5) - n + (this.sampleBuffers ? 1 : 0);
        n = (n << 5) - n + this.numSamples;
        n = (n << 5) - n + this.sampleExtension.hashCode();
        n = (n << 5) - n + (this.pbufferFloatingPointBuffers ? 1 : 0);
        n = (n << 5) - n + (this.pbufferRenderToTexture ? 1 : 0);
        n = (n << 5) - n + (this.pbufferRenderToTextureRectangle ? 1 : 0);
        return n;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl;
        if (this == object) {
            return true;
        }
        if (!(object instanceof GLCapabilitiesImmutable)) {
            return false;
        }
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)object;
        boolean bl2 = bl = super.equals(object) && gLCapabilitiesImmutable.getGLProfile() == this.glProfile && gLCapabilitiesImmutable.isPBuffer() == this.isPBuffer && gLCapabilitiesImmutable.isFBO() == this.isFBO && gLCapabilitiesImmutable.getStereo() == this.stereo && gLCapabilitiesImmutable.getHardwareAccelerated() == this.hardwareAccelerated && gLCapabilitiesImmutable.getDepthBits() == this.depthBits && gLCapabilitiesImmutable.getStencilBits() == this.stencilBits && gLCapabilitiesImmutable.getAccumRedBits() == this.accumRedBits && gLCapabilitiesImmutable.getAccumGreenBits() == this.accumGreenBits && gLCapabilitiesImmutable.getAccumBlueBits() == this.accumBlueBits && gLCapabilitiesImmutable.getAccumAlphaBits() == this.accumAlphaBits && gLCapabilitiesImmutable.getSampleBuffers() == this.sampleBuffers && gLCapabilitiesImmutable.getPbufferFloatingPointBuffers() == this.pbufferFloatingPointBuffers && gLCapabilitiesImmutable.getPbufferRenderToTexture() == this.pbufferRenderToTexture && gLCapabilitiesImmutable.getPbufferRenderToTextureRectangle() == this.pbufferRenderToTextureRectangle;
        if (this.sampleBuffers) {
            bl = bl && gLCapabilitiesImmutable.getNumSamples() == this.numSamples && gLCapabilitiesImmutable.getSampleExtension().equals(this.sampleExtension);
        }
        return bl;
    }

    @Override
    public int compareTo(CapabilitiesImmutable capabilitiesImmutable) {
        int n;
        if (!(capabilitiesImmutable instanceof GLCapabilitiesImmutable)) {
            Class<?> clazz = null != capabilitiesImmutable ? capabilitiesImmutable.getClass() : null;
            throw new ClassCastException("Not a GLCapabilitiesImmutable object, but " + clazz);
        }
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)capabilitiesImmutable;
        if (this.hardwareAccelerated && !gLCapabilitiesImmutable.getHardwareAccelerated()) {
            return 1;
        }
        if (!this.hardwareAccelerated && gLCapabilitiesImmutable.getHardwareAccelerated()) {
            return -1;
        }
        if (this.stereo && !gLCapabilitiesImmutable.getStereo()) {
            return 1;
        }
        if (!this.stereo && gLCapabilitiesImmutable.getStereo()) {
            return -1;
        }
        if (this.doubleBuffered && !gLCapabilitiesImmutable.getDoubleBuffered()) {
            return 1;
        }
        if (!this.doubleBuffered && gLCapabilitiesImmutable.getDoubleBuffered()) {
            return -1;
        }
        int n2 = this.getNumSamples();
        if (n2 > (n = gLCapabilitiesImmutable.getNumSamples())) {
            return 1;
        }
        if (n2 < n) {
            return -1;
        }
        if (this.stencilBits > gLCapabilitiesImmutable.getStencilBits()) {
            return 1;
        }
        if (this.stencilBits < gLCapabilitiesImmutable.getStencilBits()) {
            return -1;
        }
        int n3 = super.compareTo(gLCapabilitiesImmutable);
        if (0 != n3) {
            return n3;
        }
        if (this.depthBits > gLCapabilitiesImmutable.getDepthBits()) {
            return 1;
        }
        if (this.depthBits < gLCapabilitiesImmutable.getDepthBits()) {
            return -1;
        }
        return 0;
    }

    @Override
    public final GLProfile getGLProfile() {
        return this.glProfile;
    }

    public void setGLProfile(GLProfile gLProfile) {
        this.glProfile = gLProfile;
    }

    @Override
    public final boolean isPBuffer() {
        return this.isPBuffer;
    }

    public void setPBuffer(boolean bl) {
        if (bl) {
            this.setOnscreen(false);
        }
        this.isPBuffer = bl;
    }

    @Override
    public final boolean isFBO() {
        return this.isFBO;
    }

    public void setFBO(boolean bl) {
        if (bl) {
            this.setOnscreen(false);
        }
        this.isFBO = bl;
    }

    @Override
    public void setOnscreen(boolean bl) {
        if (bl) {
            this.setPBuffer(false);
            this.setFBO(false);
        }
        super.setOnscreen(bl);
    }

    @Override
    public final boolean getDoubleBuffered() {
        return this.doubleBuffered;
    }

    public void setDoubleBuffered(boolean bl) {
        this.doubleBuffered = bl;
    }

    @Override
    public final boolean getStereo() {
        return this.stereo;
    }

    public void setStereo(boolean bl) {
        this.stereo = bl;
    }

    @Override
    public final boolean getHardwareAccelerated() {
        return this.hardwareAccelerated;
    }

    public void setHardwareAccelerated(boolean bl) {
        this.hardwareAccelerated = bl;
    }

    @Override
    public final int getDepthBits() {
        return this.depthBits;
    }

    public void setDepthBits(int n) {
        this.depthBits = n;
    }

    @Override
    public final int getStencilBits() {
        return this.stencilBits;
    }

    public void setStencilBits(int n) {
        this.stencilBits = n;
    }

    @Override
    public final int getAccumRedBits() {
        return this.accumRedBits;
    }

    public void setAccumRedBits(int n) {
        this.accumRedBits = n;
    }

    @Override
    public final int getAccumGreenBits() {
        return this.accumGreenBits;
    }

    public void setAccumGreenBits(int n) {
        this.accumGreenBits = n;
    }

    @Override
    public final int getAccumBlueBits() {
        return this.accumBlueBits;
    }

    public void setAccumBlueBits(int n) {
        this.accumBlueBits = n;
    }

    @Override
    public final int getAccumAlphaBits() {
        return this.accumAlphaBits;
    }

    public void setAccumAlphaBits(int n) {
        this.accumAlphaBits = n;
    }

    public void setSampleExtension(String string) {
        this.sampleExtension = string;
    }

    @Override
    public final String getSampleExtension() {
        return this.sampleExtension;
    }

    public void setSampleBuffers(boolean bl) {
        this.sampleBuffers = bl;
        if (this.sampleBuffers && this.getAlphaBits() == 0) {
            this.setAlphaBits(1);
        }
    }

    @Override
    public final boolean getSampleBuffers() {
        return this.sampleBuffers;
    }

    public void setNumSamples(int n) {
        this.numSamples = n;
    }

    @Override
    public final int getNumSamples() {
        return this.sampleBuffers ? this.numSamples : 0;
    }

    public void setPbufferFloatingPointBuffers(boolean bl) {
        this.pbufferFloatingPointBuffers = bl;
    }

    @Override
    public final boolean getPbufferFloatingPointBuffers() {
        return this.pbufferFloatingPointBuffers;
    }

    public void setPbufferRenderToTexture(boolean bl) {
        this.pbufferRenderToTexture = bl;
    }

    @Override
    public final boolean getPbufferRenderToTexture() {
        return this.pbufferRenderToTexture;
    }

    public void setPbufferRenderToTextureRectangle(boolean bl) {
        this.pbufferRenderToTextureRectangle = bl;
    }

    @Override
    public final boolean getPbufferRenderToTextureRectangle() {
        return this.pbufferRenderToTextureRectangle;
    }

    @Override
    public StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        int n = this.sampleBuffers ? this.numSamples : 0;
        super.toString(stringBuilder);
        stringBuilder.append(", accum-rgba ").append(this.accumRedBits).append("/").append(this.accumGreenBits).append("/").append(this.accumBlueBits).append("/").append(this.accumAlphaBits);
        stringBuilder.append(", dp/st/ms: ").append(this.depthBits).append("/").append(this.stencilBits).append("/").append(n);
        if (n > 0) {
            stringBuilder.append(", sample-ext ").append(this.sampleExtension);
        }
        if (this.doubleBuffered) {
            stringBuilder.append(", dbl");
        } else {
            stringBuilder.append(", one");
        }
        if (this.stereo) {
            stringBuilder.append(", stereo");
        } else {
            stringBuilder.append(", mono  ");
        }
        if (this.hardwareAccelerated) {
            stringBuilder.append(", hw, ");
        } else {
            stringBuilder.append(", sw, ");
        }
        stringBuilder.append(this.glProfile);
        if (!this.isOnscreen()) {
            if (this.isFBO) {
                stringBuilder.append(", fbo");
            }
            if (this.isPBuffer) {
                stringBuilder.append(", pbuffer [r2t ").append(this.pbufferRenderToTexture ? 1 : 0).append(", r2tr ").append(this.pbufferRenderToTextureRectangle ? 1 : 0).append(", float ").append(this.pbufferFloatingPointBuffers ? 1 : 0).append("]");
            }
            if (!this.isFBO && !this.isPBuffer) {
                stringBuilder.append(", pixmap");
            }
        }
        return stringBuilder;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GLCaps[");
        this.toString(stringBuilder);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

