/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.macosx;

import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.util.Insets;
import javax.media.nativewindow.util.Point;
import jogamp.nativewindow.Debug;
import jogamp.nativewindow.NWJNILibLoader;

public class OSXUtil {
    private static boolean isInit = false;
    private static final boolean DEBUG = Debug.debug("OSXUtil");

    public static synchronized void initSingleton(boolean bl) {
        if (!isInit) {
            if (!NWJNILibLoader.loadNativeWindow("macosx")) {
                throw new NativeWindowException("NativeWindow MacOSX native library load error.");
            }
            if (!OSXUtil.initIDs0()) {
                throw new NativeWindowException("MacOSX: Could not initialized native stub");
            }
            if (DEBUG) {
                System.out.println("OSX.isFirstX11ActionOnProcess: " + bl);
            }
            isInit = true;
        }
    }

    public static boolean requiresToolkitLock() {
        return false;
    }

    public static boolean isNSView(long l) {
        return OSXUtil.isNSView0(l);
    }

    public static Point GetLocationOnScreen(long l, boolean bl, int n, int n2) {
        Point point = (Point)OSXUtil.GetLocationOnScreen0(l, n, n2);
        if (bl) {
            Insets insets = OSXUtil.GetInsets(l);
            point.setX(point.getX() + insets.getLeftWidth());
            point.setY(point.getY() + insets.getTopHeight());
        }
        return point;
    }

    public static Insets GetInsets(long l) {
        return (Insets)OSXUtil.GetInsets0(l);
    }

    public static long CreateNSWindow(int n, int n2, int n3, int n4) {
        return OSXUtil.CreateNSWindow0(n, n2, n3, n4);
    }

    public static void DestroyNSWindow(long l) {
        OSXUtil.DestroyNSWindow0(l);
    }

    public static long GetNSView(long l) {
        return OSXUtil.GetNSView0(l);
    }

    public static long CreateCALayer(int n, int n2, int n3, int n4) {
        return OSXUtil.CreateCALayer0(n, n2, n3, n4);
    }

    public static void AddCASublayer(long l, long l2) {
        if (0L == l || 0L == l2) {
            throw new IllegalArgumentException("rootCALayer 0x" + Long.toHexString(l) + ", subCALayer 0x" + Long.toHexString(l2));
        }
        OSXUtil.AddCASublayer0(l, l2);
    }

    public static void RemoveCASublayer(long l, long l2) {
        if (0L == l || 0L == l2) {
            throw new IllegalArgumentException("rootCALayer 0x" + Long.toHexString(l) + ", subCALayer 0x" + Long.toHexString(l2));
        }
        OSXUtil.RemoveCASublayer0(l, l2);
    }

    public static void DestroyCALayer(long l) {
        if (0L == l) {
            throw new IllegalArgumentException("caLayer 0x" + Long.toHexString(l));
        }
        OSXUtil.DestroyCALayer0(l);
    }

    public static void RunOnMainThread(boolean bl, Runnable runnable) {
        if (OSXUtil.IsMainThread0()) {
            runnable.run();
        } else {
            OSXUtil.RunOnMainThread0(bl, runnable);
        }
    }

    public static boolean IsMainThread() {
        return OSXUtil.IsMainThread0();
    }

    private static native boolean initIDs0();

    private static native boolean isNSView0(long var0);

    private static native Object GetLocationOnScreen0(long var0, int var2, int var3);

    private static native Object GetInsets0(long var0);

    private static native long CreateNSWindow0(int var0, int var1, int var2, int var3);

    private static native void DestroyNSWindow0(long var0);

    private static native long GetNSView0(long var0);

    private static native long CreateCALayer0(int var0, int var1, int var2, int var3);

    private static native void AddCASublayer0(long var0, long var2);

    private static native void RemoveCASublayer0(long var0, long var2);

    private static native void DestroyCALayer0(long var0);

    private static native void RunOnMainThread0(boolean var0, Runnable var1);

    private static native boolean IsMainThread0();
}

