/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.windows;

import com.jogamp.newt.event.MouseAdapter;
import com.jogamp.newt.event.MouseEvent;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.util.Insets;
import javax.media.nativewindow.util.InsetsImmutable;
import javax.media.nativewindow.util.Point;
import jogamp.nativewindow.windows.GDI;
import jogamp.nativewindow.windows.GDIUtil;
import jogamp.newt.WindowImpl;
import jogamp.newt.driver.windows.WindowsDisplay;
import jogamp.newt.driver.windows.WindowsScreen;

public class WindowsWindow
extends WindowImpl {
    private long hmon;
    private long hdc;
    private long hdc_old;
    private long windowHandleClose;
    private int lastPressedKeyCode = 0;

    @Override
    protected int lockSurfaceImpl() {
        if (0L != this.hdc) {
            throw new InternalError("surface not released");
        }
        this.hdc = GDI.GetDC(this.getWindowHandle());
        this.hmon = this.MonitorFromWindow0(this.getWindowHandle());
        if (0L == this.hdc) {
            return 1;
        }
        if (this.hdc_old == this.hdc) {
            return 3;
        }
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("WindowsWindow: surface change " + WindowsWindow.toHexString(this.hdc_old) + " -> " + WindowsWindow.toHexString(this.hdc));
        }
        return 2;
    }

    @Override
    protected void unlockSurfaceImpl() {
        if (0L != this.hdc) {
            GDI.ReleaseDC(this.getWindowHandle(), this.hdc);
            this.hdc_old = this.hdc;
            this.hdc = 0L;
        }
    }

    @Override
    public final long getSurfaceHandle() {
        return this.hdc;
    }

    @Override
    public boolean hasDeviceChanged() {
        long l;
        if (0L != this.getWindowHandle() && this.hmon != (l = this.MonitorFromWindow0(this.getWindowHandle()))) {
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("Info: Window Device Changed " + Thread.currentThread().getName() + ", HMON " + WindowsWindow.toHexString(this.hmon) + " -> " + WindowsWindow.toHexString(l));
            }
            this.hmon = l;
            return true;
        }
        return false;
    }

    @Override
    protected void createNativeImpl() {
        WindowsScreen windowsScreen = (WindowsScreen)this.getScreen();
        WindowsDisplay windowsDisplay = (WindowsDisplay)windowsScreen.getDisplay();
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = GraphicsConfigurationFactory.getFactory(windowsDisplay.getGraphicsDevice(), this.capsRequested).chooseGraphicsConfiguration(this.capsRequested, this.capsRequested, this.capabilitiesChooser, windowsScreen.getGraphicsScreen(), 0);
        if (null == abstractGraphicsConfiguration) {
            throw new NativeWindowException("Error choosing GraphicsConfiguration creating window: " + this);
        }
        this.setGraphicsConfiguration(abstractGraphicsConfiguration);
        int n = this.getReconfigureFlags(0, true) & 0xA00;
        this.setWindowHandle(this.CreateWindow0(windowsDisplay.getHInstance(), windowsDisplay.getWindowClassName(), windowsDisplay.getWindowClassName(), this.getParentWindowHandle(), this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.autoPosition(), n));
        if (this.getWindowHandle() == 0L) {
            throw new NativeWindowException("Error creating window");
        }
        this.windowHandleClose = this.getWindowHandle();
        this.addMouseListener(new MouseTracker());
        if (DEBUG_IMPLEMENTATION) {
            Exception exception = new Exception("Info: Window new window handle " + Thread.currentThread().getName() + " (Parent HWND " + WindowsWindow.toHexString(this.getParentWindowHandle()) + ") : HWND " + WindowsWindow.toHexString(this.getWindowHandle()) + ", " + Thread.currentThread());
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeNativeImpl() {
        if (this.windowHandleClose != 0L) {
            Exception exception;
            block10: {
                if (this.hdc != 0L) {
                    try {
                        GDI.ReleaseDC(this.windowHandleClose, this.hdc);
                    }
                    catch (Throwable throwable) {
                        if (!DEBUG_IMPLEMENTATION) break block10;
                        exception = new Exception("Warning: closeNativeImpl failed - " + Thread.currentThread().getName(), throwable);
                        exception.printStackTrace();
                    }
                }
            }
            try {
                GDI.SetParent(this.windowHandleClose, 0L);
                GDI.DestroyWindow(this.windowHandleClose);
            }
            catch (Throwable throwable) {
                if (DEBUG_IMPLEMENTATION) {
                    exception = new Exception("Warning: closeNativeImpl failed - " + Thread.currentThread().getName(), throwable);
                    exception.printStackTrace();
                }
            }
            finally {
                this.windowHandleClose = 0L;
            }
        }
        this.hdc = 0L;
        this.hdc_old = 0L;
    }

    @Override
    protected boolean reconfigureWindowImpl(int n, int n2, int n3, int n4, int n5) {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("WindowsWindow reconfig: " + n + "/" + n2 + " " + n3 + "x" + n4 + ", " + WindowsWindow.getReconfigureFlagsAsString(null, n5));
        }
        if (0 == (0x200 & n5)) {
            InsetsImmutable insetsImmutable = this.getInsets();
            n -= insetsImmutable.getLeftWidth();
            n2 -= insetsImmutable.getTopHeight();
            if (0 < n3 && 0 < n4) {
                n3 += insetsImmutable.getTotalWidth();
                n4 += insetsImmutable.getTotalHeight();
            }
        }
        this.reconfigureWindow0(this.getParentWindowHandle(), this.getWindowHandle(), n, n2, n3, n4, n5);
        if (0 != (0x10 & n5)) {
            this.visibleChanged(false, 0 != (0x1000 & n5));
        }
        return true;
    }

    @Override
    protected void requestFocusImpl(boolean bl) {
        this.requestFocus0(this.getWindowHandle(), bl);
    }

    @Override
    protected void setTitleImpl(String string) {
        WindowsWindow.setTitle0(this.getWindowHandle(), string);
    }

    @Override
    protected boolean setPointerVisibleImpl(final boolean bl) {
        final Boolean[] booleanArray = new Boolean[]{Boolean.FALSE};
        this.runOnEDTIfAvail(true, new Runnable(){

            @Override
            public void run() {
                booleanArray[0] = WindowsWindow.setPointerVisible0(WindowsWindow.this.getWindowHandle(), bl);
            }
        });
        return booleanArray[0];
    }

    @Override
    protected boolean confinePointerImpl(final boolean bl) {
        final Boolean[] booleanArray = new Boolean[]{Boolean.FALSE};
        this.runOnEDTIfAvail(true, new Runnable(){

            @Override
            public void run() {
                Point point = WindowsWindow.this.getLocationOnScreenImpl(0, 0);
                booleanArray[0] = WindowsWindow.confinePointer0(WindowsWindow.this.getWindowHandle(), bl, point.getX(), point.getY(), point.getX() + WindowsWindow.this.getWidth(), point.getY() + WindowsWindow.this.getHeight());
            }
        });
        return booleanArray[0];
    }

    @Override
    protected void warpPointerImpl(final int n, final int n2) {
        this.runOnEDTIfAvail(true, new Runnable(){

            @Override
            public void run() {
                Point point = WindowsWindow.this.getLocationOnScreenImpl(n, n2);
                WindowsWindow.warpPointer0(WindowsWindow.this.getWindowHandle(), point.getX(), point.getY());
            }
        });
    }

    @Override
    protected Point getLocationOnScreenImpl(int n, int n2) {
        return GDIUtil.GetRelativeLocation(this.getWindowHandle(), 0L, n, n2);
    }

    @Override
    protected void updateInsetsImpl(Insets insets) {
    }

    private final int validateKeyCode(int n, int n2) {
        switch (n) {
            case 300: {
                this.lastPressedKeyCode = n2;
                break;
            }
            case 302: {
                if (-1 == n2) {
                    n2 = this.lastPressedKeyCode;
                }
                this.lastPressedKeyCode = -1;
            }
        }
        return n2;
    }

    @Override
    public void sendKeyEvent(int n, int n2, int n3, char c) {
        n3 = this.validateKeyCode(n, n3);
        super.sendKeyEvent(n, n2, n3, c);
    }

    @Override
    public void enqueueKeyEvent(boolean bl, int n, int n2, int n3, char c) {
        n3 = this.validateKeyCode(n, n3);
        super.enqueueKeyEvent(bl, n, n2, n3, c);
    }

    protected static native boolean initIDs0();

    protected static native long getNewtWndProc0();

    private native long CreateWindow0(long var1, String var3, String var4, long var5, int var7, int var8, int var9, int var10, boolean var11, int var12);

    private native long MonitorFromWindow0(long var1);

    private native void reconfigureWindow0(long var1, long var3, int var5, int var6, int var7, int var8, int var9);

    private static native void setTitle0(long var0, String var2);

    private native void requestFocus0(long var1, boolean var3);

    private static native boolean setPointerVisible0(long var0, boolean var2);

    private static native boolean confinePointer0(long var0, boolean var2, int var3, int var4, int var5, int var6);

    private static native void warpPointer0(long var0, int var2, int var3);

    private static native void trackPointerLeave0(long var0);

    static {
        WindowsDisplay.initSingleton();
    }

    class MouseTracker
    extends MouseAdapter {
        MouseTracker() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            WindowsWindow.trackPointerLeave0(WindowsWindow.this.getWindowHandle());
        }
    }
}

