/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.nativewindow.MutableGraphicsConfiguration;
import java.nio.Buffer;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.MutableSurface;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.OffscreenLayerSurface;
import javax.media.nativewindow.ProxySurface;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLPbuffer;
import javax.media.opengl.GLProfile;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLDynamicLookupHelper;
import jogamp.opengl.GLFBODrawableImpl;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import jogamp.opengl.GLPbufferImpl;

public abstract class GLDrawableFactoryImpl
extends GLDrawableFactory {
    protected static final boolean DEBUG = GLDrawableImpl.DEBUG;
    private boolean gammaShutdownHookRegistered;
    private Thread gammaShutdownHook;
    private Buffer originalGammaRamp;

    protected GLDrawableFactoryImpl() {
    }

    public final GLContext getOrCreateSharedContext(AbstractGraphicsDevice abstractGraphicsDevice) {
        if (null != (abstractGraphicsDevice = this.validateDevice(abstractGraphicsDevice))) {
            return this.getOrCreateSharedContextImpl(abstractGraphicsDevice);
        }
        return null;
    }

    protected abstract GLContext getOrCreateSharedContextImpl(AbstractGraphicsDevice var1);

    protected final AbstractGraphicsDevice getOrCreateSharedDevice(AbstractGraphicsDevice abstractGraphicsDevice) {
        if (null == abstractGraphicsDevice) {
            abstractGraphicsDevice = this.getDefaultDevice();
            if (null == abstractGraphicsDevice) {
                throw new InternalError("no default device");
            }
            if (GLProfile.DEBUG) {
                System.err.println("Info: GLDrawableFactoryImpl.getOrCreateSharedContext: using default device : " + abstractGraphicsDevice);
            }
        } else if (!this.getIsDeviceCompatible(abstractGraphicsDevice)) {
            if (GLProfile.DEBUG) {
                System.err.println("Info: GLDrawableFactoryImpl.getOrCreateSharedContext: device not compatible : " + abstractGraphicsDevice);
            }
            return null;
        }
        return this.getOrCreateSharedDeviceImpl(abstractGraphicsDevice);
    }

    protected abstract AbstractGraphicsDevice getOrCreateSharedDeviceImpl(AbstractGraphicsDevice var1);

    public abstract GLDynamicLookupHelper getGLDynamicLookupHelper(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GLDrawable createGLDrawable(NativeSurface nativeSurface) {
        if (nativeSurface == null) {
            throw new IllegalArgumentException("Null target");
        }
        MutableGraphicsConfiguration mutableGraphicsConfiguration = (MutableGraphicsConfiguration)nativeSurface.getGraphicsConfiguration();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)mutableGraphicsConfiguration.getChosenCapabilities();
        AbstractGraphicsDevice abstractGraphicsDevice = mutableGraphicsConfiguration.getScreen().getDevice();
        boolean bl = GLContext.isFBOAvailable(abstractGraphicsDevice, gLCapabilitiesImmutable.getGLProfile());
        GLDrawableImpl gLDrawableImpl = null;
        abstractGraphicsDevice.lock();
        try {
            OffscreenLayerSurface offscreenLayerSurface = NativeWindowFactory.getOffscreenLayerSurface(nativeSurface, true);
            if (null != offscreenLayerSurface) {
                GLCapabilities gLCapabilities = (GLCapabilities)gLCapabilitiesImmutable.cloneMutable();
                gLCapabilities.setOnscreen(false);
                if (this.canCreateGLPbuffer(abstractGraphicsDevice)) {
                    gLCapabilities.setPBuffer(true);
                } else {
                    gLCapabilities.setFBO(false);
                    gLCapabilities.setPBuffer(false);
                }
                mutableGraphicsConfiguration.setChosenCapabilities(gLCapabilities);
                if (DEBUG) {
                    System.err.println("GLDrawableFactoryImpl.createGLDrawable -> OnscreenDrawable -> Offscreen-Layer: " + nativeSurface);
                }
                if (!(nativeSurface instanceof MutableSurface)) {
                    throw new IllegalArgumentException("Passed NativeSurface must implement SurfaceChangeable for offscreen layered surface: " + nativeSurface);
                }
                if (((GLCapabilitiesImmutable)mutableGraphicsConfiguration.getRequestedCapabilities()).isFBO() && bl) {
                    GLDrawableImpl gLDrawableImpl2 = this.createOnscreenDrawableImpl(nativeSurface);
                    gLDrawableImpl = new GLFBODrawableImpl(this, gLDrawableImpl2, nativeSurface, nativeSurface.getWidth(), nativeSurface.getHeight(), 0);
                } else {
                    gLDrawableImpl = this.createOffscreenDrawableImpl(nativeSurface);
                }
            } else if (gLCapabilitiesImmutable.isOnscreen()) {
                if (DEBUG) {
                    System.err.println("GLDrawableFactoryImpl.createGLDrawable -> OnscreenDrawable: " + nativeSurface);
                }
                gLDrawableImpl = this.createOnscreenDrawableImpl(nativeSurface);
            } else {
                if (DEBUG) {
                    System.err.println("GLDrawableFactoryImpl.createGLDrawable -> OffScreenDrawable, FBO-chosen(-avail)/PBuffer: " + gLCapabilitiesImmutable.isFBO() + "(" + bl + ")/" + gLCapabilitiesImmutable.isPBuffer() + ": " + nativeSurface);
                }
                if (!(nativeSurface instanceof MutableSurface)) {
                    throw new IllegalArgumentException("Passed NativeSurface must implement SurfaceChangeable for offscreen: " + nativeSurface);
                }
                if (((GLCapabilitiesImmutable)mutableGraphicsConfiguration.getRequestedCapabilities()).isFBO() && bl) {
                    GLDrawableImpl gLDrawableImpl3 = this.createOnscreenDrawableImpl(nativeSurface);
                    gLDrawableImpl = new GLFBODrawableImpl(this, gLDrawableImpl3, nativeSurface, nativeSurface.getWidth(), nativeSurface.getHeight(), 0);
                } else {
                    gLDrawableImpl = this.createOffscreenDrawableImpl(nativeSurface);
                }
            }
        }
        finally {
            abstractGraphicsDevice.unlock();
        }
        if (DEBUG) {
            System.err.println("GLDrawableFactoryImpl.createGLDrawable: " + gLDrawableImpl);
        }
        return gLDrawableImpl;
    }

    protected abstract GLDrawableImpl createOnscreenDrawableImpl(NativeSurface var1);

    @Override
    public abstract boolean canCreateGLPbuffer(AbstractGraphicsDevice var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GLPbuffer createGLPbuffer(AbstractGraphicsDevice abstractGraphicsDevice, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser, int n, int n2, GLContext gLContext) {
        if (n <= 0 || n2 <= 0) {
            throw new GLException("initial size must be positive (were (" + n + " x " + n2 + "))");
        }
        AbstractGraphicsDevice abstractGraphicsDevice2 = this.getOrCreateSharedDevice(abstractGraphicsDevice);
        if (null == abstractGraphicsDevice2) {
            throw new GLException("No shared device for requested: " + abstractGraphicsDevice);
        }
        if (!this.canCreateGLPbuffer(abstractGraphicsDevice2)) {
            throw new GLException("Pbuffer not available with device: " + abstractGraphicsDevice2);
        }
        GLCapabilitiesImmutable gLCapabilitiesImmutable2 = GLGraphicsConfigurationUtil.fixGLPBufferGLCapabilities(gLCapabilitiesImmutable);
        GLDrawableImpl gLDrawableImpl = null;
        abstractGraphicsDevice2.lock();
        try {
            gLDrawableImpl = (GLDrawableImpl)this.createGLDrawable(this.createMutableSurfaceImpl(abstractGraphicsDevice2, true, gLCapabilitiesImmutable2, gLCapabilitiesImmutable, gLCapabilitiesChooser, n, n2, null));
            if (null != gLDrawableImpl) {
                gLDrawableImpl.setRealized(true);
            }
        }
        finally {
            abstractGraphicsDevice2.unlock();
        }
        if (null == gLDrawableImpl) {
            throw new GLException("Could not create Pbuffer drawable for: " + abstractGraphicsDevice2 + ", " + gLCapabilitiesImmutable2 + ", " + n + "x" + n2);
        }
        return new GLPbufferImpl(gLDrawableImpl, gLContext, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GLDrawable createOffscreenDrawable(AbstractGraphicsDevice abstractGraphicsDevice, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser, int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new GLException("initial size must be positive (were (" + n + " x " + n2 + "))");
        }
        AbstractGraphicsDevice abstractGraphicsDevice2 = this.getOrCreateSharedDevice(abstractGraphicsDevice);
        if (null == abstractGraphicsDevice2) {
            throw new GLException("No shared device for requested: " + abstractGraphicsDevice);
        }
        if (gLCapabilitiesImmutable.isFBO() && GLContext.isFBOAvailable(abstractGraphicsDevice2, gLCapabilitiesImmutable.getGLProfile())) {
            abstractGraphicsDevice2.lock();
            try {
                GLDrawable gLDrawable = this.createFBODrawableImpl(abstractGraphicsDevice2, gLCapabilitiesImmutable, gLCapabilitiesChooser, n, n2);
                return gLDrawable;
            }
            finally {
                abstractGraphicsDevice2.unlock();
            }
        }
        GLCapabilitiesImmutable gLCapabilitiesImmutable2 = GLGraphicsConfigurationUtil.fixOffscreenGLCapabilities(gLCapabilitiesImmutable, false, this.canCreateGLPbuffer(abstractGraphicsDevice2));
        abstractGraphicsDevice2.lock();
        try {
            GLDrawableImpl gLDrawableImpl = this.createOffscreenDrawableImpl(this.createMutableSurfaceImpl(abstractGraphicsDevice2, true, gLCapabilitiesImmutable2, gLCapabilitiesImmutable, gLCapabilitiesChooser, n, n2, null));
            return gLDrawableImpl;
        }
        finally {
            abstractGraphicsDevice2.unlock();
        }
    }

    protected GLDrawable createFBODrawableImpl(AbstractGraphicsDevice abstractGraphicsDevice, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser, int n, int n2) {
        GLCapabilitiesImmutable gLCapabilitiesImmutable2 = GLGraphicsConfigurationUtil.fixOnscreenGLCapabilities(gLCapabilitiesImmutable);
        ProxySurface proxySurface = this.createDummySurfaceImpl(abstractGraphicsDevice, true, gLCapabilitiesImmutable2, null, 64, 64);
        GLDrawableImpl gLDrawableImpl = this.createOnscreenDrawableImpl(proxySurface);
        return new GLFBODrawableImpl(this, gLDrawableImpl, proxySurface, n, n2, 0);
    }

    protected abstract GLDrawableImpl createOffscreenDrawableImpl(NativeSurface var1);

    protected abstract ProxySurface createMutableSurfaceImpl(AbstractGraphicsDevice var1, boolean var2, GLCapabilitiesImmutable var3, GLCapabilitiesImmutable var4, GLCapabilitiesChooser var5, int var6, int var7, ProxySurface.UpstreamSurfaceHook var8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NativeSurface createDummySurface(AbstractGraphicsDevice abstractGraphicsDevice, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser, int n, int n2) {
        AbstractGraphicsDevice abstractGraphicsDevice2 = this.getOrCreateSharedDevice(abstractGraphicsDevice);
        if (null == abstractGraphicsDevice2) {
            throw new GLException("No shared device for requested: " + abstractGraphicsDevice);
        }
        abstractGraphicsDevice2.lock();
        try {
            ProxySurface proxySurface = this.createDummySurfaceImpl(abstractGraphicsDevice2, true, gLCapabilitiesImmutable, gLCapabilitiesChooser, n, n2);
            return proxySurface;
        }
        finally {
            abstractGraphicsDevice2.unlock();
        }
    }

    public abstract ProxySurface createDummySurfaceImpl(AbstractGraphicsDevice var1, boolean var2, GLCapabilitiesImmutable var3, GLCapabilitiesChooser var4, int var5, int var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProxySurface createProxySurface(AbstractGraphicsDevice abstractGraphicsDevice, int n, long l, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser, ProxySurface.UpstreamSurfaceHook upstreamSurfaceHook) {
        AbstractGraphicsDevice abstractGraphicsDevice2 = this.getOrCreateSharedDevice(abstractGraphicsDevice);
        if (null == abstractGraphicsDevice2) {
            throw new GLException("No shared device for requested: " + abstractGraphicsDevice);
        }
        if (0L == l) {
            throw new IllegalArgumentException("Null windowHandle");
        }
        abstractGraphicsDevice2.lock();
        try {
            ProxySurface proxySurface = this.createProxySurfaceImpl(abstractGraphicsDevice2, n, l, gLCapabilitiesImmutable, gLCapabilitiesChooser, upstreamSurfaceHook);
            return proxySurface;
        }
        finally {
            abstractGraphicsDevice2.unlock();
        }
    }

    protected abstract ProxySurface createProxySurfaceImpl(AbstractGraphicsDevice var1, int var2, long var3, GLCapabilitiesImmutable var5, GLCapabilitiesChooser var6, ProxySurface.UpstreamSurfaceHook var7);

    protected abstract GLContext createExternalGLContextImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GLContext createExternalGLContext() {
        NativeWindowFactory.getDefaultToolkitLock().lock();
        try {
            GLContext gLContext = this.createExternalGLContextImpl();
            return gLContext;
        }
        finally {
            NativeWindowFactory.getDefaultToolkitLock().unlock();
        }
    }

    protected abstract GLDrawable createExternalGLDrawableImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GLDrawable createExternalGLDrawable() {
        NativeWindowFactory.getDefaultToolkitLock().lock();
        try {
            GLDrawable gLDrawable = this.createExternalGLDrawableImpl();
            return gLDrawable;
        }
        finally {
            NativeWindowFactory.getDefaultToolkitLock().unlock();
        }
    }

    public static GLDrawableFactoryImpl getFactoryImpl(GLProfile gLProfile) {
        return (GLDrawableFactoryImpl)GLDrawableFactoryImpl.getFactory(gLProfile);
    }

    public abstract boolean canCreateContextOnJava2DSurface(AbstractGraphicsDevice var1);

    public abstract GLContext createContextOnJava2DSurface(Object var1, GLContext var2) throws GLException;

    public boolean setDisplayGamma(float f, float f2, float f3) throws IllegalArgumentException {
        if (f2 < -1.0f || f2 > 1.0f) {
            throw new IllegalArgumentException("Brightness must be between -1.0 and 1.0");
        }
        if (f3 < 0.0f) {
            throw new IllegalArgumentException("Contrast must be greater than 0.0");
        }
        int n = this.getGammaRampLength();
        if (n == 0) {
            return false;
        }
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            float f4 = (float)i / (float)(n - 1);
            float f5 = (float)Math.pow(f4, f);
            f5 += f2;
            if ((f5 = (f5 - 0.5f) * f3 + 0.5f) > 1.0f) {
                f5 = 1.0f;
            } else if (f5 < 0.0f) {
                f5 = 0.0f;
            }
            fArray[i] = f5;
        }
        this.registerGammaShutdownHook();
        return this.setGammaRamp(fArray);
    }

    public synchronized void resetDisplayGamma() {
        if (this.gammaShutdownHook == null) {
            throw new IllegalArgumentException("Should not call this unless setDisplayGamma called first");
        }
        this.resetGammaRamp(this.originalGammaRamp);
        this.unregisterGammaShutdownHook();
    }

    protected int getGammaRampLength() {
        return 0;
    }

    protected boolean setGammaRamp(float[] fArray) {
        return false;
    }

    protected Buffer getGammaRamp() {
        return null;
    }

    protected void resetGammaRamp(Buffer buffer) {
    }

    private synchronized void registerGammaShutdownHook() {
        if (this.gammaShutdownHookRegistered) {
            return;
        }
        if (this.gammaShutdownHook == null) {
            this.gammaShutdownHook = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    GLDrawableFactoryImpl gLDrawableFactoryImpl = GLDrawableFactoryImpl.this;
                    synchronized (gLDrawableFactoryImpl) {
                        GLDrawableFactoryImpl.this.resetGammaRamp(GLDrawableFactoryImpl.this.originalGammaRamp);
                    }
                }
            });
            this.originalGammaRamp = this.getGammaRamp();
        }
        Runtime.getRuntime().addShutdownHook(this.gammaShutdownHook);
        this.gammaShutdownHookRegistered = true;
    }

    private synchronized void unregisterGammaShutdownHook() {
        if (!this.gammaShutdownHookRegistered) {
            return;
        }
        if (this.gammaShutdownHook == null) {
            throw new InternalError("Error in gamma shutdown hook logic");
        }
        Runtime.getRuntime().removeShutdownHook(this.gammaShutdownHook);
        this.gammaShutdownHookRegistered = false;
    }
}

