/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import com.jogamp.common.util.LongIntHashMap;
import com.jogamp.nativewindow.egl.EGLGraphicsDevice;
import java.nio.IntBuffer;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.opengl.GLException;
import jogamp.opengl.Debug;
import jogamp.opengl.egl.EGL;
import jogamp.opengl.egl.EGLContext;

public class EGLDisplayUtil {
    protected static final boolean DEBUG = Debug.debug("EGL");
    static LongIntHashMap eglDisplayCounter = new LongIntHashMap();
    public static final EGLGraphicsDevice.EGLDisplayLifecycleCallback eglLifecycleCallback;

    public static long eglGetDisplay(long l) {
        long l2 = EGL.eglGetDisplay(l);
        if (DEBUG) {
            System.err.println("EGLDisplayUtil.eglGetDisplay(): eglDisplay(" + EGLContext.toHexString(l) + "): " + EGLContext.toHexString(l2) + ", " + (0L != l2 ? "OK" : "Failed"));
        }
        return l2;
    }

    public static synchronized boolean eglInitialize(long l, int[] nArray, int n, int[] nArray2, int n2) {
        int n3 = eglDisplayCounter.get(l) + 1;
        boolean bl = 1 == n3 ? EGL.eglInitialize(l, nArray, n, nArray2, n2) : true;
        eglDisplayCounter.put(l, n3);
        if (DEBUG) {
            System.err.println("EGL.eglInitialize(0x" + Long.toHexString(l) + " ...): #" + n3 + " = " + bl);
        }
        return bl;
    }

    public static synchronized boolean eglInitialize(long l, IntBuffer intBuffer, IntBuffer intBuffer2) {
        if (0L == l) {
            return false;
        }
        int n = eglDisplayCounter.get(l) + 1;
        boolean bl = 1 == n ? EGL.eglInitialize(l, intBuffer, intBuffer2) : true;
        eglDisplayCounter.put(l, n);
        if (DEBUG) {
            System.err.println("EGL.eglInitialize(0x" + Long.toHexString(l) + " ...): #" + n + " = " + bl);
        }
        return bl;
    }

    public static synchronized boolean eglTerminate(long l) {
        if (0L == l) {
            return false;
        }
        int n = eglDisplayCounter.get(l) - 1;
        boolean bl = 0 == n ? EGL.eglTerminate(l) : true;
        if (0 <= n) {
            eglDisplayCounter.put(l, n);
        }
        if (DEBUG) {
            System.err.println("EGL.eglTerminate(0x" + Long.toHexString(l) + " ...): #" + n + " = " + bl);
        }
        return bl;
    }

    public static EGLGraphicsDevice eglCreateEGLGraphicsDevice(long l, String string, int n) {
        EGLGraphicsDevice eGLGraphicsDevice = new EGLGraphicsDevice(l, 0L, string, n, eglLifecycleCallback);
        eGLGraphicsDevice.open();
        return eGLGraphicsDevice;
    }

    public static EGLGraphicsDevice eglCreateEGLGraphicsDevice(NativeSurface nativeSurface, boolean bl) {
        long l = "Windows".equals(NativeWindowFactory.getNativeWindowType(false)) ? nativeSurface.getSurfaceHandle() : nativeSurface.getDisplayHandle();
        long l2 = EGLDisplayUtil.eglGetDisplay(l);
        if (l2 == 0L && l != 0L && bl) {
            if (DEBUG) {
                System.err.println("EGLDisplayUtil.eglGetDisplay(): Fall back to EGL_DEFAULT_DISPLAY");
            }
            l = 0L;
            l2 = EGLDisplayUtil.eglGetDisplay(l);
        }
        if (l2 == 0L) {
            throw new GLException("Failed to created EGL display: " + nativeSurface + ", error 0x" + Integer.toHexString(EGL.eglGetError()));
        }
        if (!EGLDisplayUtil.eglInitialize(l2, null, null)) {
            throw new GLException("eglInitialize failed, error 0x" + Integer.toHexString(EGL.eglGetError()));
        }
        AbstractGraphicsDevice abstractGraphicsDevice = nativeSurface.getGraphicsConfiguration().getScreen().getDevice();
        return new EGLGraphicsDevice(l, l2, abstractGraphicsDevice.getConnection(), abstractGraphicsDevice.getUnitID(), eglLifecycleCallback);
    }

    static {
        eglDisplayCounter.setKeyNotFoundValue(0);
        eglLifecycleCallback = new EGLGraphicsDevice.EGLDisplayLifecycleCallback(){

            @Override
            public long eglGetAndInitDisplay(long l) {
                long l2 = EGLDisplayUtil.eglGetDisplay(l);
                if (l2 == 0L) {
                    throw new GLException("Failed to created EGL display: 0x" + Long.toHexString(l) + ", error 0x" + Integer.toHexString(EGL.eglGetError()));
                }
                if (!EGLDisplayUtil.eglInitialize(l2, null, null)) {
                    throw new GLException("eglInitialize failed, error 0x" + Integer.toHexString(EGL.eglGetError()));
                }
                return l2;
            }

            @Override
            public void eglTerminate(long l) {
                EGLDisplayUtil.eglTerminate(l);
            }
        };
    }
}

