/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.nativewindow.MutableGraphicsConfiguration;
import com.jogamp.nativewindow.egl.EGLGraphicsDevice;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.opengl.DefaultGLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import jogamp.opengl.egl.EGL;
import jogamp.opengl.egl.EGLGLCapabilities;

public class EGLGraphicsConfiguration
extends MutableGraphicsConfiguration
implements Cloneable {
    private GLCapabilitiesChooser chooser;

    public final long getNativeConfig() {
        return ((EGLGLCapabilities)this.capabilitiesChosen).getEGLConfig();
    }

    public final int getNativeConfigID() {
        return ((EGLGLCapabilities)this.capabilitiesChosen).getEGLConfigID();
    }

    EGLGraphicsConfiguration(AbstractGraphicsScreen abstractGraphicsScreen, EGLGLCapabilities eGLGLCapabilities, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser) {
        super(abstractGraphicsScreen, eGLGLCapabilities, gLCapabilitiesImmutable);
        this.chooser = gLCapabilitiesChooser;
    }

    public static EGLGraphicsConfiguration create(GLCapabilitiesImmutable gLCapabilitiesImmutable, AbstractGraphicsScreen abstractGraphicsScreen, int n) {
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsScreen.getDevice();
        if (null == abstractGraphicsDevice || !(abstractGraphicsDevice instanceof EGLGraphicsDevice)) {
            throw new GLException("GraphicsDevice must be a valid EGLGraphicsDevice");
        }
        long l = abstractGraphicsDevice.getHandle();
        if (l == 0L) {
            throw new GLException("Invalid EGL display: " + abstractGraphicsDevice);
        }
        long l2 = EGLGraphicsConfiguration.EGLConfigId2EGLConfig(l, n);
        if (0L < l2) {
            EGLGLCapabilities eGLGLCapabilities = EGLGraphicsConfiguration.EGLConfig2Capabilities(gLCapabilitiesImmutable.getGLProfile(), l, l2, false, gLCapabilitiesImmutable.isOnscreen(), gLCapabilitiesImmutable.isPBuffer(), false);
            return new EGLGraphicsConfiguration(abstractGraphicsScreen, eGLGLCapabilities, gLCapabilitiesImmutable, new DefaultGLCapabilitiesChooser());
        }
        return null;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    void updateGraphicsConfiguration() {
        CapabilitiesImmutable capabilitiesImmutable = this.getChosenCapabilities();
        EGLGraphicsConfiguration eGLGraphicsConfiguration = (EGLGraphicsConfiguration)GraphicsConfigurationFactory.getFactory(this.getScreen().getDevice(), capabilitiesImmutable).chooseGraphicsConfiguration(capabilitiesImmutable, this.getRequestedCapabilities(), this.chooser, this.getScreen(), 0);
        if (null != eGLGraphicsConfiguration) {
            this.setChosenCapabilities(eGLGraphicsConfiguration.getChosenCapabilities());
            if (DEBUG) {
                System.err.println("updateGraphicsConfiguration(1): " + this);
            }
        }
    }

    public static long EGLConfigId2EGLConfig(long l, int n) {
        int[] nArray;
        int[] nArray2 = new int[]{12328, n, 12344};
        PointerBuffer pointerBuffer = PointerBuffer.allocateDirect((int)1);
        if (!EGL.eglChooseConfig(l, nArray2, 0, pointerBuffer, 1, nArray = new int[1], 0)) {
            return 0L;
        }
        if (nArray[0] == 0) {
            return 0L;
        }
        return pointerBuffer.get(0);
    }

    static int EGLConfigDrawableTypeBits(long l, long l2) {
        int n = 0;
        int[] nArray = new int[1];
        if (!EGL.eglGetConfigAttrib(l, l2, 12339, nArray, 0)) {
            throw new GLException("Could not determine EGL_SURFACE_TYPE");
        }
        if (0 != (nArray[0] & 4)) {
            n |= 1;
        }
        if (0 != (nArray[0] & 2)) {
            n |= 2;
        }
        if (0 != (nArray[0] & 1)) {
            n |= 4;
        }
        return n;
    }

    public static EGLGLCapabilities EGLConfig2Capabilities(GLProfile gLProfile, long l, long l2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        ArrayList<GLCapabilitiesImmutable> arrayList = new ArrayList<GLCapabilitiesImmutable>();
        int n = GLGraphicsConfigurationUtil.getWinAttributeBits(bl2, bl3, false);
        if (EGLGraphicsConfiguration.EGLConfig2Capabilities(arrayList, gLProfile, l, l2, n, bl4)) {
            return (EGLGLCapabilities)arrayList.get(0);
        }
        if (bl && EGLGraphicsConfiguration.EGLConfig2Capabilities(arrayList, gLProfile, l, l2, 15, bl4)) {
            return (EGLGLCapabilities)arrayList.get(0);
        }
        return null;
    }

    public static boolean EGLConfig2Capabilities(List<GLCapabilitiesImmutable> list, GLProfile gLProfile, long l, long l2, int n, boolean bl) {
        int n2 = EGLGraphicsConfiguration.EGLConfigDrawableTypeBits(l, l2);
        int n3 = n & n2;
        if (0 == n3) {
            return false;
        }
        IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)1);
        if (!EGL.eglGetConfigAttrib(l, l2, 12328, intBuffer)) {
            if (DEBUG) {
                System.err.println("EGL couldn't retrieve ConfigID for config " + EGLGraphicsConfiguration.toHexString(l2) + ", error " + EGLGraphicsConfiguration.toHexString(EGL.eglGetError()));
            }
            return false;
        }
        int n4 = intBuffer.get(0);
        if (!EGL.eglGetConfigAttrib(l, l2, 12352, intBuffer)) {
            if (DEBUG) {
                System.err.println("EGL couldn't retrieve EGL_RENDERABLE_TYPE for config " + EGLGraphicsConfiguration.toHexString(l2) + ", error " + EGLGraphicsConfiguration.toHexString(EGL.eglGetError()));
            }
            return false;
        }
        int n5 = intBuffer.get(0);
        int n6 = EGL.eglGetConfigAttrib(l, l2, 12334, intBuffer) ? intBuffer.get(0) : 0;
        EGLGLCapabilities eGLGLCapabilities = null;
        try {
            eGLGLCapabilities = new EGLGLCapabilities(l2, n4, n6, gLProfile, n5);
        }
        catch (GLException gLException) {
            if (DEBUG) {
                System.err.println("config " + EGLGraphicsConfiguration.toHexString(l2) + ": " + gLException);
            }
            return false;
        }
        if (EGL.eglGetConfigAttrib(l, l2, 12337, intBuffer)) {
            eGLGLCapabilities.setSampleBuffers(intBuffer.get(0) > 0);
            eGLGLCapabilities.setNumSamples(intBuffer.get(0));
        }
        if (!eGLGLCapabilities.getSampleBuffers() && EGL.eglGetConfigAttrib(l, l2, 12512, intBuffer) && intBuffer.get(0) > 0 && EGL.eglGetConfigAttrib(l, l2, 12513, intBuffer)) {
            eGLGLCapabilities.setSampleExtension("NV_coverage_sample");
            eGLGLCapabilities.setSampleBuffers(true);
            eGLGLCapabilities.setNumSamples(intBuffer.get(0));
        }
        if (bl) {
            eGLGLCapabilities.setBackgroundOpaque(false);
        } else if (EGL.eglGetConfigAttrib(l, l2, 12340, intBuffer)) {
            eGLGLCapabilities.setBackgroundOpaque(intBuffer.get(0) != 12370);
        }
        if (!eGLGLCapabilities.isBackgroundOpaque()) {
            if (EGL.eglGetConfigAttrib(l, l2, 12343, intBuffer)) {
                eGLGLCapabilities.setTransparentRedValue(intBuffer.get(0) == -1 ? -1 : intBuffer.get(0));
            }
            if (EGL.eglGetConfigAttrib(l, l2, 12342, intBuffer)) {
                eGLGLCapabilities.setTransparentGreenValue(intBuffer.get(0) == -1 ? -1 : intBuffer.get(0));
            }
            if (EGL.eglGetConfigAttrib(l, l2, 12341, intBuffer)) {
                eGLGLCapabilities.setTransparentBlueValue(intBuffer.get(0) == -1 ? -1 : intBuffer.get(0));
            }
        }
        if (EGL.eglGetConfigAttrib(l, l2, 12324, intBuffer)) {
            eGLGLCapabilities.setRedBits(intBuffer.get(0));
        }
        if (EGL.eglGetConfigAttrib(l, l2, 12323, intBuffer)) {
            eGLGLCapabilities.setGreenBits(intBuffer.get(0));
        }
        if (EGL.eglGetConfigAttrib(l, l2, 12322, intBuffer)) {
            eGLGLCapabilities.setBlueBits(intBuffer.get(0));
        }
        if (EGL.eglGetConfigAttrib(l, l2, 12321, intBuffer)) {
            eGLGLCapabilities.setAlphaBits(intBuffer.get(0));
        }
        if (EGL.eglGetConfigAttrib(l, l2, 12326, intBuffer)) {
            eGLGLCapabilities.setStencilBits(intBuffer.get(0));
        }
        if (EGL.eglGetConfigAttrib(l, l2, 12325, intBuffer)) {
            eGLGLCapabilities.setDepthBits(intBuffer.get(0));
        }
        return GLGraphicsConfigurationUtil.addGLCapabilitiesPermutations(list, eGLGLCapabilities, n3);
    }

    public static int[] GLCapabilities2AttribList(GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        int[] nArray = new int[32];
        int n = 0;
        nArray[n++] = 12339;
        nArray[n++] = gLCapabilitiesImmutable.isOnscreen() ? 4 : (gLCapabilitiesImmutable.isPBuffer() ? 1 : 2);
        nArray[n++] = 12324;
        nArray[n++] = gLCapabilitiesImmutable.getRedBits();
        nArray[n++] = 12323;
        nArray[n++] = gLCapabilitiesImmutable.getGreenBits();
        nArray[n++] = 12322;
        nArray[n++] = gLCapabilitiesImmutable.getBlueBits();
        if (gLCapabilitiesImmutable.getAlphaBits() > 0) {
            nArray[n++] = 12321;
            nArray[n++] = gLCapabilitiesImmutable.getAlphaBits();
        }
        if (gLCapabilitiesImmutable.getStencilBits() > 0) {
            nArray[n++] = 12326;
            nArray[n++] = gLCapabilitiesImmutable.getStencilBits();
        }
        nArray[n++] = 12325;
        nArray[n++] = gLCapabilitiesImmutable.getDepthBits();
        if (gLCapabilitiesImmutable.getSampleBuffers()) {
            if (gLCapabilitiesImmutable.getSampleExtension().equals("NV_coverage_sample")) {
                nArray[n++] = 12512;
                nArray[n++] = 1;
                nArray[n++] = 12513;
                nArray[n++] = gLCapabilitiesImmutable.getNumSamples();
            } else {
                nArray[n++] = 12338;
                nArray[n++] = 1;
                nArray[n++] = 12337;
                nArray[n++] = gLCapabilitiesImmutable.getNumSamples();
            }
        }
        nArray[n++] = 12340;
        int n2 = nArray[n++] = gLCapabilitiesImmutable.isBackgroundOpaque() ? 12344 : 12340;
        if (!gLCapabilitiesImmutable.isBackgroundOpaque()) {
            nArray[n++] = 12343;
            nArray[n++] = gLCapabilitiesImmutable.getTransparentRedValue() >= 0 ? gLCapabilitiesImmutable.getTransparentRedValue() : -1;
            nArray[n++] = 12342;
            nArray[n++] = gLCapabilitiesImmutable.getTransparentGreenValue() >= 0 ? gLCapabilitiesImmutable.getTransparentGreenValue() : -1;
            nArray[n++] = 12341;
            nArray[n++] = gLCapabilitiesImmutable.getTransparentBlueValue() >= 0 ? gLCapabilitiesImmutable.getTransparentBlueValue() : -1;
        }
        nArray[n++] = 12352;
        nArray[n++] = gLCapabilitiesImmutable.getGLProfile().usesNativeGLES1() ? 1 : (gLCapabilitiesImmutable.getGLProfile().usesNativeGLES2() ? 4 : 8);
        nArray[n++] = 12344;
        return nArray;
    }

    public static int[] CreatePBufferSurfaceAttribList(int n, int n2, int n3) {
        int[] nArray = new int[16];
        int n4 = 0;
        nArray[n4++] = 12375;
        nArray[n4++] = n;
        nArray[n4++] = 12374;
        nArray[n4++] = n2;
        nArray[n4++] = 12416;
        nArray[n4++] = n3;
        nArray[n4++] = 12417;
        nArray[n4++] = 12380 == n3 ? 12380 : 12383;
        nArray[n4++] = 12344;
        return nArray;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getScreen() + ",\n\teglConfigHandle " + EGLGraphicsConfiguration.toHexString(this.getNativeConfig()) + ", eglConfigID " + EGLGraphicsConfiguration.toHexString(this.getNativeConfigID()) + ",\n\trequested " + this.getRequestedCapabilities() + ",\n\tchosen    " + this.getChosenCapabilities() + "]";
    }
}

