/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.x11.glx;

import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.nativewindow.x11.X11GraphicsDevice;
import com.jogamp.nativewindow.x11.X11GraphicsScreen;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.CapabilitiesChooser;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.VisualIDHolder;
import javax.media.opengl.DefaultGLCapabilitiesChooser;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.nativewindow.x11.X11Lib;
import jogamp.nativewindow.x11.XVisualInfo;
import jogamp.opengl.GLGraphicsConfigurationFactory;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import jogamp.opengl.x11.glx.GLX;
import jogamp.opengl.x11.glx.GLXUtil;
import jogamp.opengl.x11.glx.X11GLCapabilities;
import jogamp.opengl.x11.glx.X11GLXDrawable;
import jogamp.opengl.x11.glx.X11GLXDrawableFactory;
import jogamp.opengl.x11.glx.X11GLXGraphicsConfiguration;

public class X11GLXGraphicsConfigurationFactory
extends GLGraphicsConfigurationFactory {
    static VisualIDHolder.VIDComparator XVisualIDComparator = new VisualIDHolder.VIDComparator(VisualIDHolder.VIDType.X11_XVISUAL);
    static GraphicsConfigurationFactory fallbackX11GraphicsConfigurationFactory = null;

    static void registerFactory() {
        X11GLXGraphicsConfigurationFactory x11GLXGraphicsConfigurationFactory = new X11GLXGraphicsConfigurationFactory();
        GraphicsConfigurationFactory graphicsConfigurationFactory = GraphicsConfigurationFactory.registerFactory(X11GraphicsDevice.class, GLCapabilitiesImmutable.class, x11GLXGraphicsConfigurationFactory);
        if (graphicsConfigurationFactory == x11GLXGraphicsConfigurationFactory) {
            throw new InternalError("GraphicsConfigurationFactory lifecycle impl. error");
        }
        if (null != graphicsConfigurationFactory) {
            fallbackX11GraphicsConfigurationFactory = graphicsConfigurationFactory;
        } else {
            fallbackX11GraphicsConfigurationFactory = GraphicsConfigurationFactory.getFactory(X11GraphicsDevice.class, CapabilitiesImmutable.class);
            if (null == fallbackX11GraphicsConfigurationFactory) {
                throw new InternalError("Missing fallback GraphicsConfigurationFactory");
            }
        }
    }

    private X11GLXGraphicsConfigurationFactory() {
    }

    @Override
    protected AbstractGraphicsConfiguration chooseGraphicsConfigurationImpl(CapabilitiesImmutable capabilitiesImmutable, CapabilitiesImmutable capabilitiesImmutable2, CapabilitiesChooser capabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen, int n) {
        if (!(abstractGraphicsScreen instanceof X11GraphicsScreen)) {
            throw new IllegalArgumentException("Only X11GraphicsScreen are allowed here");
        }
        if (!(capabilitiesImmutable instanceof GLCapabilitiesImmutable)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilities objects - chosen");
        }
        if (!(capabilitiesImmutable2 instanceof GLCapabilitiesImmutable)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilities objects - requested");
        }
        if (capabilitiesChooser != null && !(capabilitiesChooser instanceof GLCapabilitiesChooser)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilitiesChooser objects");
        }
        if (!GLXUtil.isGLXAvailableOnServer((X11GraphicsDevice)abstractGraphicsScreen.getDevice())) {
            if (null != fallbackX11GraphicsConfigurationFactory) {
                if (DEBUG) {
                    System.err.println("No GLX available, fallback to " + fallbackX11GraphicsConfigurationFactory.getClass().getSimpleName() + " for: " + abstractGraphicsScreen);
                }
                return fallbackX11GraphicsConfigurationFactory.chooseGraphicsConfiguration(capabilitiesImmutable, capabilitiesImmutable2, capabilitiesChooser, abstractGraphicsScreen, 0);
            }
            throw new InternalError("No GLX and no fallback GraphicsConfigurationFactory available for: " + abstractGraphicsScreen);
        }
        return X11GLXGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic((GLCapabilitiesImmutable)capabilitiesImmutable, (GLCapabilitiesImmutable)capabilitiesImmutable2, (GLCapabilitiesChooser)capabilitiesChooser, (X11GraphicsScreen)abstractGraphicsScreen, n);
    }

    protected static List<GLCapabilitiesImmutable> getAvailableCapabilities(X11GLXDrawableFactory x11GLXDrawableFactory, AbstractGraphicsDevice abstractGraphicsDevice) {
        X11GLXDrawableFactory.SharedResource sharedResource = x11GLXDrawableFactory.getOrCreateSharedResource(abstractGraphicsDevice);
        if (null == sharedResource) {
            throw new GLException("Shared resource for device n/a: " + abstractGraphicsDevice);
        }
        X11GraphicsScreen x11GraphicsScreen = (X11GraphicsScreen)sharedResource.getScreen();
        boolean bl = x11GLXDrawableFactory.isGLXMultisampleAvailable(x11GraphicsScreen.getDevice());
        X11GLXDrawable x11GLXDrawable = (X11GLXDrawable)sharedResource.getDrawable();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = x11GLXDrawable.getChosenGLCapabilities();
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        List<GLCapabilitiesImmutable> list = null;
        if (sharedResource.isGLXVersionGreaterEqualOneThree()) {
            list = X11GLXGraphicsConfigurationFactory.getAvailableGLCapabilitiesFBConfig(x11GraphicsScreen, gLProfile, bl);
        }
        if (null == list || list.isEmpty()) {
            list = X11GLXGraphicsConfigurationFactory.getAvailableGLCapabilitiesXVisual(x11GraphicsScreen, gLProfile, bl);
        }
        if (null != list && list.size() > 1) {
            Collections.sort(list, XVisualIDComparator);
        }
        return list;
    }

    static List<GLCapabilitiesImmutable> getAvailableGLCapabilitiesFBConfig(X11GraphicsScreen x11GraphicsScreen, GLProfile gLProfile, boolean bl) {
        PointerBuffer pointerBuffer = null;
        AbstractGraphicsDevice abstractGraphicsDevice = x11GraphicsScreen.getDevice();
        long l = abstractGraphicsDevice.getHandle();
        int n = x11GraphicsScreen.getIndex();
        int[] nArray = new int[]{-1};
        ArrayList<GLCapabilitiesImmutable> arrayList = new ArrayList<GLCapabilitiesImmutable>();
        pointerBuffer = GLX.glXChooseFBConfig(l, n, null, 0, nArray, 0);
        if (pointerBuffer == null || pointerBuffer.limit() <= 0) {
            if (DEBUG) {
                System.err.println("X11GLXGraphicsConfiguration.getAvailableGLCapabilitiesFBConfig: Failed glXChooseFBConfig (" + x11GraphicsScreen + "): " + pointerBuffer + ", " + nArray[0]);
            }
            return null;
        }
        for (int i = 0; i < pointerBuffer.limit(); ++i) {
            if (X11GLXGraphicsConfiguration.GLXFBConfig2GLCapabilities(arrayList, gLProfile, abstractGraphicsDevice, pointerBuffer.get(i), 15, bl) || !DEBUG) continue;
            System.err.println("X11GLXGraphicsConfiguration.getAvailableGLCapabilitiesFBConfig: FBConfig invalid (2): (" + x11GraphicsScreen + "): fbcfg: " + X11GLXGraphicsConfigurationFactory.toHexString(pointerBuffer.get(i)));
        }
        return arrayList;
    }

    static List<GLCapabilitiesImmutable> getAvailableGLCapabilitiesXVisual(X11GraphicsScreen x11GraphicsScreen, GLProfile gLProfile, boolean bl) {
        AbstractGraphicsDevice abstractGraphicsDevice = x11GraphicsScreen.getDevice();
        long l = abstractGraphicsDevice.getHandle();
        int n = x11GraphicsScreen.getIndex();
        int[] nArray = new int[1];
        XVisualInfo xVisualInfo = XVisualInfo.create();
        xVisualInfo.setScreen(n);
        XVisualInfo[] xVisualInfoArray = X11Lib.XGetVisualInfo(l, 2L, xVisualInfo, nArray, 0);
        if (xVisualInfoArray == null || xVisualInfoArray.length < 1) {
            throw new GLException("Error while enumerating available XVisualInfos");
        }
        ArrayList<GLCapabilitiesImmutable> arrayList = new ArrayList<GLCapabilitiesImmutable>();
        for (int i = 0; i < xVisualInfoArray.length; ++i) {
            if (X11GLXGraphicsConfiguration.XVisualInfo2GLCapabilities(arrayList, gLProfile, l, xVisualInfoArray[i], 15, bl) || !DEBUG) continue;
            System.err.println("X11GLXGraphicsConfiguration.getAvailableGLCapabilitiesXVisual: XVisual invalid: (" + x11GraphicsScreen + "): fbcfg: " + X11GLXGraphicsConfigurationFactory.toHexString(xVisualInfoArray[i].getVisualid()));
        }
        return arrayList;
    }

    static X11GLXGraphicsConfiguration chooseGraphicsConfigurationStatic(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, X11GraphicsScreen x11GraphicsScreen, int n) {
        if (x11GraphicsScreen == null) {
            throw new IllegalArgumentException("AbstractGraphicsScreen is null");
        }
        if (gLCapabilitiesImmutable == null) {
            gLCapabilitiesImmutable = new GLCapabilities(null);
        }
        X11GraphicsDevice x11GraphicsDevice = (X11GraphicsDevice)x11GraphicsScreen.getDevice();
        X11GLXDrawableFactory x11GLXDrawableFactory = (X11GLXDrawableFactory)GLDrawableFactory.getDesktopFactory();
        gLCapabilitiesImmutable = GLGraphicsConfigurationUtil.fixGLCapabilities(gLCapabilitiesImmutable, GLContext.isFBOAvailable(x11GraphicsDevice, gLCapabilitiesImmutable.getGLProfile()), x11GLXDrawableFactory.canCreateGLPbuffer(x11GraphicsDevice));
        boolean bl = gLCapabilitiesImmutable.isPBuffer();
        X11GLXGraphicsConfiguration x11GLXGraphicsConfiguration = null;
        if (x11GLXDrawableFactory.isGLXVersionGreaterEqualOneThree(x11GraphicsDevice)) {
            x11GLXGraphicsConfiguration = X11GLXGraphicsConfigurationFactory.chooseGraphicsConfigurationFBConfig(gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, x11GraphicsScreen, n);
        }
        if (null == x11GLXGraphicsConfiguration) {
            if (bl) {
                throw new GLException("Error: Couldn't create X11GLXGraphicsConfiguration based on FBConfig for visualID " + X11GLXGraphicsConfigurationFactory.toHexString(n) + ", " + gLCapabilitiesImmutable);
            }
            x11GLXGraphicsConfiguration = X11GLXGraphicsConfigurationFactory.chooseGraphicsConfigurationXVisual(gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, x11GraphicsScreen, n);
        }
        if (null == x11GLXGraphicsConfiguration) {
            throw new GLException("Error: Couldn't create X11GLXGraphicsConfiguration based on FBConfig and XVisual for visualID " + X11GLXGraphicsConfigurationFactory.toHexString(n) + ", " + x11GraphicsScreen + ", " + gLCapabilitiesImmutable);
        }
        if (DEBUG) {
            System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationStatic(visualID " + X11GLXGraphicsConfigurationFactory.toHexString(n) + ", " + x11GraphicsScreen + "," + gLCapabilitiesImmutable + "): " + x11GLXGraphicsConfiguration);
        }
        return x11GLXGraphicsConfiguration;
    }

    static X11GLXGraphicsConfiguration fetchGraphicsConfigurationFBConfig(X11GraphicsScreen x11GraphicsScreen, int n, GLProfile gLProfile) {
        int n2;
        AbstractGraphicsDevice abstractGraphicsDevice = x11GraphicsScreen.getDevice();
        long l = abstractGraphicsDevice.getHandle();
        long l2 = X11GLXGraphicsConfiguration.glXFBConfigID2FBConfig(l, n2 = x11GraphicsScreen.getIndex(), n);
        if (0L == l2 || !X11GLXGraphicsConfiguration.GLXFBConfigValid(l, l2)) {
            if (DEBUG) {
                System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationFBConfig: Failed - GLX FBConfig invalid: (" + x11GraphicsScreen + "," + X11GLXGraphicsConfigurationFactory.toHexString(n) + "): fbcfg: " + X11GLXGraphicsConfigurationFactory.toHexString(l2));
            }
            return null;
        }
        X11GLXDrawableFactory x11GLXDrawableFactory = (X11GLXDrawableFactory)GLDrawableFactory.getDesktopFactory();
        X11GLCapabilities x11GLCapabilities = X11GLXGraphicsConfiguration.GLXFBConfig2GLCapabilities(gLProfile, abstractGraphicsDevice, l2, true, true, true, x11GLXDrawableFactory.isGLXMultisampleAvailable(abstractGraphicsDevice));
        return new X11GLXGraphicsConfiguration(x11GraphicsScreen, x11GLCapabilities, x11GLCapabilities, new DefaultGLCapabilitiesChooser());
    }

    private static X11GLXGraphicsConfiguration chooseGraphicsConfigurationFBConfig(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, X11GraphicsScreen x11GraphicsScreen, int n) {
        VisualIDHolder visualIDHolder;
        int n2;
        int n3 = -1;
        PointerBuffer pointerBuffer = null;
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        boolean bl = gLCapabilitiesImmutable.isOnscreen();
        boolean bl2 = gLCapabilitiesImmutable.isPBuffer();
        boolean bl3 = gLCapabilitiesImmutable.isFBO();
        AbstractGraphicsDevice abstractGraphicsDevice = x11GraphicsScreen.getDevice();
        long l = abstractGraphicsDevice.getHandle();
        int n4 = x11GraphicsScreen.getIndex();
        X11GLXDrawableFactory x11GLXDrawableFactory = (X11GLXDrawableFactory)GLDrawableFactory.getDesktopFactory();
        boolean bl4 = x11GLXDrawableFactory.isGLXMultisampleAvailable(abstractGraphicsDevice);
        int[] nArray = X11GLXGraphicsConfiguration.GLCapabilities2AttribList(gLCapabilitiesImmutable, true, bl4, l, n4);
        int[] nArray2 = new int[]{-1};
        ArrayList<GLCapabilitiesImmutable> arrayList = new ArrayList<GLCapabilitiesImmutable>();
        int n5 = GLGraphicsConfigurationUtil.getWinAttributeBits(bl, bl2, bl3);
        if (0 == n) {
            pointerBuffer = GLX.glXChooseFBConfig(l, n4, nArray, 0, nArray2, 0);
        }
        if (pointerBuffer != null && pointerBuffer.limit() > 0) {
            for (n2 = 0; n2 < pointerBuffer.limit(); ++n2) {
                if (X11GLXGraphicsConfiguration.GLXFBConfig2GLCapabilities(arrayList, gLProfile, abstractGraphicsDevice, pointerBuffer.get(n2), n5, bl4) || !DEBUG) continue;
                System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationFBConfig: FBConfig invalid (1): (" + x11GraphicsScreen + "," + gLCapabilitiesImmutable + "): fbcfg: " + X11GLXGraphicsConfigurationFactory.toHexString(pointerBuffer.get(n2)));
            }
            if (arrayList.size() > 0) {
                int n6 = n3 = gLCapabilitiesImmutable.isBackgroundOpaque() ? 0 : -1;
                if (DEBUG) {
                    System.err.println("glXChooseFBConfig recommended fbcfg " + X11GLXGraphicsConfigurationFactory.toHexString(pointerBuffer.get(0)) + ", idx " + n3);
                    System.err.println("user  caps " + gLCapabilitiesImmutable);
                    System.err.println("fbcfg caps " + arrayList.get(0));
                }
            } else if (DEBUG) {
                System.err.println("glXChooseFBConfig no caps for recommended fbcfg " + X11GLXGraphicsConfigurationFactory.toHexString(pointerBuffer.get(0)));
                System.err.println("user  caps " + gLCapabilitiesImmutable);
            }
        }
        if (0 == arrayList.size()) {
            n3 = -1;
            pointerBuffer = GLX.glXChooseFBConfig(l, n4, null, 0, nArray2, 0);
            if (pointerBuffer == null || pointerBuffer.limit() <= 0) {
                if (DEBUG) {
                    System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationFBConfig: Failed glXChooseFBConfig (" + x11GraphicsScreen + "," + gLCapabilitiesImmutable + "): " + pointerBuffer + ", " + nArray2[0]);
                }
                return null;
            }
            for (n2 = 0; n2 < pointerBuffer.limit(); ++n2) {
                if (X11GLXGraphicsConfiguration.GLXFBConfig2GLCapabilities(arrayList, gLProfile, abstractGraphicsDevice, pointerBuffer.get(n2), n5, bl4) || !DEBUG) continue;
                System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationFBConfig: FBConfig invalid (2): (" + x11GraphicsScreen + "): fbcfg: " + X11GLXGraphicsConfigurationFactory.toHexString(pointerBuffer.get(n2)));
            }
        }
        if (DEBUG) {
            System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationFBConfig: got configs: " + arrayList.size());
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                System.err.println(n2 + ": " + arrayList.get(n2));
            }
        }
        if (0 != n) {
            n2 = 0;
            while (n2 < arrayList.size()) {
                visualIDHolder = (VisualIDHolder)arrayList.get(n2);
                if (visualIDHolder.getVisualID(VisualIDHolder.VIDType.X11_XVISUAL) != n) {
                    arrayList.remove(n2);
                    continue;
                }
                ++n2;
            }
            if (0 == arrayList.size()) {
                if (DEBUG) {
                    System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationFBConfig: post filter visualID " + X11GLXGraphicsConfigurationFactory.toHexString(n) + " no config found, failed - return null");
                }
                return null;
            }
            if (DEBUG) {
                System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationFBConfig: post filter visualID " + X11GLXGraphicsConfigurationFactory.toHexString(n) + " got configs: " + arrayList.size());
            }
        }
        if (0 > (n2 = X11GLXGraphicsConfigurationFactory.chooseCapabilities(gLCapabilitiesChooser, gLCapabilitiesImmutable, arrayList, n3))) {
            if (DEBUG) {
                System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationFBConfig: failed, return null");
                Thread.dumpStack();
            }
            return null;
        }
        visualIDHolder = (X11GLCapabilities)arrayList.get(n2);
        return new X11GLXGraphicsConfiguration(x11GraphicsScreen, (X11GLCapabilities)visualIDHolder, gLCapabilitiesImmutable2, gLCapabilitiesChooser);
    }

    private static X11GLXGraphicsConfiguration chooseGraphicsConfigurationXVisual(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, X11GraphicsScreen x11GraphicsScreen, int n) {
        VisualIDHolder visualIDHolder;
        int n2;
        if (gLCapabilitiesChooser == null) {
            gLCapabilitiesChooser = new DefaultGLCapabilitiesChooser();
        }
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        int n3 = GLGraphicsConfigurationUtil.getWinAttributeBits(gLCapabilitiesImmutable.isOnscreen(), false, false);
        ArrayList<GLCapabilitiesImmutable> arrayList = new ArrayList<GLCapabilitiesImmutable>();
        int n4 = -1;
        AbstractGraphicsDevice abstractGraphicsDevice = x11GraphicsScreen.getDevice();
        long l = abstractGraphicsDevice.getHandle();
        int n5 = x11GraphicsScreen.getIndex();
        X11GLXDrawableFactory x11GLXDrawableFactory = (X11GLXDrawableFactory)GLDrawableFactory.getDesktopFactory();
        boolean bl = x11GLXDrawableFactory.isGLXMultisampleAvailable(abstractGraphicsDevice);
        int[] nArray = X11GLXGraphicsConfiguration.GLCapabilities2AttribList(gLCapabilitiesImmutable, false, bl, l, n5);
        XVisualInfo xVisualInfo = null;
        if (0 == n) {
            xVisualInfo = GLX.glXChooseVisual(l, n5, nArray, 0);
            if (DEBUG) {
                System.err.print("glXChooseVisual recommended ");
                if (xVisualInfo == null) {
                    System.err.println("null visual");
                } else {
                    System.err.println("visual id " + X11GLXGraphicsConfigurationFactory.toHexString(xVisualInfo.getVisualid()));
                }
            }
        }
        int[] nArray2 = new int[1];
        XVisualInfo xVisualInfo2 = XVisualInfo.create();
        xVisualInfo2.setScreen(n5);
        XVisualInfo[] xVisualInfoArray = X11Lib.XGetVisualInfo(l, 2L, xVisualInfo2, nArray2, 0);
        if (xVisualInfoArray == null || xVisualInfoArray.length < 1) {
            throw new GLException("Error while enumerating available XVisualInfos");
        }
        for (n2 = 0; n2 < xVisualInfoArray.length; ++n2) {
            if (!X11GLXGraphicsConfiguration.XVisualInfo2GLCapabilities(arrayList, gLProfile, l, xVisualInfoArray[n2], n3, bl)) {
                if (!DEBUG) continue;
                System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationXVisual: XVisual invalid: (" + x11GraphicsScreen + "): fbcfg: " + X11GLXGraphicsConfigurationFactory.toHexString(xVisualInfoArray[n2].getVisualid()));
                continue;
            }
            if (!gLCapabilitiesImmutable.isBackgroundOpaque() || xVisualInfo == null || xVisualInfo.getVisualid() != xVisualInfoArray[n2].getVisualid()) continue;
            n4 = arrayList.size() - 1;
        }
        if (DEBUG) {
            System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationXVisual: got configs: " + arrayList.size());
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                System.err.println(n2 + ": " + arrayList.get(n2));
            }
        }
        if (0 != n) {
            n2 = 0;
            while (n2 < arrayList.size()) {
                visualIDHolder = (VisualIDHolder)arrayList.get(n2);
                if (visualIDHolder.getVisualID(VisualIDHolder.VIDType.X11_XVISUAL) != n) {
                    arrayList.remove(n2);
                    continue;
                }
                ++n2;
            }
            if (0 == arrayList.size()) {
                if (DEBUG) {
                    System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationXVisual: post filter visualID " + X11GLXGraphicsConfigurationFactory.toHexString(n) + " no config found, failed - return null");
                }
                return null;
            }
            if (DEBUG) {
                System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationXVisual: post filter visualID " + X11GLXGraphicsConfigurationFactory.toHexString(n) + " got configs: " + arrayList.size());
            }
        }
        if (0 > (n2 = X11GLXGraphicsConfigurationFactory.chooseCapabilities(gLCapabilitiesChooser, gLCapabilitiesImmutable, arrayList, n4))) {
            if (DEBUG) {
                System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationXVisual: failed, return null");
                Thread.dumpStack();
            }
            return null;
        }
        visualIDHolder = (X11GLCapabilities)arrayList.get(n2);
        return new X11GLXGraphicsConfiguration(x11GraphicsScreen, (X11GLCapabilities)visualIDHolder, gLCapabilitiesImmutable2, gLCapabilitiesChooser);
    }
}

