/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.seisserv;

import edu.geophys.commons.themes.ThemeManager;
import edu.geophys.commons.ui.AbstractConfiguration;
import edu.geophys.commons.ui.ScreenDimensionTool;
import edu.geophys.commons.util.JAXBSerializable;
import edu.geophys.commons.util.JAXBUtil;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.commons.util.PlatformUtil;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement(name="SeisServ")
public class SeisServConfiguration
extends AbstractConfiguration
implements JAXBSerializable {
    private static final long serialVersionUID = -2822685813931682662L;
    public static String DEFAULT_CONFIGFILE = PlatformUtil.getApplicationConfPath((String)"seisserv") + File.separator + "seisserv.xml";
    public static final int NUM_RECENT_HEADERS = 6;
    private File lastOpenedHeader = new File(PlatformUtil.getApplicationDir() + File.separator + "ExampleData" + File.separator + "BaselDemo" + File.separator + "header.fhd");
    private boolean lastHeaderAutoload = true;
    private boolean hypolineAutostart = false;
    private boolean googleearthAutostart = true;
    private File googleearthFile = new File("");
    private AbstractConfiguration.FrameSize seisServFrameSize;
    private AbstractConfiguration.FramePosition seisServFramePosition;
    private boolean showErrors = true;
    private String dbAddress = "172.27.67.168";
    private int dbPort = 5432;
    private String dbSid = "geotool";
    private String dbUser = "geotool";
    private String dbPassword = "osi";
    private long dbStartDate = 946684800L;
    private long dbEndDate = 1577836800L;
    private List<String> dbCampaigns = new ArrayList<String>();
    private List<String> dbSNS = new ArrayList<String>();
    private List<String> dbSingleStations = new ArrayList<String>();
    private DATA_SOURCE dataSource = DATA_SOURCE.HEADER;
    private File[] headerHistory = new File[0];
    private String dbProtUser = "";
    private List<String> allDbProtUsers = new ArrayList<String>();
    private boolean debugMode = false;
    private boolean dbPostgres = true;
    private long dataChangeSimulationPause = -1L;
    private ThemeManager.ThemeMode theme = ThemeManager.ThemeMode.DARK;

    public SeisServConfiguration() {
        ScreenDimensionTool screenDimensionTool = ScreenDimensionTool.getInstance();
        this.seisServFrameSize = screenDimensionTool.getSeisServSize();
        this.seisServFramePosition = screenDimensionTool.getSeisServPosition();
    }

    private final void shallowCopyFrom(SeisServConfiguration seisServConfiguration) {
        this.lastHeaderAutoload = seisServConfiguration.lastHeaderAutoload;
        this.hypolineAutostart = seisServConfiguration.hypolineAutostart;
        this.googleearthAutostart = seisServConfiguration.googleearthAutostart;
        this.googleearthFile = seisServConfiguration.googleearthFile;
        this.lastOpenedHeader = seisServConfiguration.lastOpenedHeader;
        this.seisServFrameSize = seisServConfiguration.seisServFrameSize;
        this.seisServFramePosition = seisServConfiguration.seisServFramePosition;
        this.showErrors = seisServConfiguration.showErrors;
        this.dbAddress = seisServConfiguration.dbAddress;
        this.dbPort = seisServConfiguration.dbPort;
        this.dbSid = seisServConfiguration.dbSid;
        this.dbUser = seisServConfiguration.dbUser;
        this.dbPassword = seisServConfiguration.dbPassword;
        this.dbStartDate = seisServConfiguration.dbStartDate;
        this.dbEndDate = seisServConfiguration.dbEndDate;
        this.dbCampaigns = seisServConfiguration.getDbCampaigns();
        this.dbSNS = seisServConfiguration.getDbSNS();
        this.dbSingleStations = seisServConfiguration.dbSingleStations;
        this.dataSource = seisServConfiguration.dataSource;
        this.headerHistory = seisServConfiguration.headerHistory;
        this.dbProtUser = seisServConfiguration.dbProtUser;
        this.allDbProtUsers = seisServConfiguration.allDbProtUsers;
        this.debugMode = seisServConfiguration.debugMode;
        this.dbPostgres = seisServConfiguration.dbPostgres;
        this.dataChangeSimulationPause = seisServConfiguration.dataChangeSimulationPause;
        this.theme = seisServConfiguration.theme;
    }

    public void updateKnowbaseFolder() {
        DEFAULT_CONFIGFILE = PlatformUtil.getApplicationConfPath((String)"seisserv") + File.separator + "seisserv.xml";
    }

    @XmlElement(name="mainFrameSize", required=true, nillable=false)
    private final AbstractConfiguration.FrameSize getMainFrameSizeJAXB() {
        return this.seisServFrameSize;
    }

    @XmlElement(name="mainFramePosition", required=true, nillable=false)
    private final AbstractConfiguration.FramePosition getMainFramePositionJAXB() {
        return this.seisServFramePosition;
    }

    private void setMainFrameSizeJAXB(AbstractConfiguration.FrameSize frameSize) {
        this.seisServFrameSize = frameSize;
    }

    private void setMainFramePositionJAXB(AbstractConfiguration.FramePosition framePosition) {
        this.seisServFramePosition = framePosition;
    }

    public final boolean isLastHeaderAutoload() {
        return this.lastHeaderAutoload;
    }

    public final void setLastHeaderAutoload(boolean bl) {
        this.lastHeaderAutoload = bl;
    }

    public final boolean isGoogleearthAutostart() {
        return this.hypolineAutostart;
    }

    public final void setGoogleearthAutostart(boolean bl) {
        this.googleearthAutostart = bl;
    }

    public final boolean isHypolineAutostart() {
        return this.hypolineAutostart;
    }

    public final void setHypolineAutostart(boolean bl) {
        this.hypolineAutostart = bl;
    }

    public File getGoogleearthFile() {
        return this.googleearthFile;
    }

    public void setGoogleearthFile(File file) {
        this.googleearthFile = file;
    }

    public final File getLastOpenedHeader() {
        return this.lastOpenedHeader;
    }

    public final void setLastOpenedHeader(File file) {
        this.lastOpenedHeader = file;
    }

    public void load() {
        try {
            SeisServConfiguration seisServConfiguration = (SeisServConfiguration)JAXBUtil.readXML((File)new File(DEFAULT_CONFIGFILE), ((Object)((Object)this)).getClass());
            this.shallowCopyFrom(seisServConfiguration);
        }
        catch (Exception exception) {
            LogUtil.info(((Object)((Object)this)).getClass(), (String)"Failed to load SeisServ config file, using default values", (boolean)false);
        }
    }

    public void store() {
        try {
            JAXBUtil.writeXML((JAXBSerializable)this, (File)new File(DEFAULT_CONFIGFILE));
        }
        catch (Exception exception) {
            LogUtil.fatal(((Object)((Object)this)).getClass(), (String)"Failed to store SeisServ config file", (Throwable)exception);
        }
    }

    @XmlTransient
    public final Dimension getSeisServFrameSize() {
        return this.seisServFrameSize.getDimension();
    }

    public final void setseisServFrameSize(Dimension dimension) {
        this.seisServFrameSize.setDimension(dimension);
    }

    @XmlTransient
    public final Point getSeisServFramePosition() {
        return this.seisServFramePosition.getPoint();
    }

    public final void setseisServFramePosition(Point point) {
        this.seisServFramePosition.setPoint(point);
    }

    public void setShowErrors(boolean bl) {
        this.showErrors = bl;
    }

    public boolean isShowErrors() {
        return this.showErrors;
    }

    public void setDbAddress(String string) {
        this.dbAddress = string;
    }

    public String getDbAddress() {
        return this.dbAddress;
    }

    public void setDbPort(int n) {
        this.dbPort = n;
    }

    public int getDbPort() {
        return this.dbPort;
    }

    public void setDbSid(String string) {
        this.dbSid = string;
    }

    public String getDbSid() {
        return this.dbSid;
    }

    public void setDbUser(String string) {
        this.dbUser = string;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public void setDbPassword(String string) {
        this.dbPassword = string;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public void setDbStartDate(long l) {
        this.dbStartDate = l;
    }

    public long getDbStartDate() {
        return this.dbStartDate;
    }

    public void setDbEndDate(long l) {
        this.dbEndDate = l;
    }

    public long getDbEndDate() {
        return this.dbEndDate;
    }

    public void setDbCampaigns(List<String> list) {
        this.dbCampaigns = list;
    }

    public List<String> getDbCampaigns() {
        return this.dbCampaigns;
    }

    public void setDbSNS(List<String> list) {
        this.dbSNS = list;
    }

    public List<String> getDbSNS() {
        return this.dbSNS;
    }

    public void setDataSource(DATA_SOURCE dATA_SOURCE) {
        this.dataSource = dATA_SOURCE;
    }

    public DATA_SOURCE getDataSource() {
        return this.dataSource;
    }

    public File[] getHeaderHistory() {
        return this.headerHistory;
    }

    public void setHeaderHistory(File[] fileArray) {
        this.headerHistory = fileArray;
    }

    public String getDbProtUser() {
        return this.dbProtUser;
    }

    public void setDbProtUser(String string) {
        this.dbProtUser = string;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean bl) {
        this.debugMode = bl;
    }

    public List<String> getDbSingleStations() {
        return this.dbSingleStations;
    }

    public void setDbSingleStations(List<String> list) {
        this.dbSingleStations = list;
    }

    public List<String> getAllDbProtUsers() {
        return this.allDbProtUsers;
    }

    public void setAllDbProtUsers(List<String> list) {
        this.allDbProtUsers = list;
    }

    public boolean isDbPostgres() {
        return this.dbPostgres;
    }

    public void setDbPostgres(boolean bl) {
        this.dbPostgres = bl;
    }

    public long getDataChangeSimulationPause() {
        return this.dataChangeSimulationPause;
    }

    public void setDataChangeSimulationPause(long l) {
        this.dataChangeSimulationPause = l;
    }

    public ThemeManager.ThemeMode getTheme() {
        return this.theme;
    }

    public void setTheme(ThemeManager.ThemeMode themeMode) {
        this.theme = themeMode;
    }

    public static enum DATA_SOURCE {
        HEADER,
        DATABASE,
        MSEED,
        SEG2,
        SEGY,
        SEEDLINK;

    }
}

