/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.seisserv.swing;

import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.themes.ThemeManager;
import edu.geophys.commons.ui.FrameIconSetter;
import edu.geophys.commons.ui.JAboutDialog;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.commons.util.PlatformUtil;
import edu.geophys.commons.util.ProjectDirectories;
import edu.geophys.seisserv.SeisServApplication;
import edu.geophys.seisserv.swing.JMemoryStatus;
import edu.geophys.seisserv.swing.JToolsMenu;
import edu.geophys.seisserv.swing.ResampleModeSelector;
import edu.geophys.seisserv.swing.StationSelectorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class DTPServerWindow
extends JFrame {
    private static final int PAD = 2;
    private static final String CAPTION_AREA_STATUS = "Memory Usage";
    private static final String CAPTION_AREA_DATA = "Data";
    private static final String CAPTION_AREA_SNSLIST = "Select Stations";
    private final JMenu recentHeaders = new JMenu("Load recent data ...");
    private final JMenu demoHeaders = new JMenu("Load demo data ...");
    private final SeisServApplication seisServ;
    private StationSelectorPanel activeSelectorPanel;
    ResampleModeSelector modeSelectorMenu;
    JButton editUserButton;
    JButton docButton;
    private final JTextField dataFileField = new JTextField();

    public DTPServerWindow(String string, SeisServApplication seisServApplication) throws HeadlessException {
        super(string);
        this.seisServ = seisServApplication;
        this.initialize();
    }

    public void updateSnsSelector() {
        this.activeSelectorPanel.loadSNS();
    }

    public void updateResamplingMode() {
        this.modeSelectorMenu.loadSelection();
    }

    private void initialize() {
        Serializable serializable;
        this.setDefaultCloseOperation(0);
        FrameIconSetter.setFrameIcon((JFrame)this);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(CAPTION_AREA_DATA));
        this.dataFileField.setEditable(false);
        this.dataFileField.setFocusable(false);
        this.setHeaderFile(null);
        jPanel.add(this.dataFileField);
        this.docButton = new JButton("Open dataset documentation");
        this.docButton.setEnabled(false);
        jPanel.add(this.docButton);
        jPanel.add(new JLabel("Master sample rate:"));
        this.modeSelectorMenu = new ResampleModeSelector(this.seisServ);
        jPanel.add(this.modeSelectorMenu);
        GridLayout gridLayout = new GridLayout(0, 1);
        gridLayout.setVgap(2);
        jPanel.setLayout(gridLayout);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(CAPTION_AREA_STATUS));
        jPanel2.add((Component)new JMemoryStatus(), "Center");
        JPanel jPanel3 = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel3, 3);
        jPanel3.setLayout(boxLayout);
        jPanel3.add(jPanel);
        jPanel3.add(jPanel2);
        if (this.seisServ.getConfig().isShowErrors()) {
            serializable = new JPanel();
            ((JComponent)serializable).setBorder(BorderFactory.createTitledBorder("Error console"));
            ((Container)serializable).setLayout(new BorderLayout());
            ((Container)serializable).add(SuiteManager.INSTANCE.getErrorConsoleUtil().getPanel(), "Center");
            jPanel3.add((Component)serializable);
        }
        serializable = new BoxLayout(this.getContentPane(), 0);
        this.getContentPane().setLayout((LayoutManager)((Object)serializable));
        this.getContentPane().add(jPanel3);
        this.activeSelectorPanel = new StationSelectorPanel(this.seisServ);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setLayout(new BorderLayout());
        jPanel4.setBorder(BorderFactory.createTitledBorder(CAPTION_AREA_SNSLIST));
        jPanel4.add(this.activeSelectorPanel);
        this.getContentPane().add(jPanel4);
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu();
        JToolsMenu jToolsMenu = new JToolsMenu(this.seisServ);
        JMenuItem jMenuItem = new JMenuItem();
        JMenu jMenu2 = new JMenu();
        JMenuItem jMenuItem2 = new JMenuItem();
        jMenu.setMnemonic('F');
        jMenu.setText("File");
        JMenuItem jMenuItem3 = new JMenuItem();
        jMenuItem3.setAction(this.getSeisServ().getLoadHeaderAction());
        jMenuItem3.setMnemonic('L');
        jMenuItem3.setText("Load data");
        this.updateRecentHeaders();
        this.updateDemoHeaders();
        if (this.demoHeaders.getItemCount() > 0) {
            jMenu.add(this.demoHeaders);
        }
        jMenuItem3 = new JMenuItem();
        jMenuItem3.setAction(this.getSeisServ().getEditKnowledgeAction());
        jMenuItem3.setMnemonic('C');
        jMenuItem3.setText("Campaign setup");
        jMenu.add(jMenuItem3);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        jMenuItem.setMnemonic('x');
        jMenuItem.setText("Exit");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DTPServerWindow.this.exitMenuItemActionPerformed(actionEvent);
            }
        });
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        jToolsMenu.setMnemonic('T');
        jToolsMenu.setText("Tools");
        jToolsMenu.addTool("edu.geophys.sonoview.SonoViewApplication");
        jToolsMenu.addTool("edu.geophys.hypoline.HypolinePlugin");
        jMenuBar.add(jToolsMenu);
        JMenu jMenu3 = new JMenu("Theme");
        JRadioButton jRadioButton = new JRadioButton("Dark");
        JRadioButton jRadioButton2 = new JRadioButton("Light");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        jMenu3.add(jRadioButton);
        jMenu3.add(jRadioButton2);
        jRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DTPServerWindow.this.seisServ.getConfig().setTheme(ThemeManager.ThemeMode.DARK);
                ThemeManager.getInstance().setMode(ThemeManager.ThemeMode.DARK);
            }
        });
        jRadioButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DTPServerWindow.this.seisServ.getConfig().setTheme(ThemeManager.ThemeMode.LIGHT);
                ThemeManager.getInstance().setMode(ThemeManager.ThemeMode.LIGHT);
            }
        });
        switch (this.seisServ.getConfig().getTheme()) {
            case DARK: {
                jRadioButton.setSelected(true);
                break;
            }
            case LIGHT: {
                jRadioButton2.setSelected(true);
            }
        }
        jMenuBar.add(jMenu3);
        jMenu2.setMnemonic('H');
        jMenu2.setText("Help");
        jMenuItem2.setMnemonic('A');
        jMenuItem2.setText("About");
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DTPServerWindow.this.aboutDialogMenueItemActionPerformed(actionEvent);
            }
        });
        jMenu2.add(jMenuItem2);
        jMenuBar.add(jMenu2);
        this.setJMenuBar(jMenuBar);
        this.pack();
    }

    private void updateDocButton() {
        if (this.docButton == null) {
            return;
        }
        for (ActionListener actionListener : this.docButton.getActionListeners()) {
            this.docButton.removeActionListener(actionListener);
        }
        this.docButton.setEnabled(false);
        ProjectDirectories projectDirectories = SuiteManager.INSTANCE.getProjectDirectories();
        if (projectDirectories != null) {
            final File file = projectDirectories.getDocumentationFile();
            if (file == null || !file.exists()) {
                this.docButton.setToolTipText("No documentation available");
            } else {
                this.docButton.setToolTipText(file.getAbsolutePath());
                this.docButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            Desktop.getDesktop().open(file);
                            LogUtil.info(this.getClass(), (String)("Opening documentation file: " + file.getAbsolutePath()), (boolean)true);
                        }
                        catch (Exception exception) {
                            LogUtil.error(this.getClass(), (String)("Could not open documentation file: " + file.getAbsolutePath()), (boolean)true);
                        }
                    }
                });
                this.docButton.setEnabled(true);
            }
        }
    }

    private void updateRecentHeaders() {
        this.updateRecentHeaders(null);
    }

    private void updateRecentHeaders(File file) {
        String string = null;
        if (file != null) {
            string = file.getAbsolutePath();
        }
        if (this.recentHeaders == null) {
            return;
        }
        File[] fileArray = this.seisServ.getConfig().getHeaderHistory();
        this.recentHeaders.removeAll();
        for (File file2 : fileArray) {
            if (!file2.exists() || !file2.isFile()) continue;
            JMenuItem jMenuItem = new JMenuItem(file2.toString());
            jMenuItem.addActionListener(this.getSeisServ().getLoadHeaderAction(file2));
            if (string != null && string.equals(file2.getAbsolutePath())) {
                jMenuItem.setEnabled(false);
            }
            this.recentHeaders.add(jMenuItem);
        }
        if (this.recentHeaders.getItemCount() == 0) {
            this.recentHeaders.setEnabled(false);
        }
    }

    private void updateDemoHeaders() {
        this.updateDemoHeaders(null);
    }

    private void updateDemoHeaders(File file) {
        Map map = PlatformUtil.findDemoData();
        String string = null;
        if (file != null) {
            string = file.getAbsolutePath();
        }
        this.demoHeaders.removeAll();
        for (Map.Entry entry : map.entrySet()) {
            JMenuItem jMenuItem = new JMenuItem((String)entry.getKey());
            if (string != null && string.equals(((File)entry.getValue()).getAbsolutePath())) {
                jMenuItem.setEnabled(false);
            }
            jMenuItem.addActionListener(this.getSeisServ().getLoadHeaderAction((File)entry.getValue()));
            this.demoHeaders.add(jMenuItem);
        }
        if (this.demoHeaders.getItemCount() == 0) {
            this.demoHeaders.setEnabled(false);
        }
    }

    private void aboutDialogMenueItemActionPerformed(ActionEvent actionEvent) {
        JAboutDialog.showDialog((Frame)this, (boolean)true);
    }

    private void exitMenuItemActionPerformed(ActionEvent actionEvent) {
        this.getSeisServ().onExit();
    }

    public void setHeaderFile(File file) {
        if (file == null) {
            this.dataFileField.setEnabled(false);
            this.dataFileField.setText("");
        } else {
            this.dataFileField.setText(file.getAbsolutePath());
            this.dataFileField.setEnabled(true);
        }
        this.updateRecentHeaders(file);
        this.updateDemoHeaders(file);
        this.updateDocButton();
    }

    public SeisServApplication getSeisServ() {
        return this.seisServ;
    }
}

