/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.seisserv.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class HeaderFileChooser
extends JFileChooser {
    private static final long serialVersionUID = 1L;
    private PreviewAndHistoryPanel previewAndHistoryPanel;
    private JList<String> list;
    private ListSelListener listSelListener;
    private DefaultListModel<String> listModel;
    private final ArrayList<String> headerHistory;
    private final int maxLetterNo = 27;

    public HeaderFileChooser(File file, final ArrayList<String> arrayList) {
        super(file);
        this.headerHistory = arrayList;
        this.previewAndHistoryPanel = new PreviewAndHistoryPanel();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.previewAndHistoryPanel, "Center");
        this.setAccessory(jPanel);
        for (int i = 0; i < arrayList.size(); ++i) {
            if (arrayList.get(i) != null && new File(arrayList.get(i)).isDirectory()) {
                if (arrayList.get(i).length() < 27) {
                    this.listModel.add(i, arrayList.get(i));
                    continue;
                }
                this.listModel.add(i, ".." + arrayList.get(i).substring(arrayList.get(i).length() - 27));
                continue;
            }
            this.listModel.add(i, "");
        }
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("directoryChanged")) {
                    int n;
                    File file = (File)propertyChangeEvent.getNewValue();
                    if (file == null) {
                        return;
                    }
                    if (file.getName().equals("")) {
                        return;
                    }
                    String string = file.getAbsolutePath();
                    boolean bl = false;
                    for (n = 0; n < HeaderFileChooser.this.listModel.getSize(); ++n) {
                        String string2 = (String)arrayList.get(n);
                        if (!string2.equals(string)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) {
                        HeaderFileChooser.this.list.setSelectedIndex(n);
                    }
                }
            }
        });
        if (file != null) {
            this.firePropertyChange("directoryChanged", "", file.getParentFile());
        }
    }

    private final class PreviewAndHistoryPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public PreviewAndHistoryPanel() {
            this.setPreferredSize(new Dimension(250, 250));
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setLayout(new BorderLayout());
            HeaderFileChooser.this.list = new JList<String>(){
                private static final long serialVersionUID = 1L;

                @Override
                public String getToolTipText(MouseEvent mouseEvent) {
                    int n = this.locationToIndex(mouseEvent.getPoint());
                    String string = HeaderFileChooser.this.headerHistory.get(n);
                    JLabel jLabel = new JLabel(string);
                    jLabel.setFont(HeaderFileChooser.this.list.getFont());
                    if (jLabel.getPreferredSize().width > HeaderFileChooser.this.list.getSize().width) {
                        return string;
                    }
                    return null;
                }
            };
            HeaderFileChooser.this.listModel = new DefaultListModel();
            HeaderFileChooser.this.list.setModel(HeaderFileChooser.this.listModel);
            HeaderFileChooser.this.listSelListener = new ListSelListener();
            HeaderFileChooser.this.list.addListSelectionListener(HeaderFileChooser.this.listSelListener);
            this.add(HeaderFileChooser.this.list, "North");
        }
    }

    private final class ListSelListener
    implements ListSelectionListener {
        String dir;

        private ListSelListener() {
        }

        private void selectNewDirectory() {
            this.dir = HeaderFileChooser.this.headerHistory.get(HeaderFileChooser.this.list.getSelectedIndex());
            HeaderFileChooser.this.setCurrentDirectory(new File(this.dir));
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                this.selectNewDirectory();
            }
        }
    }
}

