/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.seisserv.swing;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

public class JMemoryStatus
extends JPanel {
    private static final String CAPTION_AREA_STATUS_MEMORY_TOTAL = "Memory Total:";
    private static final String CAPTION_AREA_STATUS_MEMORY_FREE = "Memory Free:";
    private static final String CAPTION_AREA_STATUS_MEMORY_USED = "Memory Used:";
    private static final NumberFormat BYTE_FORMAT = new DecimalFormat("0 Byte");
    private static final NumberFormat KBYTE_FORMAT = new DecimalFormat("0.00 KByte");
    private static final long KBYTE_FACTOR = 1024L;
    private static final NumberFormat MBYTE_FORMAT = new DecimalFormat("0.00 MByte");
    private static final long MBYTE_FACTOR = 0x100000L;
    private static final NumberFormat PERCENT_FORMAT = new DecimalFormat("(0.00%)");
    private static final int UPDATE_INTERVAL = 1000;
    private final JLabel _maxmemLabel = new JLabel();
    private final JLabel _freememLabel = new JLabel();
    private final JLabel _usedmemLabel = new JLabel();

    private static String formatByte(long l) {
        if (l >= 0x100000L) {
            return MBYTE_FORMAT.format((double)l / 1048576.0);
        }
        if (l >= 1024L) {
            return KBYTE_FORMAT.format((double)l / 1024.0);
        }
        return BYTE_FORMAT.format(l);
    }

    public JMemoryStatus() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridLayout(3, 2));
        this.add(new JLabel(CAPTION_AREA_STATUS_MEMORY_TOTAL));
        this.add(this._maxmemLabel);
        this.add(new JLabel(CAPTION_AREA_STATUS_MEMORY_USED));
        this.add(this._usedmemLabel);
        this.add(new JLabel(CAPTION_AREA_STATUS_MEMORY_FREE));
        this.add(this._freememLabel);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JMemoryStatus.this.updateStatus();
            }
        };
        new Timer(1000, actionListener).start();
        this.updateStatus();
    }

    private void updateStatus() {
        long l = Runtime.getRuntime().freeMemory();
        long l2 = Runtime.getRuntime().totalMemory();
        String string = JMemoryStatus.formatByte(l) + " " + PERCENT_FORMAT.format((double)l / (double)l2);
        String string2 = JMemoryStatus.formatByte(l2 - l) + " " + PERCENT_FORMAT.format((double)(l2 - l) / (double)l2);
        String string3 = JMemoryStatus.formatByte(l2);
        this._maxmemLabel.setText(string3);
        this._usedmemLabel.setText(string2);
        this._freememLabel.setText(string);
    }
}

