/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.chart;

import org.jzy3d.factories.JzyFactories;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.plot3d.rendering.canvas.ICanvas;
import org.jzy3d.plot3d.rendering.canvas.Quality;
import org.jzy3d.plot3d.rendering.scene.Graph;
import org.jzy3d.plot3d.rendering.scene.Scene;
import org.jzy3d.plot3d.rendering.view.View;

public class ChartScene
extends Scene {
    protected int nview;
    protected View view;

    public ChartScene() {
        this.nview = 0;
    }

    public ChartScene(boolean graphsort) {
        super(graphsort);
        this.graph = new Graph(this, JzyFactories.ordering.getInstance(), graphsort);
        this.nview = 0;
    }

    public void clear() {
        this.view.setBoundManual(new BoundingBox3d(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f));
    }

    public View newView(ICanvas canvas, Quality quality) {
        if (this.nview > 0) {
            throw new RuntimeException("A view has already been defined for this scene. Can not use several views.");
        }
        ++this.nview;
        this.view = this.initializeChartView(this, canvas, quality);
        this.views.add(this.view);
        return this.view;
    }

    public void clearView(View view) {
        super.clearView(view);
        --this.nview;
    }

    protected View initializeChartView(Scene scene, ICanvas canvas, Quality quality) {
        return JzyFactories.view.getInstance(scene, canvas, quality);
    }
}

