/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.colors.colormaps;

import org.jzy3d.colors.Color;
import org.jzy3d.colors.IColorMappable;
import org.jzy3d.colors.colormaps.IColorMap;

public class ColorMapRedAndGreen
implements IColorMap {
    private boolean direction = true;

    public void setDirection(boolean isStandard) {
        this.direction = isStandard;
    }

    public boolean getDirection() {
        return this.direction;
    }

    public Color getColor(IColorMappable colorable, float x, float y, float z) {
        return this.getColor(x, y, z, colorable.getZMin(), colorable.getZMax());
    }

    private Color getColor(float x, float y, float z, float zMin, float zMax) {
        float rel_value = 0.0f;
        rel_value = z < zMin ? 0.0f : (z > zMax ? 1.0f : (this.direction ? (z - zMin) / (zMax - zMin) : (zMax - z) / (zMax - zMin)));
        float b = 0.0f;
        float v = this.colorComponentRelative(rel_value, 0.375f, 0.25f, 0.75f);
        float r = this.colorComponentRelative(rel_value, 0.625f, 0.25f, 0.75f);
        return new Color(r, v, b);
    }

    public Color getColor(IColorMappable colorable, float z) {
        return this.getColor(0.0f, 0.0f, z, colorable.getZMin(), colorable.getZMax());
    }

    private float colorComponentRelative(float value, float center, float topwidth, float bottomwidth) {
        return this.colorComponentAbsolute(value, center - bottomwidth / 2.0f, center + bottomwidth / 2.0f, center - topwidth / 2.0f, center + topwidth / 2.0f);
    }

    private float colorComponentAbsolute(float value, float bLeft, float bRight, float tLeft, float tRight) {
        float output = 0.0f;
        if (value < bLeft || value >= bRight) {
            output = 0.0f;
        } else if (value >= tLeft && value < tRight) {
            output = 1.0f;
        } else if (value >= bLeft && value < tLeft) {
            output = (value - bLeft) / (tLeft - bLeft);
        } else if (value >= tRight && value < bRight) {
            output = (value - bRight) / (tRight - bRight);
        }
        return output;
    }
}

