/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.maths;

import java.util.ArrayList;
import java.util.List;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.Range;
import org.jzy3d.maths.Utils;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.primitives.Polygon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundingBox3d {
    private float xmin;
    private float xmax;
    private float ymin;
    private float ymax;
    private float zmin;
    private float zmax;

    public BoundingBox3d() {
        this.reset();
    }

    public BoundingBox3d(List<Coord3d> coords) {
        this.reset();
        for (Coord3d c : coords) {
            this.add(c);
        }
    }

    public BoundingBox3d(Polygon polygon) {
        this.reset();
        for (Point c : polygon.getAll()) {
            this.add(c);
        }
    }

    public BoundingBox3d(Coord3d center, float edgeLength) {
        this.xmin = center.x - edgeLength / 2.0f;
        this.xmax = center.x + edgeLength / 2.0f;
        this.ymin = center.y - edgeLength / 2.0f;
        this.ymax = center.y + edgeLength / 2.0f;
        this.zmin = center.z - edgeLength / 2.0f;
        this.zmax = center.z + edgeLength / 2.0f;
    }

    public BoundingBox3d(BoundingBox3d box) {
        this.xmin = box.xmin;
        this.xmax = box.xmax;
        this.ymin = box.ymin;
        this.ymax = box.ymax;
        this.zmin = box.zmin;
        this.zmax = box.zmax;
    }

    public BoundingBox3d(float xmin, float xmax, float ymin, float ymax, float zmin, float zmax) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = ymax;
        this.zmin = zmin;
        this.zmax = zmax;
    }

    public void reset() {
        this.xmin = Float.MAX_VALUE;
        this.xmax = -3.4028235E38f;
        this.ymin = Float.MAX_VALUE;
        this.ymax = -3.4028235E38f;
        this.zmin = Float.MAX_VALUE;
        this.zmax = -3.4028235E38f;
    }

    public boolean valid() {
        return this.xmin <= this.xmax && this.ymin <= this.ymax && this.zmin <= this.zmax;
    }

    public void add(float x, float y, float z) {
        if (x > this.xmax) {
            this.xmax = x;
        }
        if (x < this.xmin) {
            this.xmin = x;
        }
        if (y > this.ymax) {
            this.ymax = y;
        }
        if (y < this.ymin) {
            this.ymin = y;
        }
        if (z > this.zmax) {
            this.zmax = z;
        }
        if (z < this.zmin) {
            this.zmin = z;
        }
    }

    public void add(Coord3d c) {
        this.add(c.x, c.y, c.z);
    }

    public void add(Point p) {
        this.add(p.xyz.x, p.xyz.y, p.xyz.z);
    }

    public void add(Polygon p) {
        for (int i = 0; i < p.size(); ++i) {
            this.add(p.get((int)i).xyz.x, p.get((int)i).xyz.y, p.get((int)i).xyz.z);
        }
    }

    public void add(BoundingBox3d b) {
        this.add(b.xmin, b.ymin, b.zmin);
        this.add(b.xmax, b.ymax, b.zmax);
    }

    public Coord3d getCenter() {
        return new Coord3d((this.xmin + this.xmax) / 2.0f, (this.ymin + this.ymax) / 2.0f, (this.zmin + this.zmax) / 2.0f);
    }

    public double getRadius() {
        return this.getCenter().distance(new Coord3d(this.xmin, this.ymin, this.zmin));
    }

    public BoundingBox3d scale(Coord3d scale) {
        BoundingBox3d b = new BoundingBox3d();
        b.xmax = this.xmax * scale.x;
        b.xmin = this.xmin * scale.x;
        b.ymax = this.ymax * scale.y;
        b.ymin = this.ymin * scale.y;
        b.zmax = this.zmax * scale.z;
        b.zmin = this.zmin * scale.z;
        return b;
    }

    public BoundingBox3d shift(Coord3d offset) {
        BoundingBox3d b = new BoundingBox3d();
        b.xmax = this.xmax + offset.x;
        b.xmin = this.xmin + offset.x;
        b.ymax = this.ymax + offset.y;
        b.ymin = this.ymin + offset.y;
        b.zmax = this.zmax + offset.z;
        b.zmin = this.zmin + offset.z;
        return b;
    }

    public boolean contains(BoundingBox3d b2) {
        return this.xmin <= b2.xmin && b2.xmax <= this.xmax && this.ymin <= b2.ymin && b2.ymax <= this.ymax && this.zmin <= b2.zmin && b2.zmax <= this.zmax;
    }

    public boolean intersect(BoundingBox3d b2) {
        return this.xmin <= b2.xmin && b2.xmin <= this.xmax || this.xmin <= b2.xmax && b2.xmax <= this.xmax || this.ymin <= b2.ymin && b2.ymin <= this.ymax || this.ymin <= b2.ymax && b2.ymax <= this.ymax || this.zmin <= b2.zmin && b2.zmin <= this.zmax || this.zmin <= b2.zmax && b2.zmax <= this.zmax;
    }

    public BoundingBox3d margin(float margin) {
        BoundingBox3d b = new BoundingBox3d();
        b.xmax = this.xmax + margin;
        b.xmin = this.xmin + margin;
        b.ymax = this.ymax + margin;
        b.ymin = this.ymin + margin;
        b.zmax = this.zmax + margin;
        b.zmin = this.zmin + margin;
        return b;
    }

    public BoundingBox3d selfMargin(float margin) {
        this.xmax += margin;
        this.xmin -= margin;
        this.ymax += margin;
        this.ymin -= margin;
        this.zmax += margin;
        this.zmin -= margin;
        return this;
    }

    public Range getXRange() {
        return new Range(this.xmin, this.xmax);
    }

    public Range getYRange() {
        return new Range(this.ymin, this.ymax);
    }

    public Range getZRange() {
        return new Range(this.zmin, this.zmax);
    }

    public float getXmin() {
        return this.xmin;
    }

    public void setXmin(float value) {
        this.xmin = value;
    }

    public float getXmax() {
        return this.xmax;
    }

    public void setXmax(float value) {
        this.xmax = value;
    }

    public float getYmin() {
        return this.ymin;
    }

    public void setYmin(float value) {
        this.ymin = value;
    }

    public float getYmax() {
        return this.ymax;
    }

    public void setYmax(float value) {
        this.ymax = value;
    }

    public float getZmin() {
        return this.zmin;
    }

    public void setZmin(float value) {
        this.zmin = value;
    }

    public float getZmax() {
        return this.zmax;
    }

    public void setZmax(float value) {
        this.zmax = value;
    }

    public List<Coord3d> getVertices() {
        ArrayList<Coord3d> edges = new ArrayList<Coord3d>(8);
        edges.add(new Coord3d(this.xmin, this.ymin, this.zmin));
        edges.add(new Coord3d(this.xmin, this.ymax, this.zmin));
        edges.add(new Coord3d(this.xmax, this.ymax, this.zmin));
        edges.add(new Coord3d(this.xmax, this.ymin, this.zmin));
        edges.add(new Coord3d(this.xmin, this.ymin, this.zmax));
        edges.add(new Coord3d(this.xmin, this.ymax, this.zmax));
        edges.add(new Coord3d(this.xmax, this.ymax, this.zmax));
        edges.add(new Coord3d(this.xmax, this.ymin, this.zmax));
        return edges;
    }

    public static BoundingBox3d newBoundsAtOrigin() {
        return new BoundingBox3d(Coord3d.ORIGIN, 0.0f);
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int depth) {
        return Utils.blanks(depth) + "(BoundingBox3d)" + this.xmin + "<=x<=" + this.xmax + " | " + this.ymin + "<=y<=" + this.ymax + " | " + this.zmin + "<=z<=" + this.zmax;
    }
}

