/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.maths.algorithms.interpolation.bernstein;

public class BernsteinPolynomial {
    public float[] b0;
    public float[] b1;
    public float[] b2;
    public float[] b3;
    public int resolution;

    public BernsteinPolynomial(int res) {
        this.resolution = res;
        this.b0 = new float[res];
        this.b1 = new float[res];
        this.b2 = new float[res];
        this.b3 = new float[res];
        float t = 0.0f;
        float dt = 1.0f / (float)(this.resolution - 1);
        for (int i = 0; i < this.resolution; ++i) {
            float t1 = 1.0f - t;
            float t12 = t1 * t1;
            float t2 = t * t;
            this.b0[i] = t1 * t12;
            this.b1[i] = 3.0f * t * t12;
            this.b2[i] = 3.0f * t2 * t1;
            this.b3[i] = t * t2;
            t += dt;
        }
    }
}

