/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.picking;

import com.jogamp.common.nio.Buffers;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.IntegerCoord2d;
import org.jzy3d.maths.TicToc;
import org.jzy3d.picking.IObjectPickedListener;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.pickable.Pickable;
import org.jzy3d.plot3d.rendering.scene.Graph;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.rendering.view.View;
import org.jzy3d.plot3d.rendering.view.modes.CameraMode;
import org.jzy3d.plot3d.transform.Scale;
import org.jzy3d.plot3d.transform.Transform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PickingSupport {
    protected TicToc perf = new TicToc();
    protected static int method = 0;
    protected static int pickId = 0;
    protected Map<Integer, Pickable> pickables = new HashMap<Integer, Pickable>();
    protected List<IObjectPickedListener> verticesListener = new ArrayList<IObjectPickedListener>(1);
    protected Map<Pickable, Object> pickableTargets = new HashMap<Pickable, Object>();
    protected int brushSize;
    protected int bufferSize;

    public PickingSupport() {
        this(10);
    }

    public PickingSupport(int brushSize) {
        this(brushSize, 2048);
    }

    public PickingSupport(int brushSize, int bufferSize) {
        this.brushSize = brushSize;
        this.bufferSize = bufferSize;
    }

    public boolean addObjectPickedListener(IObjectPickedListener listener) {
        return this.verticesListener.add(listener);
    }

    public boolean removeObjectPickedListener(IObjectPickedListener listener) {
        return this.verticesListener.remove(listener);
    }

    protected void fireObjectPicked(List<? extends Object> v) {
        for (IObjectPickedListener listener : this.verticesListener) {
            listener.objectPicked(v, this);
        }
    }

    public void registerDrawableObject(AbstractDrawable drawable, Object model) {
        if (drawable instanceof Pickable) {
            this.registerPickableObject((Pickable)((Object)drawable), model);
        }
    }

    public synchronized void registerPickableObject(Pickable pickable, Object model) {
        pickable.setPickingId(pickId++);
        this.pickables.put(pickable.getPickingId(), pickable);
        this.pickableTargets.put(pickable, model);
    }

    public synchronized void getPickableObject(int id) {
        this.pickables.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pickObjects(GL2 gl, GLU glu, View view, Graph graph, IntegerCoord2d pickPoint) {
        this.perf.tic();
        int[] viewport = new int[4];
        int[] selectBuf = new int[this.bufferSize];
        IntBuffer selectBuffer = Buffers.newDirectIntBuffer((int)this.bufferSize);
        gl.glGetIntegerv(2978, viewport, 0);
        gl.glSelectBuffer(this.bufferSize, selectBuffer);
        gl.glRenderMode(7170);
        gl.glInitNames();
        gl.glPushName(0);
        Camera camera = view.getCamera();
        CameraMode cMode = view.getCameraMode();
        Coord3d viewScaling = view.getLastViewScaling();
        Transform viewTransform = new Transform(new Scale(viewScaling));
        double xpick = pickPoint.x;
        double ypick = pickPoint.y;
        gl.glMatrixMode(5889);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        glu.gluPickMatrix(xpick, ypick, (double)this.brushSize, (double)this.brushSize, viewport, 0);
        camera.doShoot(gl, glu, cMode);
        gl.glMatrixMode(5888);
        PickingSupport pickingSupport = this;
        synchronized (pickingSupport) {
            for (Pickable pickable : this.pickables.values()) {
                this.setCurrentName(gl, pickable);
                pickable.setTransform(viewTransform);
                pickable.draw(gl, glu, camera);
                this.releaseCurrentName(gl);
            }
        }
        gl.glMatrixMode(5889);
        gl.glPopMatrix();
        gl.glFlush();
        int hits = gl.glRenderMode(7168);
        selectBuffer.get(selectBuf);
        List<Pickable> picked = this.processHits(hits, selectBuf);
        ArrayList<Object> clickedObjects = new ArrayList<Object>(hits);
        for (Pickable pickable : picked) {
            Object vertex = this.pickableTargets.get(pickable);
            clickedObjects.add(vertex);
        }
        this.perf.toc();
        this.fireObjectPicked(clickedObjects);
    }

    public double getLastPickPerfMs() {
        return this.perf.elapsedMilisecond();
    }

    protected void setCurrentName(GL2 gl, Pickable pickable) {
        if (method == 0) {
            gl.glLoadName(pickable.getPickingId());
        } else {
            gl.glPushName(pickable.getPickingId());
        }
    }

    protected void releaseCurrentName(GL2 gl) {
        if (method != 0) {
            gl.glPopName();
        }
    }

    protected List<Pickable> processHits(int hits, int[] buffer) {
        int ptr = 0;
        int z2 = 0;
        ArrayList<Pickable> picked = new ArrayList<Pickable>();
        for (int i = 0; i < hits; ++i) {
            int names = buffer[ptr];
            int z1 = buffer[++ptr];
            z2 = buffer[++ptr];
            ++ptr;
            for (int j = 0; j < names; ++j) {
                int idj = buffer[ptr];
                ++ptr;
                if (!this.pickables.containsKey(idj)) {
                    throw new RuntimeException("internal error: pickable id not found in registry!");
                }
                picked.add(this.pickables.get(idj));
            }
        }
        return picked;
    }
}

