/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives;

import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import org.jzy3d.colors.Color;
import org.jzy3d.events.DrawableChangedEvent;
import org.jzy3d.events.IDrawableListener;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.Utils;
import org.jzy3d.plot3d.primitives.IGLRenderer;
import org.jzy3d.plot3d.primitives.ISortableDraw;
import org.jzy3d.plot3d.rendering.legends.Legend;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.transform.Transform;

public abstract class AbstractDrawable
implements IGLRenderer,
ISortableDraw {
    protected Transform transform;
    protected BoundingBox3d bbox;
    protected Legend legend = null;
    protected List<IDrawableListener> listeners;
    protected boolean hasListeners = true;
    protected boolean displayed = true;
    protected boolean legendDisplayed = false;

    public void dispose() {
        if (this.listeners != null) {
            this.listeners.clear();
        }
    }

    public abstract void draw(GL2 var1, GLU var2, Camera var3);

    protected void call(GL2 gl, Color c) {
        gl.glColor4f(c.r, c.g, c.b, c.a);
    }

    protected void call(GL2 gl, Color c, float alpha) {
        gl.glColor4f(c.r, c.g, c.b, alpha);
    }

    protected void callWithAlphaFactor(GL2 gl, Color c, float alpha) {
        gl.glColor4f(c.r, c.g, c.b, c.a * alpha);
    }

    protected void negative(Color c) {
        c.r = 1.0f - c.r;
        c.g = 1.0f - c.g;
        c.b = 1.0f - c.b;
    }

    public void setTransform(Transform transform) {
        this.transform = transform;
        this.fireDrawableChanged(1);
    }

    public Transform getTransform() {
        return this.transform;
    }

    public BoundingBox3d getBounds() {
        return this.bbox;
    }

    public Coord3d getBarycentre() {
        if (this.bbox != null) {
            return this.bbox.getCenter();
        }
        return Coord3d.INVALID.clone();
    }

    public void setDisplayed(boolean status) {
        this.displayed = status;
        this.fireDrawableChanged(4);
    }

    public boolean isDisplayed() {
        return this.displayed;
    }

    public double getDistance(Camera camera) {
        return this.getBarycentre().distance(camera.getEye());
    }

    public double getShortestDistance(Camera camera) {
        return this.getDistance(camera);
    }

    public double getLongestDistance(Camera camera) {
        return this.getDistance(camera);
    }

    public void setLegend(Legend face) {
        this.legend = face;
        this.legendDisplayed = true;
        this.fireDrawableChanged(3);
    }

    public Legend getLegend() {
        return this.legend;
    }

    public boolean hasLegend() {
        return this.legend != null;
    }

    public void setLegendDisplayed(boolean status) {
        this.legendDisplayed = status;
    }

    public boolean isLegendDisplayed() {
        return this.legendDisplayed;
    }

    public void addDrawableListener(IDrawableListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IDrawableListener>();
        }
        this.listeners.add(listener);
        this.hasListeners = true;
    }

    public void removeDrawableListener(IDrawableListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireDrawableChanged(int eventType) {
        if (this.listeners != null) {
            this.fireDrawableChanged(new DrawableChangedEvent(this, eventType));
        }
    }

    protected void fireDrawableChanged(DrawableChangedEvent e) {
        if (this.listeners != null) {
            for (IDrawableListener listener : this.listeners) {
                listener.drawableChanged(e);
            }
        }
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int depth) {
        return Utils.blanks(depth) + "(" + this.getClass().getSimpleName() + ")";
    }
}

