/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives;

import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUquadric;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ISingleColorable;
import org.jzy3d.events.DrawableChangedEvent;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.AbstractWireframeable;
import org.jzy3d.plot3d.rendering.view.Camera;

public class Disk
extends AbstractWireframeable
implements ISingleColorable {
    private float x;
    private float y;
    private float z;
    private int slices;
    private int loops;
    private float radiusInner;
    private float radiusOuter;
    private Color color;

    public Disk() {
        this.bbox = new BoundingBox3d();
        this.setPosition(Coord3d.ORIGIN);
        this.setVolume(0.0f, 10.0f);
        this.setSlicing(15, 15);
        this.setColor(Color.BLACK);
    }

    public Disk(Coord3d position, float radiusInner, float radiusOuter, int slices, int loops, Color color) {
        this.bbox = new BoundingBox3d();
        this.setPosition(position);
        this.setVolume(radiusInner, radiusOuter);
        this.setSlicing(slices, loops);
        this.setColor(color);
    }

    public void draw(GL2 gl, GLU glu, Camera cam) {
        if (this.transform != null) {
            this.transform.execute(gl);
        }
        gl.glTranslatef(this.x, this.y, this.z);
        gl.glLineWidth(this.wfwidth);
        GLUquadric qobj = glu.gluNewQuadric();
        if (this.facestatus) {
            if (this.wfstatus) {
                gl.glEnable(32823);
                gl.glPolygonOffset(1.0f, 1.0f);
            }
            gl.glPolygonMode(1032, 6914);
            gl.glColor4f(this.color.r, this.color.g, this.color.b, this.color.a);
            glu.gluDisk(qobj, (double)this.radiusInner, (double)this.radiusOuter, this.slices, this.loops);
            if (this.wfstatus) {
                gl.glDisable(32823);
            }
        }
        if (this.wfstatus) {
            gl.glPolygonMode(1032, 6913);
            gl.glColor4f(this.wfcolor.r, this.wfcolor.g, this.wfcolor.b, this.wfcolor.a);
            glu.gluDisk(qobj, (double)this.radiusInner, (double)this.radiusOuter, this.slices, this.loops);
        }
    }

    public void setData(Coord3d position, float radiusInner, float radiusOuter, int slices, int loops) {
        this.setPosition(position);
        this.setVolume(radiusInner, radiusOuter);
        this.setSlicing(slices, loops);
    }

    public void setPosition(Coord3d position) {
        this.x = position.x;
        this.y = position.y;
        this.z = position.z;
        this.bbox.reset();
        this.bbox.add(this.x + this.radiusOuter, this.y + this.radiusOuter, this.z);
        this.bbox.add(this.x - this.radiusOuter, this.y - this.radiusOuter, this.z);
    }

    public void setVolume(float radiusInner, float radiusOuter) {
        if (radiusOuter < radiusInner) {
            throw new IllegalArgumentException("inner radius must be smaller than outer radius");
        }
        this.radiusInner = radiusInner;
        this.radiusOuter = radiusOuter;
        this.bbox.reset();
        this.bbox.add(this.x + radiusOuter, this.y + radiusOuter, this.z);
        this.bbox.add(this.x - radiusOuter, this.y - radiusOuter, this.z);
    }

    public void setSlicing(int verticalWires, int horizontalWires) {
        this.slices = verticalWires;
        this.loops = horizontalWires;
    }

    public void setColor(Color color) {
        this.color = color;
        this.fireDrawableChanged(new DrawableChangedEvent(this, 2));
    }

    public Color getColor() {
        return this.color;
    }
}

