/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives;

import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ColorMapper;
import org.jzy3d.colors.IMultiColorable;
import org.jzy3d.colors.ISingleColorable;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.AbstractWireframeable;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.primitives.Polygon;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.transform.Transform;

public class Parallelepiped
extends AbstractWireframeable
implements ISingleColorable,
IMultiColorable {
    private ColorMapper mapper;
    private Polygon[] quads;
    private Color color;

    public Parallelepiped() {
        this.bbox = new BoundingBox3d();
    }

    public Parallelepiped(BoundingBox3d b) {
        this.bbox = new BoundingBox3d();
        this.setData(b);
    }

    public void draw(GL2 gl, GLU glu, Camera cam) {
        for (Polygon quad : this.quads) {
            quad.draw(gl, glu, cam);
        }
    }

    public void setTransform(Transform transform) {
        this.transform = transform;
        for (Polygon quad : this.quads) {
            quad.setTransform(transform);
        }
    }

    public void setWireframeColor(Color color) {
        if (this.quads != null) {
            for (Polygon quad : this.quads) {
                quad.setWireframeColor(color);
            }
        }
    }

    public void setWireframeDisplayed(boolean status) {
        if (this.quads != null) {
            for (Polygon quad : this.quads) {
                quad.setWireframeDisplayed(status);
            }
        }
    }

    public void setWireframeWidth(float width) {
        if (this.quads != null) {
            for (Polygon quad : this.quads) {
                quad.setWireframeWidth(width);
            }
        }
    }

    public void setFaceDisplayed(boolean status) {
        if (this.quads != null) {
            for (Polygon quad : this.quads) {
                quad.setFaceDisplayed(status);
            }
        }
    }

    public Color getWireframeColor() {
        return this.quads[0].getWireframeColor();
    }

    public boolean getWireframeDisplayed() {
        return this.quads[0].getWireframeDisplayed();
    }

    public float getWireframeWidth() {
        return this.quads[0].getWireframeWidth();
    }

    public boolean getFaceDisplayed() {
        return this.quads[0].getFaceDisplayed();
    }

    public void setData(BoundingBox3d box) {
        this.bbox.reset();
        this.bbox.add(box);
        this.quads = new Polygon[6];
        this.quads[0] = new Polygon();
        this.quads[0].add(new Point(new Coord3d(this.bbox.getXmax(), this.bbox.getYmin(), this.bbox.getZmax())));
        this.quads[0].add(new Point(new Coord3d(this.bbox.getXmax(), this.bbox.getYmin(), this.bbox.getZmin())));
        this.quads[0].add(new Point(new Coord3d(this.bbox.getXmax(), this.bbox.getYmax(), this.bbox.getZmin())));
        this.quads[0].add(new Point(new Coord3d(this.bbox.getXmax(), this.bbox.getYmax(), this.bbox.getZmax())));
        this.quads[1] = new Polygon();
        this.quads[1].add(new Point(new Coord3d(this.bbox.getXmin(), this.bbox.getYmax(), this.bbox.getZmax())));
        this.quads[1].add(new Point(new Coord3d(this.bbox.getXmin(), this.bbox.getYmax(), this.bbox.getZmin())));
        this.quads[1].add(new Point(new Coord3d(this.bbox.getXmin(), this.bbox.getYmin(), this.bbox.getZmin())));
        this.quads[1].add(new Point(new Coord3d(this.bbox.getXmin(), this.bbox.getYmin(), this.bbox.getZmax())));
        this.quads[2] = new Polygon();
        this.quads[2].add(new Point(new Coord3d(this.bbox.getXmax(), this.bbox.getYmax(), this.bbox.getZmax())));
        this.quads[2].add(new Point(new Coord3d(this.bbox.getXmax(), this.bbox.getYmax(), this.bbox.getZmin())));
        this.quads[2].add(new Point(new Coord3d(this.bbox.getXmin(), this.bbox.getYmax(), this.bbox.getZmin())));
        this.quads[2].add(new Point(new Coord3d(this.bbox.getXmin(), this.bbox.getYmax(), this.bbox.getZmax())));
        this.quads[3] = new Polygon();
        this.quads[3].add(new Point(new Coord3d(this.bbox.getXmin(), this.bbox.getYmin(), this.bbox.getZmax())));
        this.quads[3].add(new Point(new Coord3d(this.bbox.getXmin(), this.bbox.getYmin(), this.bbox.getZmin())));
        this.quads[3].add(new Point(new Coord3d(this.bbox.getXmax(), this.bbox.getYmin(), this.bbox.getZmin())));
        this.quads[3].add(new Point(new Coord3d(this.bbox.getXmax(), this.bbox.getYmin(), this.bbox.getZmax())));
        this.quads[4] = new Polygon();
        this.quads[4].add(new Point(new Coord3d(this.bbox.getXmin(), this.bbox.getYmin(), this.bbox.getZmax())));
        this.quads[4].add(new Point(new Coord3d(this.bbox.getXmax(), this.bbox.getYmin(), this.bbox.getZmax())));
        this.quads[4].add(new Point(new Coord3d(this.bbox.getXmax(), this.bbox.getYmax(), this.bbox.getZmax())));
        this.quads[4].add(new Point(new Coord3d(this.bbox.getXmin(), this.bbox.getYmax(), this.bbox.getZmax())));
        this.quads[5] = new Polygon();
        this.quads[5].add(new Point(new Coord3d(this.bbox.getXmax(), this.bbox.getYmin(), this.bbox.getZmin())));
        this.quads[5].add(new Point(new Coord3d(this.bbox.getXmin(), this.bbox.getYmin(), this.bbox.getZmin())));
        this.quads[5].add(new Point(new Coord3d(this.bbox.getXmin(), this.bbox.getYmax(), this.bbox.getZmin())));
        this.quads[5].add(new Point(new Coord3d(this.bbox.getXmax(), this.bbox.getYmax(), this.bbox.getZmin())));
    }

    public void setColorMapper(ColorMapper mapper) {
        this.mapper = mapper;
        for (Polygon quad : this.quads) {
            quad.setColorMapper(mapper);
        }
    }

    public ColorMapper getColorMapper() {
        return this.mapper;
    }

    public void setColor(Color color) {
        this.color = color;
        for (Polygon quad : this.quads) {
            quad.setColor(color);
        }
    }

    public Color getColor() {
        return this.color;
    }
}

