/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives;

import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ColorMapper;
import org.jzy3d.colors.IMultiColorable;
import org.jzy3d.colors.ISingleColorable;
import org.jzy3d.events.DrawableChangedEvent;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.Utils;
import org.jzy3d.plot3d.primitives.AbstractComposite;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.AbstractWireframeable;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.rendering.view.Camera;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Polygon
extends AbstractWireframeable
implements ISingleColorable,
IMultiColorable {
    protected PolygonMode polygonMode;
    protected boolean polygonOffsetFillEnable = true;
    protected ColorMapper mapper;
    protected List<Point> points = new ArrayList<Point>(4);
    protected Color color;
    protected Coord3d center;

    public Polygon() {
        this.bbox = new BoundingBox3d();
        this.center = new Coord3d();
        this.polygonOffsetFillEnable = true;
        this.polygonMode = PolygonMode.FRONT_AND_BACK;
    }

    @Override
    public void draw(GL2 gl, GLU glu, Camera cam) {
        if (this.transform != null) {
            this.transform.execute(gl);
        }
        if (this.facestatus) {
            this.applyPolygonModeFill(gl);
            if (this.wfstatus && this.polygonOffsetFillEnable) {
                this.polygonOffseFillEnable(gl);
            }
            gl.glBegin(9);
            for (Point p : this.points) {
                if (this.mapper != null) {
                    Color c = this.mapper.getColor(p.xyz);
                    gl.glColor4f(c.r, c.g, c.b, c.a);
                } else {
                    gl.glColor4f(p.rgb.r, p.rgb.g, p.rgb.b, p.rgb.a);
                }
                gl.glVertex3f(p.xyz.x, p.xyz.y, p.xyz.z);
            }
            gl.glEnd();
            if (this.wfstatus && this.polygonOffsetFillEnable) {
                this.polygonOffsetFillDisable(gl);
            }
        }
        if (this.wfstatus) {
            this.applyPolygonModeLine(gl);
            if (this.polygonOffsetFillEnable) {
                this.polygonOffseFillEnable(gl);
            }
            gl.glColor4f(this.wfcolor.r, this.wfcolor.g, this.wfcolor.b, this.wfcolor.a);
            gl.glLineWidth(this.wfwidth);
            gl.glBegin(9);
            for (Point p : this.points) {
                gl.glVertex3f(p.xyz.x, p.xyz.y, p.xyz.z);
            }
            gl.glEnd();
            if (this.polygonOffsetFillEnable) {
                this.polygonOffsetFillDisable(gl);
            }
        }
    }

    protected void applyPolygonModeLine(GL2 gl) {
        switch (this.polygonMode) {
            case FRONT: {
                gl.glPolygonMode(1028, 6913);
                break;
            }
            case BACK: {
                gl.glPolygonMode(1029, 6913);
                break;
            }
            case FRONT_AND_BACK: {
                gl.glPolygonMode(1032, 6913);
                break;
            }
        }
    }

    protected void applyPolygonModeFill(GL2 gl) {
        switch (this.polygonMode) {
            case FRONT: {
                gl.glPolygonMode(1028, 6914);
                break;
            }
            case BACK: {
                gl.glPolygonMode(1029, 6914);
                break;
            }
            case FRONT_AND_BACK: {
                gl.glPolygonMode(1032, 6914);
                break;
            }
        }
    }

    protected void polygonOffseFillEnable(GL2 gl) {
        gl.glEnable(32823);
        gl.glPolygonOffset(1.0f, 1.0f);
    }

    protected void polygonOffsetFillDisable(GL2 gl) {
        gl.glDisable(32823);
    }

    public void add(Point point) {
        this.points.add(point);
        this.bbox.add(point);
        this.center = new Coord3d();
        for (Point p : this.points) {
            this.center = this.center.add(p.xyz);
        }
        this.center = this.center.div(this.points.size());
    }

    @Override
    public Coord3d getBarycentre() {
        return this.center;
    }

    public Point get(int p) {
        return this.points.get(p);
    }

    public List<Point> getAll() {
        return this.points;
    }

    public int size() {
        return this.points.size();
    }

    @Override
    public double getDistance(Camera camera) {
        return this.getBarycentre().distance(camera.getEye());
    }

    @Override
    public double getShortestDistance(Camera camera) {
        double min = 3.4028234663852886E38;
        double dist = 0.0;
        for (Point point : this.points) {
            dist = point.getDistance(camera);
            if (!(dist < min)) continue;
            min = dist;
        }
        dist = this.getBarycentre().distance(camera.getEye());
        if (dist < min) {
            min = dist;
        }
        return min;
    }

    @Override
    public double getLongestDistance(Camera camera) {
        double max = 0.0;
        double dist = 0.0;
        for (Point point : this.points) {
            dist = point.getDistance(camera);
            if (!(dist > max)) continue;
            max = dist;
        }
        return max;
    }

    public PolygonMode getPolygonMode() {
        return this.polygonMode;
    }

    public void setPolygonMode(PolygonMode polygonMode) {
        this.polygonMode = polygonMode;
    }

    public boolean isPolygonOffsetFillEnable() {
        return this.polygonOffsetFillEnable;
    }

    public void setPolygonOffsetFillEnable(boolean polygonOffsetFillEnable) {
        this.polygonOffsetFillEnable = polygonOffsetFillEnable;
    }

    public static void setPolygonOffsetFillEnable(AbstractComposite composite, boolean polygonOffsetFillEnable) {
        for (AbstractDrawable d : composite.getDrawables()) {
            if (d instanceof Polygon) {
                ((Polygon)d).setPolygonOffsetFillEnable(polygonOffsetFillEnable);
                continue;
            }
            if (!(d instanceof AbstractComposite)) continue;
            Polygon.setPolygonOffsetFillEnable((AbstractComposite)d, polygonOffsetFillEnable);
        }
    }

    @Override
    public void setColorMapper(ColorMapper mapper) {
        this.mapper = mapper;
        this.fireDrawableChanged(new DrawableChangedEvent(this, 2));
    }

    @Override
    public ColorMapper getColorMapper() {
        return this.mapper;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
        for (Point p : this.points) {
            p.setColor(color);
        }
        this.fireDrawableChanged(new DrawableChangedEvent(this, 2));
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public String toString(int depth) {
        return Utils.blanks(depth) + "(" + this.getClass().getSimpleName() + ") #points:" + this.points.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PolygonMode {
        FRONT,
        BACK,
        FRONT_AND_BACK;

    }
}

