/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.axes;

import com.jogamp.common.nio.Buffers;
import java.nio.FloatBuffer;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.plot3d.primitives.axes.AxeBox;
import org.jzy3d.plot3d.primitives.axes.IAxe;
import org.jzy3d.plot3d.primitives.axes.layout.IAxeLayout;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.rendering.view.modes.ViewPositionMode;
import org.jzy3d.plot3d.text.align.Halign;
import org.jzy3d.plot3d.text.align.Valign;

public class FeedbackBufferAxeBox
extends AxeBox
implements IAxe {
    public FeedbackBufferAxeBox(BoundingBox3d bbox) {
        super(bbox);
    }

    public FeedbackBufferAxeBox(BoundingBox3d bbox, IAxeLayout layout) {
        super(bbox, layout);
    }

    public void draw(GL2 gl, GLU glu, Camera camera) {
        int zselect;
        BoundingBox3d bbox;
        gl.glLoadIdentity();
        gl.glScalef(this.scale.x, this.scale.y, this.scale.z);
        gl.glEnable(2884);
        gl.glFrontFace(2305);
        gl.glCullFace(1028);
        this.quadIsHidden = this.getHiddenQuads(gl);
        if (this.layout.isFaceDisplayed()) {
            Color quadcolor = this.layout.getQuadColor();
            gl.glPolygonMode(1029, 6914);
            gl.glColor4f(quadcolor.r, quadcolor.g, quadcolor.b, quadcolor.a);
            gl.glLineWidth(1.0f);
            gl.glEnable(32823);
            gl.glPolygonOffset(1.0f, 1.0f);
            this.drawCube(gl, 7168);
            gl.glDisable(32823);
        }
        Color gridcolor = this.layout.getGridColor();
        gl.glPolygonMode(1029, 6913);
        gl.glColor4f(gridcolor.r, gridcolor.g, gridcolor.b, gridcolor.a);
        gl.glLineWidth(1.0f);
        this.drawCube(gl, 7168);
        gl.glPolygonMode(1029, 6913);
        gl.glColor4f(gridcolor.r, gridcolor.g, gridcolor.b, gridcolor.a);
        gl.glLineWidth(1.0f);
        gl.glLineStipple(1, (short)-21846);
        gl.glEnable(2852);
        for (int quad = 0; quad < 6; ++quad) {
            if (this.quadIsHidden[quad]) continue;
            this.drawGridOnQuad(gl, quad);
        }
        gl.glDisable(2852);
        this.wholeBounds.reset();
        this.wholeBounds.add(this.boxBounds);
        if (this.xrange > 0.0f && this.layout.isXTickLabelDisplayed()) {
            if (this.view != null && this.view.getViewMode().equals((Object)ViewPositionMode.TOP)) {
                BoundingBox3d bbox2 = this.drawTicks(gl, glu, camera, 1, 0, this.layout.getXTickColor(), Halign.LEFT, Valign.TOP);
                this.wholeBounds.add(bbox2);
            } else {
                int xselect = this.findClosestXaxe(camera);
                if (xselect >= 0) {
                    bbox = this.drawTicks(gl, glu, camera, xselect, 0, this.layout.getXTickColor());
                    this.wholeBounds.add(bbox);
                } else {
                    bbox = this.drawTicks(gl, glu, camera, 2, 0, this.layout.getXTickColor(), Halign.CENTER, Valign.TOP);
                    this.wholeBounds.add(bbox);
                }
            }
        }
        if (this.yrange > 0.0f && this.layout.isYTickLabelDisplayed()) {
            if (this.view != null && this.view.getViewMode().equals((Object)ViewPositionMode.TOP)) {
                BoundingBox3d bbox3 = this.drawTicks(gl, glu, camera, 2, 1, this.layout.getYTickColor(), Halign.LEFT, Valign.GROUND);
                this.wholeBounds.add(bbox3);
            } else {
                int yselect = this.findClosestYaxe(camera);
                if (yselect >= 0) {
                    bbox = this.drawTicks(gl, glu, camera, yselect, 1, this.layout.getYTickColor());
                    this.wholeBounds.add(bbox);
                } else {
                    bbox = this.drawTicks(gl, glu, camera, 1, 1, this.layout.getYTickColor(), Halign.RIGHT, Valign.GROUND);
                    this.wholeBounds.add(bbox);
                }
            }
        }
        if (this.zrange > 0.0f && this.layout.isZTickLabelDisplayed() && (this.view == null || !this.view.getViewMode().equals((Object)ViewPositionMode.TOP)) && (zselect = this.findClosestZaxe(camera)) >= 0) {
            bbox = this.drawTicks(gl, glu, camera, zselect, 2, this.layout.getZTickColor());
            this.wholeBounds.add(bbox);
        }
        gl.glDisable(2884);
    }

    protected void drawCube(GL2 gl, int mode) {
        for (int q = 0; q < 6; ++q) {
            if (mode == 7169) {
                gl.glPassThrough((float)q);
            }
            gl.glBegin(7);
            for (int v = 0; v < 4; ++v) {
                gl.glVertex3f(this.quadx[q][v], this.quady[q][v], this.quadz[q][v]);
            }
            gl.glEnd();
        }
    }

    protected boolean[] getHiddenQuads(GL2 gl) {
        int feedbacklength = 1024;
        FloatBuffer floatbuffer = Buffers.newDirectFloatBuffer((int)feedbacklength);
        float[] feedback = new float[feedbacklength];
        gl.glFeedbackBuffer(feedbacklength, 1538, floatbuffer);
        gl.glRenderMode(7169);
        this.drawCube(gl, 7169);
        gl.glRenderMode(7168);
        floatbuffer.get(feedback);
        return this.getEmptyTokens(6, feedback, feedbacklength);
    }

    protected boolean[] getEmptyTokens(int ntokens, float[] buffer, int size) {
        boolean[] isempty = new boolean[ntokens];
        boolean printout = false;
        int count = size;
        float prevtoken_type = Float.NaN;
        float passthrough_value = Float.NaN;
        float prevpassthrough_value = Float.NaN;
        float EMPTY_TOKEN = 0.0f;
        while (count > 0) {
            int prevtoken_id;
            float token_type = buffer[size - count];
            --count;
            if (token_type == 1792.0f) {
                passthrough_value = buffer[size - count];
                --count;
                if (printout) {
                    System.out.println("GL.GL_PASS_THROUGH_TOKEN: " + passthrough_value);
                }
                if (!Float.isNaN(prevpassthrough_value)) {
                    prevtoken_id = (int)prevpassthrough_value;
                    isempty[prevtoken_id] = token_type == prevtoken_type;
                }
                prevpassthrough_value = passthrough_value;
            } else if (token_type == 1793.0f) {
                if (printout) {
                    System.out.println(" GL.GL_POINT_TOKEN");
                    count = this.print3DcolorVertex(size, count, buffer);
                } else {
                    count -= 7;
                }
            } else if (token_type == 1794.0f) {
                if (printout) {
                    System.out.println(" GL.GL_LINE_TOKEN ");
                    count = this.print3DcolorVertex(size, count, buffer);
                    count = this.print3DcolorVertex(size, count, buffer);
                } else {
                    count -= 14;
                }
            } else if (token_type == 1799.0f) {
                if (printout) {
                    System.out.println(" GL.GL_LINE_RESET_TOKEN ");
                    count = this.print3DcolorVertex(size, count, buffer);
                    count = this.print3DcolorVertex(size, count, buffer);
                } else {
                    count -= 14;
                }
            } else if (token_type == 1795.0f) {
                int n = (int)buffer[size - count];
                --count;
                if (printout) {
                    System.out.println(" GL.GL_POLYGON_TOKEN: " + n + " vertices");
                }
                for (int i = 0; i < n; ++i) {
                    if (printout) {
                        count = this.print3DcolorVertex(size, count, buffer);
                        continue;
                    }
                    count -= 7;
                }
            } else {
                if (token_type == EMPTY_TOKEN) {
                    if (prevtoken_type != 1792.0f) break;
                    prevtoken_id = (int)prevpassthrough_value;
                    isempty[prevtoken_id] = true;
                    break;
                }
                if (token_type == 1796.0f) {
                    throw new RuntimeException("Unknown token:" + token_type + ". This function is not intended to work with GL_BITMAP_TOKEN.");
                }
                if (token_type == 1797.0f) {
                    throw new RuntimeException("Unknown token:" + token_type + ". This function is not intended to work with GL_DRAW_PIXEL_TOKEN.");
                }
                if (token_type == 1798.0f) {
                    throw new RuntimeException("Unknown token:" + token_type + ". This function is not intended to work with GL_COPY_PIXEL_TOKEN.");
                }
                throw new RuntimeException("Unknown token type: " + token_type + "\n count= " + count);
            }
            prevtoken_type = token_type;
        }
        return isempty;
    }

    protected int print3DcolorVertex(int size, int count, float[] buffer) {
        int id = size - count;
        int veclength = 7;
        System.out.print("  [" + id + "]");
        for (int i = 0; i < veclength; ++i) {
            System.out.print(" " + buffer[size - count]);
            --count;
        }
        System.out.println();
        return count;
    }

    protected void printHiddenQuads() {
        for (int t = 0; t < this.quadIsHidden.length; ++t) {
            if (this.quadIsHidden[t]) {
                System.out.println("Quad[" + t + "] is not displayed");
                continue;
            }
            System.out.println("Quad[" + t + "] is displayed");
        }
    }
}

