/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.axes.layout;

import org.jzy3d.colors.Color;
import org.jzy3d.plot3d.primitives.axes.layout.IAxeLayout;
import org.jzy3d.plot3d.primitives.axes.layout.providers.ITickProvider;
import org.jzy3d.plot3d.primitives.axes.layout.providers.SmartTickProvider;
import org.jzy3d.plot3d.primitives.axes.layout.renderers.DefaultDecimalTickRenderer;
import org.jzy3d.plot3d.primitives.axes.layout.renderers.ITickRenderer;

public class AxeBoxLayout
implements IAxeLayout {
    protected String xAxeLabel;
    protected String yAxeLabel;
    protected String zAxeLabel;
    protected boolean xAxeLabelDisplayed;
    protected boolean yAxeLabelDisplayed;
    protected boolean zAxeLabelDisplayed;
    protected float[] xTicks;
    protected float[] yTicks;
    protected float[] zTicks;
    protected ITickProvider xTickProvider;
    protected ITickProvider yTickProvider;
    protected ITickProvider zTickProvider;
    protected ITickRenderer xTickRenderer;
    protected ITickRenderer yTickRenderer;
    protected ITickRenderer zTickRenderer;
    protected Color xTickColor;
    protected Color yTickColor;
    protected Color zTickColor;
    protected boolean xTickLabelDisplayed;
    protected boolean yTickLabelDisplayed;
    protected boolean zTickLabelDisplayed;
    protected boolean faceDisplayed;
    protected Color quadColor;
    protected Color gridColor;
    protected float lastXmin = Float.NaN;
    protected float lastXmax = Float.NaN;
    protected float lastYmin = Float.NaN;
    protected float lastYmax = Float.NaN;
    protected float lastZmin = Float.NaN;
    protected float lastZmax = Float.NaN;
    protected Color mainColor;

    public AxeBoxLayout() {
        this.setXAxeLabel("X");
        this.setYAxeLabel("Y");
        this.setZAxeLabel("Z");
        this.setXAxeLabelDisplayed(true);
        this.setYAxeLabelDisplayed(true);
        this.setZAxeLabelDisplayed(true);
        this.setXTickProvider(new SmartTickProvider(5));
        this.setYTickProvider(new SmartTickProvider(5));
        this.setZTickProvider(new SmartTickProvider(6));
        this.setXTickRenderer(new DefaultDecimalTickRenderer(4));
        this.setYTickRenderer(new DefaultDecimalTickRenderer(4));
        this.setZTickRenderer(new DefaultDecimalTickRenderer(6));
        this.setFaceDisplayed(false);
        this.setXTickLabelDisplayed(true);
        this.setYTickLabelDisplayed(true);
        this.setZTickLabelDisplayed(true);
        this.setMainColor(Color.BLACK);
    }

    public void setMainColor(Color color) {
        this.mainColor = color;
        this.setXTickColor(color);
        this.setYTickColor(color);
        this.setZTickColor(color);
        this.setGridColor(color);
        this.setQuadColor(color.negative());
    }

    public Color getMainColor() {
        return this.mainColor;
    }

    public float[] getXTicks(float min, float max) {
        this.lastXmin = min;
        this.lastXmax = max;
        this.xTicks = this.xTickProvider.generateTicks(min, max);
        return this.xTicks;
    }

    public float[] getYTicks(float min, float max) {
        this.lastYmin = min;
        this.lastYmax = max;
        this.yTicks = this.yTickProvider.generateTicks(min, max);
        return this.yTicks;
    }

    public float[] getZTicks(float min, float max) {
        this.lastZmin = min;
        this.lastZmax = max;
        this.zTicks = this.zTickProvider.generateTicks(min, max);
        return this.zTicks;
    }

    public String getXAxeLabel() {
        return this.xAxeLabel;
    }

    public void setXAxeLabel(String axeLabel) {
        this.xAxeLabel = axeLabel;
    }

    public String getYAxeLabel() {
        return this.yAxeLabel;
    }

    public void setYAxeLabel(String axeLabel) {
        this.yAxeLabel = axeLabel;
    }

    public String getZAxeLabel() {
        return this.zAxeLabel;
    }

    public void setZAxeLabel(String axeLabel) {
        this.zAxeLabel = axeLabel;
    }

    public float[] getXTicks() {
        return this.xTicks;
    }

    public float[] getYTicks() {
        return this.yTicks;
    }

    public float[] getZTicks() {
        return this.zTicks;
    }

    public ITickProvider getXTickProvider() {
        return this.xTickProvider;
    }

    public void setXTickProvider(ITickProvider tickProvider) {
        this.xTickProvider = tickProvider;
        if (this.lastXmin != Float.NaN) {
            this.getXTicks(this.lastXmin, this.lastXmax);
        }
    }

    public ITickProvider getYTickProvider() {
        return this.yTickProvider;
    }

    public void setYTickProvider(ITickProvider tickProvider) {
        this.yTickProvider = tickProvider;
        if (this.lastYmin != Float.NaN) {
            this.getYTicks(this.lastYmin, this.lastYmax);
        }
    }

    public ITickProvider getZTickProvider() {
        return this.zTickProvider;
    }

    public void setZTickProvider(ITickProvider tickProvider) {
        this.zTickProvider = tickProvider;
        if (this.lastZmin != Float.NaN) {
            this.getZTicks(this.lastZmin, this.lastZmax);
        }
    }

    public ITickRenderer getXTickRenderer() {
        return this.xTickRenderer;
    }

    public void setXTickRenderer(ITickRenderer tickRenderer) {
        this.xTickRenderer = tickRenderer;
    }

    public ITickRenderer getYTickRenderer() {
        return this.yTickRenderer;
    }

    public void setYTickRenderer(ITickRenderer tickRenderer) {
        this.yTickRenderer = tickRenderer;
    }

    public ITickRenderer getZTickRenderer() {
        return this.zTickRenderer;
    }

    public void setZTickRenderer(ITickRenderer tickRenderer) {
        this.zTickRenderer = tickRenderer;
    }

    public Color getXTickColor() {
        return this.xTickColor;
    }

    public void setXTickColor(Color tickColor) {
        this.xTickColor = tickColor;
    }

    public Color getYTickColor() {
        return this.yTickColor;
    }

    public void setYTickColor(Color tickColor) {
        this.yTickColor = tickColor;
    }

    public Color getZTickColor() {
        return this.zTickColor;
    }

    public void setZTickColor(Color tickColor) {
        this.zTickColor = tickColor;
    }

    public boolean isFaceDisplayed() {
        return this.faceDisplayed;
    }

    public void setFaceDisplayed(boolean faceDisplayed) {
        this.faceDisplayed = faceDisplayed;
    }

    public Color getQuadColor() {
        return this.quadColor;
    }

    public void setQuadColor(Color quadColor) {
        this.quadColor = quadColor;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color gridColor) {
        this.gridColor = gridColor;
    }

    public boolean isXAxeLabelDisplayed() {
        return this.xAxeLabelDisplayed;
    }

    public void setXAxeLabelDisplayed(boolean axeLabelDisplayed) {
        this.xAxeLabelDisplayed = axeLabelDisplayed;
    }

    public boolean isYAxeLabelDisplayed() {
        return this.yAxeLabelDisplayed;
    }

    public void setYAxeLabelDisplayed(boolean axeLabelDisplayed) {
        this.yAxeLabelDisplayed = axeLabelDisplayed;
    }

    public boolean isZAxeLabelDisplayed() {
        return this.zAxeLabelDisplayed;
    }

    public void setZAxeLabelDisplayed(boolean axeLabelDisplayed) {
        this.zAxeLabelDisplayed = axeLabelDisplayed;
    }

    public boolean isXTickLabelDisplayed() {
        return this.xTickLabelDisplayed;
    }

    public void setXTickLabelDisplayed(boolean tickLabelDisplayed) {
        this.xTickLabelDisplayed = tickLabelDisplayed;
    }

    public boolean isYTickLabelDisplayed() {
        return this.yTickLabelDisplayed;
    }

    public void setYTickLabelDisplayed(boolean tickLabelDisplayed) {
        this.yTickLabelDisplayed = tickLabelDisplayed;
    }

    public boolean isZTickLabelDisplayed() {
        return this.zTickLabelDisplayed;
    }

    public void setZTickLabelDisplayed(boolean tickLabelDisplayed) {
        this.zTickLabelDisplayed = tickLabelDisplayed;
    }
}

