/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.axes.layout.providers;

import org.jzy3d.plot3d.primitives.axes.layout.providers.AbstractTickProvider;
import org.jzy3d.plot3d.primitives.axes.layout.providers.ITickProvider;

public class SmartTickProvider
extends AbstractTickProvider
implements ITickProvider {
    protected int steps;

    public SmartTickProvider() {
        this(5);
    }

    public SmartTickProvider(int steps) {
        this.steps = steps;
    }

    public float[] generateTicks(float min, float max, int steps) {
        if (min == max) {
            float[] ticks = new float[]{min};
            return ticks;
        }
        if (min > max) {
            return new float[0];
        }
        double absscale = Math.floor(Math.log10(max - min));
        double relscale = Math.log10(max - min) - absscale;
        float ticksize = 0.0f;
        ticksize = relscale < Math.log10(0.2 * (double)steps) ? (float)(Math.pow(10.0, absscale) * 0.2) : (relscale < Math.log10(0.5 * (double)steps) ? (float)(Math.pow(10.0, absscale) * 0.5) : (relscale < Math.log10(1 * steps) ? (float)Math.pow(10.0, absscale) * 1.0f : (float)Math.pow(10.0, absscale) * 2.0f));
        int start = (int)Math.ceil(min / ticksize);
        int stop = (int)Math.floor(max / ticksize);
        float[] ticks = new float[stop - start + 1];
        for (int t = start; t <= stop; ++t) {
            ticks[t - start] = (float)t * ticksize;
        }
        return ticks;
    }

    public int getDefaultSteps() {
        return this.steps;
    }
}

