/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.contour;

import java.util.ArrayList;
import java.util.List;
import org.jzy3d.contour.MapperContourPictureGenerator;
import org.jzy3d.plot3d.primitives.AbstractComposite;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.LineStrip;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.primitives.contour.DefaultLineStripMergePolicy;
import org.jzy3d.plot3d.primitives.contour.ILineStripMergePolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContourLevel
extends AbstractComposite {
    protected ILineStripMergePolicy policy = new DefaultLineStripMergePolicy(MapperContourPictureGenerator.MERGE_STRIP_DIST);
    protected int id;
    protected float value;
    protected List<LineStrip> lines = new ArrayList<LineStrip>();

    public ContourLevel() {
        this.lines = new ArrayList<LineStrip>();
    }

    public ContourLevel(float value) {
        this.value = value;
        this.lines = new ArrayList<LineStrip>();
    }

    public ContourLevel(int id, float value, List<LineStrip> lines) {
        this.id = id;
        this.value = value;
        this.lines = lines;
        this.updateComponents();
    }

    public int getId() {
        return this.id;
    }

    public float getValue() {
        return this.value;
    }

    public List<LineStrip> getLines() {
        return this.lines;
    }

    public void appendLine(LineStrip strip) {
        LineStrip friend = this.policy.mostMergeableIfAny(strip, this.lines);
        if (friend != null) {
            int fid = this.lines.indexOf(friend);
            friend = LineStrip.merge(strip, friend);
            this.lines.set(fid, friend);
        } else {
            this.lines.add(strip);
        }
        this.updateComponents();
    }

    public void fixZ(float value) {
        for (AbstractDrawable d : this.components) {
            LineStrip line = (LineStrip)d;
            for (Point point : line.getPoints()) {
                point.xyz.z = value;
            }
        }
    }

    protected void updateComponents() {
        this.components.clear();
        for (LineStrip strip : this.lines) {
            this.components.add(strip);
        }
    }
}

